/*
 * Decompiled with CFR 0.152.
 */
package br.gov.sp.tce.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.ConcursoModalidade;

public enum TipoProcessoSelecaoAudesp {
    CONCURSO_PUBLICO_EFETIVO((short)1, "ConcursoEfetivo", "Concurso P\u00fablico Efetivo"),
    CONCURSO_PUBLICO_TEMPORARIO((short)2, "ConcursoTemporario", "Concurso P\u00fablico Tempor\u00e1rio"),
    PROCESSO_SELETIVO_SIMPLIFICADO((short)3, "ProcessoSimplificado", "Processo Seletivo Simplificado");

    private final Short codigo;
    private final String nomeArquivo;
    private final String descricao;

    private TipoProcessoSelecaoAudesp(Short codigo, String nomeArquivo, String descricao) {
        this.codigo = codigo;
        this.nomeArquivo = nomeArquivo;
        this.descricao = descricao;
    }

    public Short getCodigo() {
        return this.codigo;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static TipoProcessoSelecaoAudesp fromModalidade(ConcursoModalidade modalidade) {
        if (modalidade != null) {
            switch (modalidade) {
                case PROCESSO_SELETIVO_PUBLICO_PELA_UG: 
                case PROCESSO_SELETIVO_PUBLICO_POR_OUTRA_UG: {
                    return CONCURSO_PUBLICO_TEMPORARIO;
                }
                case PROCESSO_SELETIVO_SIMPLIFICADO_PELA_UG: 
                case PROCESSO_SELETIVO_SIMPLIFICADO_POR_OUTRA_UG: {
                    return PROCESSO_SELETIVO_SIMPLIFICADO;
                }
            }
            return CONCURSO_PUBLICO_EFETIVO;
        }
        return null;
    }

    public boolean isConcursoEfetivo() {
        return this == CONCURSO_PUBLICO_EFETIVO;
    }
}

