/*
 * Decompiled with CFR 0.152.
 */
package br.gov.mg.tce.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.gov.mg.tce.persistence.entity.RequisitoCargoTceMg;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SIPMG_CARGO")
public class SipMgCargo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private int id;
    @NotNull
    @Column(name="REQUISITO")
    private Integer requisitoCodigo;
    @Transient
    private RequisitoCargoTceMg requisito;
    @Type(type="BooleanTypeSip")
    @Column(name="ENVIAR_TCE")
    private Boolean enviarTce;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA"), @JoinColumn(name="CARGO", referencedColumnName="CODIGO")})
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargo;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Integer getRequisitoCodigo() {
        return this.requisitoCodigo;
    }

    public void setRequisitoCodigo(Integer requisitoCodigo) {
        this.requisitoCodigo = requisitoCodigo;
    }

    public RequisitoCargoTceMg getRequisito() {
        return this.requisito == null ? RequisitoCargoTceMg.getBy(this.requisitoCodigo) : this.requisito;
    }

    public void setRequisito(RequisitoCargoTceMg requisito) {
        this.requisito = requisito;
        if (requisito != null) {
            try {
                this.requisitoCodigo = Integer.parseInt(requisito.getCodigo());
            }
            catch (Exception e) {
                this.requisitoCodigo = null;
            }
        }
    }

    public Boolean getEnviarTce() {
        return this.enviarTce;
    }

    public void setEnviarTce(Boolean enviarTce) {
        this.enviarTce = enviarTce;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        this.cargo = cargo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipMgCargo other = (SipMgCargo)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "SipMgCargo [id=" + this.id + "]";
    }
}

