/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo.ws;

import br.com.fiorilli.sip.persistence.entity.Movimento;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import br.com.fiorilli.sipweb.vo.ws.EventoWsVo;
import br.com.fiorilli.sipweb.vo.ws.ReferenciaMinWsVo;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="calculo")
@XmlType(propOrder={"trabalhador", "referencia", "evento", "quantidade", "porcentagem", "referenciaHolerite", "valor"})
public class MovimentoWsVo {
    public static final String SQL_FIND_BY_CODIGO_OR_CLASSIFICACAO = "SELECT new " + MovimentoWsVo.class.getName() + "(m) " + "   FROM Movimento m " + "WHERE m.entidadeCodigo = :entidade " + "   AND ((coalesce(m.evento.classificacao, '00') = :classificacao) OR (m.evento.eventoPK.codigo = :evento)) " + "   AND m.referencia.mesCodigo = :mes " + "   AND m.referencia.ano = :ano " + "   AND m.referencia.tipo = :tipo " + "   ORDER BY m.evento, m.trabalhador ";
    private TrabalhadorPK trabalhador;
    private ReferenciaMinWsVo referencia;
    private EventoWsVo evento;
    private Double quantidade;
    private Double porcentagem;
    private String referenciaHolerite;
    private Double valor;

    public MovimentoWsVo() {
    }

    public MovimentoWsVo(Movimento movimento) {
        this.trabalhador = movimento.getTrabalhador().getTrabalhadorPK();
        this.referencia = new ReferenciaMinWsVo(movimento.getReferencia());
        this.evento = new EventoWsVo(movimento.getEvento());
        this.quantidade = movimento.getQuantidade();
        this.porcentagem = movimento.getPorcentagem();
        this.referenciaHolerite = movimento.getRefhollerit();
        this.valor = movimento.getValor();
    }

    @XmlAttribute
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @XmlAttribute
    public String getReferenciaHolerite() {
        return this.referenciaHolerite;
    }

    public void setReferenciaHolerite(String referenciaHolerite) {
        this.referenciaHolerite = referenciaHolerite;
    }

    @XmlAttribute
    public Double getPorcentagem() {
        return this.porcentagem;
    }

    public void setPorcentagem(Double porcentagem) {
        this.porcentagem = porcentagem;
    }

    @XmlAttribute
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public EventoWsVo getEvento() {
        return this.evento;
    }

    public void setEvento(EventoWsVo evento) {
        this.evento = evento;
    }

    public ReferenciaMinWsVo getReferencia() {
        return this.referencia;
    }

    public void setReferencia(ReferenciaMinWsVo referencia) {
        this.referencia = referencia;
    }

    public TrabalhadorPK getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(TrabalhadorPK trabalhador) {
        this.trabalhador = trabalhador;
    }
}

