/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo.ws;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.Siplog;
import br.com.fiorilli.sipweb.vo.FrequenciaVO;
import java.util.Date;

public class FrequenciaRegistrosWsVO {
    private String entidade;
    private String registro;
    private Date dataInicial;
    private Date dataFinal;
    private String tipo;
    private String chave;
    private Integer matricula;
    private Short contrato;
    private String cpf;
    private Date data;
    private String logText;
    private Date hora;

    public FrequenciaRegistrosWsVO(Object[] objects) {
        this.entidade = objects[0].toString();
        this.registro = objects[1].toString();
        this.dataInicial = (Date)objects[2];
        this.dataFinal = (Date)objects[3];
        this.tipo = objects[4].toString();
        this.chave = objects[5].toString();
        this.matricula = Integer.parseInt(objects[6].toString());
        this.contrato = Short.parseShort(objects[7].toString());
        this.cpf = objects[8].toString();
        this.data = (Date)objects[9];
        this.logText = objects[10].toString();
        this.hora = (Date)objects[11];
    }

    public FrequenciaVO toFrequenciaVO() {
        return new FrequenciaVO(this.entidade, this.registro, this.dataInicial, this.dataFinal, this.tipo, this.chave, this.matricula, this.contrato, this.cpf, this.getDataHora());
    }

    public Siplog toSiplog() {
        return new Siplog(this.getDataHora(), this.logText, this.chave, Integer.parseInt(this.tipo));
    }

    private Date getDataHora() {
        try {
            if (this.data != null && this.hora != null) {
                return SIPDateUtil.toDateWithFullTime((String)SIPDateUtil.toString((Date)this.data).concat(" ").concat(SIPDateUtil.toString((String)"HH:mm:ss", (Date)this.hora)));
            }
            return this.data;
        }
        catch (Exception e) {
            return this.data;
        }
    }

    public String getEntidade() {
        return this.entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public String getTipo() {
        return this.tipo;
    }

    public String getChave() {
        return this.chave;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getCpf() {
        return this.cpf;
    }

    public Date getData() {
        return this.data;
    }

    public String getLogText() {
        return this.logText;
    }

    public Date getHora() {
        return this.hora;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public void setMatricula(Integer matricula) {
        this.matricula = matricula;
    }

    public void setContrato(Short contrato) {
        this.contrato = contrato;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void setLogText(String logText) {
        this.logText = logText;
    }

    public void setHora(Date hora) {
        this.hora = hora;
    }

    public FrequenciaRegistrosWsVO() {
    }
}

