/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo.ws;

import br.com.fiorilli.sip.persistence.entity.EventoClassificacao;
import br.com.fiorilli.sip.persistence.entity.TipoLancamentoEvento;
import br.com.fiorilli.sip.persistence.entity.TipoLancamentoEventuaisExterno;
import br.com.fiorilli.sipweb.vo.TipoIdentificacaoTrabalhadorVO;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="evento")
public class EventuaisWsVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Size(min=3, max=3)
    @NotNull
    private String codigoEntidade;
    @Size(min=3, max=3)
    @NotNull
    private String codigoEvento;
    @NotNull
    private String identificacaoTrabalhador;
    @NotNull
    private TipoLancamentoEventuaisExterno tipoLancamento;
    @NotNull
    private TipoIdentificacaoTrabalhadorVO tipoIdentificacaoTrabalhador;
    @NotNull
    private Double valor;
    @NotNull
    private Date data;
    private String nome;
    private Integer mesReferencia;
    private Integer anoReferencia;

    public EventuaisWsVo() {
    }

    public EventuaisWsVo(String entidade, String codigo, String nome, Short tipoLancamento, String classificacao, String utilizarFormula) {
        boolean isUtilizaFormula;
        this.codigoEntidade = entidade;
        this.codigoEvento = codigo;
        this.nome = nome;
        TipoLancamentoEvento tipoLancamentoEvento = TipoLancamentoEvento.toEntity(tipoLancamento);
        EventoClassificacao classificacaoEvento = EventoClassificacao.parse(classificacao);
        boolean bl = isUtilizaFormula = utilizarFormula != null && "S".equals(utilizarFormula);
        this.tipoLancamento = !isUtilizaFormula ? TipoLancamentoEventuaisExterno.VALOR : ((tipoLancamentoEvento.isIndefinido() || tipoLancamentoEvento.isFormula()) && isUtilizaFormula ? (classificacaoEvento.isFalta() ? TipoLancamentoEventuaisExterno.HORA : TipoLancamentoEventuaisExterno.TODOS) : TipoLancamentoEventuaisExterno.getTipoLancamentoEventoCorrespondente(tipoLancamentoEvento));
    }

    public String getCodigoEntidade() {
        return this.codigoEntidade;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public String getIdentificacaoTrabalhador() {
        return this.identificacaoTrabalhador;
    }

    public TipoLancamentoEventuaisExterno getTipoLancamento() {
        return this.tipoLancamento;
    }

    public TipoIdentificacaoTrabalhadorVO getTipoIdentificacaoTrabalhador() {
        return this.tipoIdentificacaoTrabalhador;
    }

    public Double getValor() {
        return this.valor;
    }

    public Date getData() {
        return this.data;
    }

    public String getNome() {
        return this.nome;
    }

    public Integer getMesReferencia() {
        return this.mesReferencia;
    }

    public Integer getAnoReferencia() {
        return this.anoReferencia;
    }

    public void setCodigoEntidade(String codigoEntidade) {
        this.codigoEntidade = codigoEntidade;
    }

    public void setCodigoEvento(String codigoEvento) {
        this.codigoEvento = codigoEvento;
    }

    public void setIdentificacaoTrabalhador(String identificacaoTrabalhador) {
        this.identificacaoTrabalhador = identificacaoTrabalhador;
    }

    public void setTipoLancamento(TipoLancamentoEventuaisExterno tipoLancamento) {
        this.tipoLancamento = tipoLancamento;
    }

    public void setTipoIdentificacaoTrabalhador(TipoIdentificacaoTrabalhadorVO tipoIdentificacaoTrabalhador) {
        this.tipoIdentificacaoTrabalhador = tipoIdentificacaoTrabalhador;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setMesReferencia(Integer mesReferencia) {
        this.mesReferencia = mesReferencia;
    }

    public void setAnoReferencia(Integer anoReferencia) {
        this.anoReferencia = anoReferencia;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventuaisWsVo)) {
            return false;
        }
        EventuaisWsVo other = (EventuaisWsVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$codigoEntidade = this.getCodigoEntidade();
        String other$codigoEntidade = other.getCodigoEntidade();
        if (this$codigoEntidade == null ? other$codigoEntidade != null : !this$codigoEntidade.equals(other$codigoEntidade)) {
            return false;
        }
        String this$codigoEvento = this.getCodigoEvento();
        String other$codigoEvento = other.getCodigoEvento();
        if (this$codigoEvento == null ? other$codigoEvento != null : !this$codigoEvento.equals(other$codigoEvento)) {
            return false;
        }
        String this$identificacaoTrabalhador = this.getIdentificacaoTrabalhador();
        String other$identificacaoTrabalhador = other.getIdentificacaoTrabalhador();
        if (this$identificacaoTrabalhador == null ? other$identificacaoTrabalhador != null : !this$identificacaoTrabalhador.equals(other$identificacaoTrabalhador)) {
            return false;
        }
        TipoLancamentoEventuaisExterno this$tipoLancamento = this.getTipoLancamento();
        TipoLancamentoEventuaisExterno other$tipoLancamento = other.getTipoLancamento();
        if (this$tipoLancamento == null ? other$tipoLancamento != null : !((Object)((Object)this$tipoLancamento)).equals((Object)other$tipoLancamento)) {
            return false;
        }
        TipoIdentificacaoTrabalhadorVO this$tipoIdentificacaoTrabalhador = this.getTipoIdentificacaoTrabalhador();
        TipoIdentificacaoTrabalhadorVO other$tipoIdentificacaoTrabalhador = other.getTipoIdentificacaoTrabalhador();
        if (this$tipoIdentificacaoTrabalhador == null ? other$tipoIdentificacaoTrabalhador != null : !((Object)((Object)this$tipoIdentificacaoTrabalhador)).equals((Object)other$tipoIdentificacaoTrabalhador)) {
            return false;
        }
        Double this$valor = this.getValor();
        Double other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        Date this$data = this.getData();
        Date other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        Integer this$mesReferencia = this.getMesReferencia();
        Integer other$mesReferencia = other.getMesReferencia();
        if (this$mesReferencia == null ? other$mesReferencia != null : !((Object)this$mesReferencia).equals(other$mesReferencia)) {
            return false;
        }
        Integer this$anoReferencia = this.getAnoReferencia();
        Integer other$anoReferencia = other.getAnoReferencia();
        return !(this$anoReferencia == null ? other$anoReferencia != null : !((Object)this$anoReferencia).equals(other$anoReferencia));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventuaisWsVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $codigoEntidade = this.getCodigoEntidade();
        result = result * 59 + ($codigoEntidade == null ? 43 : $codigoEntidade.hashCode());
        String $codigoEvento = this.getCodigoEvento();
        result = result * 59 + ($codigoEvento == null ? 43 : $codigoEvento.hashCode());
        String $identificacaoTrabalhador = this.getIdentificacaoTrabalhador();
        result = result * 59 + ($identificacaoTrabalhador == null ? 43 : $identificacaoTrabalhador.hashCode());
        TipoLancamentoEventuaisExterno $tipoLancamento = this.getTipoLancamento();
        result = result * 59 + ($tipoLancamento == null ? 43 : ((Object)((Object)$tipoLancamento)).hashCode());
        TipoIdentificacaoTrabalhadorVO $tipoIdentificacaoTrabalhador = this.getTipoIdentificacaoTrabalhador();
        result = result * 59 + ($tipoIdentificacaoTrabalhador == null ? 43 : ((Object)((Object)$tipoIdentificacaoTrabalhador)).hashCode());
        Double $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        Date $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        Integer $mesReferencia = this.getMesReferencia();
        result = result * 59 + ($mesReferencia == null ? 43 : ((Object)$mesReferencia).hashCode());
        Integer $anoReferencia = this.getAnoReferencia();
        result = result * 59 + ($anoReferencia == null ? 43 : ((Object)$anoReferencia).hashCode());
        return result;
    }

    public String toString() {
        return "EventuaisWsVo(codigoEntidade=" + this.getCodigoEntidade() + ", codigoEvento=" + this.getCodigoEvento() + ", identificacaoTrabalhador=" + this.getIdentificacaoTrabalhador() + ", tipoLancamento=" + (Object)((Object)this.getTipoLancamento()) + ", tipoIdentificacaoTrabalhador=" + (Object)((Object)this.getTipoIdentificacaoTrabalhador()) + ", valor=" + this.getValor() + ", data=" + this.getData() + ", nome=" + this.getNome() + ", mesReferencia=" + this.getMesReferencia() + ", anoReferencia=" + this.getAnoReferencia() + ")";
    }

    public static class EventoWsVoSql {
        public static final String GET_LIST_BY_ENTIDADE = " SELECT new " + EventuaisWsVo.class.getName() + " (e.eventoPK.entidade, e.eventoPK.codigo, e.nome, e.tipoLancamento, e.classificacao, e.utilizarFormula) " + "  FROM Evento e " + " WHERE e.eventoPK.entidade = :entidade " + " ORDER BY e.eventoPK.codigo ";
        public static final String GET_BY_PK = " SELECT new " + EventuaisWsVo.class.getName() + " (e.eventoPK.entidade, e.eventoPK.codigo, e.nome, e.tipoLancamento, e.classificacao, e.utilizarFormula) " + "  FROM Evento e " + " WHERE e.eventoPK.entidade = :entidade " + " AND e.eventoPK.codigo = :codigo ";
    }
}

