/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo.ws;

import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoClassificacao;
import br.com.fiorilli.sip.persistence.entity.EventoNatureza;
import br.com.fiorilli.sip.persistence.entity.TipoLancamentoEvento;
import br.com.fiorilli.sip.persistence.entity.TipoLancamentoEventuaisExterno;
import br.com.fiorilli.sipweb.vo.ws.EventoMinWsVo;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="evento")
@XmlType(propOrder={"tipoLancamento", "natureza", "classificacao"})
public class EventoWsVo
extends EventoMinWsVo {
    public static final String SQL_BY_PK = " SELECT new " + EventoWsVo.class.getName() + " (e.eventoPK.codigo, e.nome, e.naturezaEvento, e.classificacaoEvento, e.tipoLancamento, e.utilizarFormula) " + " FROM Evento e " + " WHERE e.eventoPK.entidade = :entidade " + " AND e.eventoPK.codigo = :codigo ";
    private TipoLancamentoEventuaisExterno tipoLancamento;
    private NaturezaEventoWsVo natureza;
    private ClassificacaoEventoWsVo classificacao;

    public EventoWsVo() {
    }

    public EventoWsVo(String codigo, String nome, EventoNatureza natureza, EventoClassificacao classificacao, Short tipoLancamento, String utilizarFormula) {
        super(codigo, nome);
        if (natureza != null) {
            this.natureza = new NaturezaEventoWsVo(natureza.getCodigo(), natureza.getDescricao());
        }
        if (classificacao != null) {
            this.classificacao = new ClassificacaoEventoWsVo(classificacao.getId(), classificacao.getLabelWithoutId());
        }
        this.tipoLancamento = this.getTipoLancamento(tipoLancamento, utilizarFormula, classificacao);
    }

    public EventoWsVo(Evento evento) {
        super(evento.getEventoPK().getCodigo(), evento.getNome());
        if (evento.getNaturezaEvento() != null) {
            this.natureza = new NaturezaEventoWsVo(evento.getNaturezaEvento().getCodigo(), evento.getNaturezaEvento().getDescricao());
        }
        if (evento.getClassificacaoEvento() != null) {
            this.classificacao = new ClassificacaoEventoWsVo(evento.getClassificacaoEvento().getId(), evento.getClassificacaoEvento().getLabelWithoutId());
        }
        this.tipoLancamento = this.getTipoLancamento(evento.getTipoLancamento().getId(), evento.getUtilizarFormula(), evento.getClassificacaoEvento());
    }

    private TipoLancamentoEventuaisExterno getTipoLancamento(Short tipoLancamento, String utilizarFormula, EventoClassificacao classificacao) {
        TipoLancamentoEvento tipoLancamentoEvento = TipoLancamentoEvento.toEntity(tipoLancamento);
        boolean isUtilizaFormula = "S".equals(utilizarFormula);
        if (!isUtilizaFormula) {
            return TipoLancamentoEventuaisExterno.VALOR;
        }
        if ((tipoLancamentoEvento.isIndefinido() || tipoLancamentoEvento.isFormula()) && isUtilizaFormula) {
            return classificacao.isFalta() ? TipoLancamentoEventuaisExterno.HORA : TipoLancamentoEventuaisExterno.TODOS;
        }
        return TipoLancamentoEventuaisExterno.getTipoLancamentoEventoCorrespondente(tipoLancamentoEvento);
    }

    @XmlAttribute
    public TipoLancamentoEventuaisExterno getTipoLancamento() {
        return this.tipoLancamento;
    }

    public NaturezaEventoWsVo getNatureza() {
        return this.natureza;
    }

    public void setNatureza(NaturezaEventoWsVo natureza) {
        this.natureza = natureza;
    }

    public ClassificacaoEventoWsVo getClassificacao() {
        return this.classificacao;
    }

    public void setClassificacao(ClassificacaoEventoWsVo classificacao) {
        this.classificacao = classificacao;
    }

    @XmlRootElement(name="classificacao")
    @XmlType(propOrder={"codigo", "descricao"})
    public static class ClassificacaoEventoWsVo {
        private String codigo;
        private String descricao;

        public ClassificacaoEventoWsVo() {
        }

        public ClassificacaoEventoWsVo(String codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        @XmlAttribute
        public String getCodigo() {
            return this.codigo;
        }

        public void setCodigo(String codigo) {
            this.codigo = codigo;
        }

        @XmlAttribute
        public String getDescricao() {
            return this.descricao;
        }

        public void setDescricao(String descricao) {
            this.descricao = descricao;
        }
    }

    @XmlRootElement(name="natureza")
    @XmlType(propOrder={"codigo", "descricao"})
    public static class NaturezaEventoWsVo {
        private String codigo;
        private String descricao;

        public NaturezaEventoWsVo() {
        }

        public NaturezaEventoWsVo(String codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        @XmlAttribute
        public String getCodigo() {
            return this.codigo;
        }

        public void setCodigo(String codigo) {
            this.codigo = codigo;
        }

        @XmlAttribute
        public String getDescricao() {
            return this.descricao;
        }

        public void setDescricao(String descricao) {
            this.descricao = descricao;
        }
    }
}

