/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo.ws;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.Parentesco;
import br.com.fiorilli.sip.persistence.entity.Sexo;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="dependente")
@XmlType(propOrder={"nome", "cpf", "dataNascimento", "sexo", "parentescoCodigo", "parentescoNome"})
public class DependenteWsVo {
    private String nome;
    private String cpf;
    private Date dataNascimento;
    private String sexo;
    private String parentescoCodigo;
    private String parentescoNome;

    public DependenteWsVo() {
    }

    public DependenteWsVo(String nome, String cpf, Date dataNascimento, Sexo sexo, String parentesco) {
        this.nome = nome;
        this.cpf = cpf;
        this.dataNascimento = dataNascimento;
        this.sexo = sexo.getLabel();
        this.parentescoCodigo = parentesco;
        this.parentescoNome = Parentesco.of(this.parentescoCodigo).getDescricao();
    }

    @XmlAttribute
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @XmlAttribute
    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @XmlAttribute(name="data-nascimento")
    public String getDataNascimento() {
        return SIPDateUtil.toString((String)"dd-MM-yyyy", (Date)this.dataNascimento);
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    @XmlAttribute
    public String getSexo() {
        return this.sexo;
    }

    public void setSexo(String sexo) {
        this.sexo = sexo;
    }

    @XmlAttribute(name="parentesco-codigo")
    public String getParentescoCodigo() {
        return this.parentescoCodigo;
    }

    public void setParentescoCodigo(String parentescoCodigo) {
        this.parentescoCodigo = parentescoCodigo;
    }

    @XmlAttribute(name="parentesco-nome")
    public String getParentescoNome() {
        return this.parentescoNome;
    }

    public void setParentescoNome(String parentescoNome) {
        this.parentescoNome = parentescoNome;
    }
}

