/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo.ws;

import br.com.fiorilli.sip.persistence.entity.AtividadeCargo;
import br.com.fiorilli.sip.persistence.entity.CargoNatureza;
import br.com.fiorilli.sipweb.vo.ws.AtividadeWsVo;
import br.com.fiorilli.sipweb.vo.ws.CargoWsVo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="cargo")
public class CargoCompletoWsVo
extends CargoWsVo {
    private Double horasMes;
    private Double horasSemanal;
    private Double diasSemana;
    private Double horasEfetivas;
    private List<AtividadeWsVo> atividades;

    public CargoCompletoWsVo() {
    }

    public CargoCompletoWsVo(String codigo, String nome, CargoNatureza natureza, Boolean acumulavel, String cbo, Double horasMes, Double horasSemanal, Double diasSemana, Double horasEfetivas) {
        super(codigo, nome, natureza, acumulavel, cbo);
        this.horasMes = horasMes;
        this.horasSemanal = horasSemanal;
        this.diasSemana = diasSemana;
        this.horasEfetivas = horasEfetivas;
    }

    @XmlAttribute
    public Double getHorasMes() {
        return this.horasMes;
    }

    public void setHorasMes(Double horasMes) {
        this.horasMes = horasMes;
    }

    @XmlAttribute
    public Double getHorasSemanal() {
        return this.horasSemanal;
    }

    public void setHorasSemanal(Double horasSemanal) {
        this.horasSemanal = horasSemanal;
    }

    @XmlAttribute
    public Double getDiasSemana() {
        return this.diasSemana;
    }

    public void setDiasSemana(Double diasSemana) {
        this.diasSemana = diasSemana;
    }

    @XmlAttribute
    public Double getHorasEfetivas() {
        return this.horasEfetivas;
    }

    public void setHorasEfetivas(Double horasEfetivas) {
        this.horasEfetivas = horasEfetivas;
    }

    @XmlElementWrapper(name="atividades")
    @XmlElement(name="atividade")
    public List<AtividadeWsVo> getAtividades() {
        return this.atividades;
    }

    public void setAtividades(List<AtividadeWsVo> atividades) {
        this.atividades = atividades;
    }

    public void loadAtividades(List<AtividadeCargo> atividades) {
        if (atividades != null && !atividades.isEmpty()) {
            this.atividades = new ArrayList<AtividadeWsVo>();
            for (AtividadeCargo atividade : atividades) {
                this.atividades.add(new AtividadeWsVo(atividade.getAtividade().getAtividadePK().getCodigo(), atividade.getAtividade().getNome()));
            }
        } else {
            this.atividades = null;
        }
    }
}

