/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo.ws;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="base")
public class BasesVoWs {
    private Double totalProventos;
    private Double totalDescontos;
    private Double liquido;
    private Double valorsalario;
    private Double baseinss;
    private Double basefgts;
    private Double valorfgts;
    private Double baseirrf;
    private String banco;
    private String agencia;
    private String conta;
    private Short qtddeptsirrf;
    private Integer categoriaFuncional;
    private String categoriaFuncionalNome;
    private Short qtdDependentesFamilia;
    private Double valorDependentesIrrf;
    private String cargoAtual;
    private String cargoAtualNome;
    private String divisao;
    private String divisaoNome;
    private String subdivisao;
    private String subdivisaoNome;
    private String unidade;
    private String unidadeNome;
    private String localTrabalho;
    private String localTrabalhoNome;

    public BasesVoWs() {
    }

    private BasesVoWs(Builder builder) {
        this.totalProventos = builder.totalProventos;
        this.totalDescontos = builder.totalDescontos;
        this.liquido = builder.liquido;
        this.valorsalario = builder.valorsalario;
        this.baseinss = builder.baseinss;
        this.basefgts = builder.basefgts;
        this.valorfgts = builder.valorfgts;
        this.baseirrf = builder.baseirrf;
        this.banco = builder.banco;
        this.agencia = builder.agencia;
        this.conta = builder.conta;
        this.qtddeptsirrf = builder.qtddeptsirrf;
        this.categoriaFuncional = builder.categoriaFuncional;
        this.categoriaFuncionalNome = builder.categoriaFuncionalNome;
        this.cargoAtual = builder.cargoAtual;
        this.cargoAtualNome = builder.cargoAtualNome;
        this.divisao = builder.divisao;
        this.divisaoNome = builder.divisaoNome;
        this.subdivisao = builder.subdivisao;
        this.subdivisaoNome = builder.subdivisaoNome;
        this.unidade = builder.unidade;
        this.unidadeNome = builder.unidadeNome;
        this.localTrabalho = builder.localTrabalho;
        this.localTrabalhoNome = builder.localTrabalhoNome;
    }

    @XmlAttribute(name="total-proventos")
    public Double getTotalProventos() {
        return this.totalProventos;
    }

    public void setTotalProventos(Double totalProventos) {
        this.totalProventos = totalProventos;
    }

    @XmlAttribute(name="total-descontos")
    public Double getTotalDescontos() {
        return this.totalDescontos;
    }

    public void setTotalDescontos(Double totalDescontos) {
        this.totalDescontos = totalDescontos;
    }

    @XmlAttribute
    public Double getLiquido() {
        return this.liquido;
    }

    public void setLiquido(Double liquido) {
        this.liquido = liquido;
    }

    @XmlAttribute(name="valor-salario")
    public Double getValorsalario() {
        return this.valorsalario;
    }

    public void setValorsalario(Double valorsalario) {
        this.valorsalario = valorsalario;
    }

    @XmlAttribute(name="base-inss")
    public Double getBaseinss() {
        return this.baseinss;
    }

    public void setBaseinss(Double baseinss) {
        this.baseinss = baseinss;
    }

    @XmlAttribute(name="base-fgts")
    public Double getBasefgts() {
        return this.basefgts;
    }

    public void setBasefgts(Double basefgts) {
        this.basefgts = basefgts;
    }

    @XmlAttribute(name="valor-fgts")
    public Double getValorfgts() {
        return this.valorfgts;
    }

    public void setValorfgts(Double valorfgts) {
        this.valorfgts = valorfgts;
    }

    @XmlAttribute(name="base-irrf")
    public Double getBaseirrf() {
        return this.baseirrf;
    }

    public void setBaseirrf(Double baseirrf) {
        this.baseirrf = baseirrf;
    }

    @XmlAttribute(name="agencia")
    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @XmlAttribute(name="conta")
    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    @XmlAttribute(name="banco")
    public String getBanco() {
        return this.banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    @XmlAttribute(name="quantidade-dependentes-irrf")
    public Short getQtddeptsirrf() {
        return this.qtddeptsirrf;
    }

    public void setQtddeptsirrf(Short qtddeptsirrf) {
        this.qtddeptsirrf = qtddeptsirrf;
    }

    @XmlAttribute(name="quantidade-dependentes-familia")
    public Short getQtdDependentesFamilia() {
        return this.qtdDependentesFamilia;
    }

    public void setQtdDependentesFamilia(Short qtdDependentesFamilia) {
        this.qtdDependentesFamilia = qtdDependentesFamilia;
    }

    @XmlAttribute(name="valor-dependentes-irrf")
    public Double getValorDependentesIrrf() {
        return this.valorDependentesIrrf;
    }

    public void setValorDependentesIrrf(Double valorDependentesIrrf) {
        this.valorDependentesIrrf = valorDependentesIrrf;
    }

    @XmlAttribute(name="categoria-funcional")
    public Integer getCategoriaFuncional() {
        return this.categoriaFuncional;
    }

    public void setCategoriaFuncional(Integer categoriaFuncional) {
        this.categoriaFuncional = categoriaFuncional;
    }

    @XmlAttribute(name="categoria-funcional-nome")
    public String getCategoriaFuncionalNome() {
        return this.categoriaFuncionalNome;
    }

    public void setCategoriaFuncionalNome(String categoriaFuncionalNome) {
        this.categoriaFuncionalNome = categoriaFuncionalNome;
    }

    @XmlAttribute(name="cargo-atual")
    public String getCargoAtual() {
        return this.cargoAtual;
    }

    public void setCargoAtual(String cargoAtual) {
        this.cargoAtual = cargoAtual;
    }

    @XmlAttribute(name="cargo-atual-nome")
    public String getCargoAtualNome() {
        return this.cargoAtualNome;
    }

    public void setCargoAtualNome(String cargoAtualNome) {
        this.cargoAtualNome = cargoAtualNome;
    }

    @XmlAttribute
    public String getDivisao() {
        return this.divisao;
    }

    public void setDivisao(String divisao) {
        this.divisao = divisao;
    }

    @XmlAttribute(name="divisao-nome")
    public String getDivisaoNome() {
        return this.divisaoNome;
    }

    public void setDivisaoNome(String divisaoNome) {
        this.divisaoNome = divisaoNome;
    }

    @XmlAttribute
    public String getSubdivisao() {
        return this.subdivisao;
    }

    public void setSubdivisao(String subdivisao) {
        this.subdivisao = subdivisao;
    }

    @XmlAttribute(name="subdivisao-nome")
    public String getSubdivisaoNome() {
        return this.subdivisaoNome;
    }

    public void setSubdivisaoNome(String subdivisaoNome) {
        this.subdivisaoNome = subdivisaoNome;
    }

    @XmlAttribute
    public String getUnidade() {
        return this.unidade;
    }

    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    @XmlAttribute(name="unidade-nome")
    public String getUnidadeNome() {
        return this.unidadeNome;
    }

    public void setUnidadeNome(String unidadeNome) {
        this.unidadeNome = unidadeNome;
    }

    @XmlAttribute(name="local-trabalho")
    public String getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(String localTrabalho) {
        this.localTrabalho = localTrabalho;
    }

    @XmlAttribute(name="local-trabalho-nome")
    public String getLocalTrabalhoNome() {
        return this.localTrabalhoNome;
    }

    public void setLocalTrabalhoNome(String localTrabalhoNome) {
        this.localTrabalhoNome = localTrabalhoNome;
    }

    public String toString() {
        return "BasesVo [getTotalProventos()=" + this.getTotalProventos() + ", getTotalDescontos()=" + this.getTotalDescontos() + ", getLiquido()=" + this.getLiquido() + ", getValorsalario()=" + this.getValorsalario() + ", getBaseinss()=" + this.getBaseinss() + ", getBasefgts()=" + this.getBasefgts() + ", getValorfgts()=" + this.getValorfgts() + ", getBaseirrf()=" + this.getBaseirrf() + ", getAgencia()=" + this.getAgencia() + ", getConta()=" + this.getConta() + ", getBanco()=" + this.getBanco() + ", getQtddeptsirrf()=" + this.getQtddeptsirrf() + "]";
    }

    public static class Builder {
        private Double totalProventos = 0.0;
        private Double totalDescontos = 0.0;
        private Double liquido = null;
        private Double valorsalario = 0.0;
        private Double baseinss = 0.0;
        private Double basefgts = 0.0;
        private Double valorfgts = 0.0;
        private Double baseirrf = 0.0;
        private String banco = "";
        private String agencia = "";
        private String conta = "";
        private Short qtddeptsirrf = 0;
        private Integer categoriaFuncional = null;
        private String categoriaFuncionalNome = "";
        private String cargoAtual = "";
        private String cargoAtualNome = "";
        private String divisao = "";
        private String divisaoNome = "";
        private String subdivisao = "";
        private String subdivisaoNome = "";
        private String unidade = "";
        private String unidadeNome = "";
        private String localTrabalho = "";
        private String localTrabalhoNome = "";

        public BasesVoWs build() {
            if (this.liquido == null) {
                this.liquido = this.totalProventos - this.totalDescontos;
            }
            return new BasesVoWs(this);
        }

        public Builder addProventos(Double provento) {
            Builder builder = this;
            builder.totalProventos = builder.totalProventos + provento;
            return this;
        }

        public Builder addDescontos(Double desconto) {
            Builder builder = this;
            builder.totalDescontos = builder.totalDescontos + desconto;
            return this;
        }

        public Builder liquido(Double liquido) {
            this.liquido = liquido;
            return this;
        }

        public Builder valorsalario(Double valorsalario) {
            this.valorsalario = valorsalario;
            return this;
        }

        public Builder addBaseinss(Double baseinss) {
            Builder builder = this;
            builder.baseinss = builder.baseinss + baseinss;
            return this;
        }

        public Builder addBasefgts(Double basefgts) {
            Builder builder = this;
            builder.basefgts = builder.basefgts + basefgts;
            return this;
        }

        public Builder addValorfgts(Double valorfgts) {
            Builder builder = this;
            builder.valorfgts = builder.valorfgts + valorfgts;
            return this;
        }

        public Builder addBaseirrf(Double baseirrf) {
            Builder builder = this;
            builder.baseirrf = builder.baseirrf + baseirrf;
            return this;
        }

        public Builder banco(String banco) {
            this.banco = banco;
            return this;
        }

        public Builder agencia(String agencia) {
            this.agencia = agencia;
            return this;
        }

        public Builder conta(String conta) {
            this.conta = conta;
            return this;
        }

        public Builder qtddeptsirrf(Short qtddeptsirrf) {
            this.qtddeptsirrf = qtddeptsirrf;
            return this;
        }

        public Builder categoriaFuncional(Integer categoriaFuncional) {
            this.categoriaFuncional = categoriaFuncional;
            return this;
        }

        public Builder categoriaFuncionalNome(String categoriaFuncionalNome) {
            this.categoriaFuncionalNome = categoriaFuncionalNome;
            return this;
        }

        public Builder cargoAtual(String cargoAtual) {
            this.cargoAtual = cargoAtual;
            return this;
        }

        public Builder cargoAtualNome(String cargoAtualNome) {
            this.cargoAtualNome = cargoAtualNome;
            return this;
        }

        public Builder divisao(String divisao) {
            this.divisao = divisao;
            return this;
        }

        public Builder divisaoNome(String divisaoNome) {
            this.divisaoNome = divisaoNome;
            return this;
        }

        public Builder subdivisao(String subdivisao) {
            this.subdivisao = subdivisao;
            return this;
        }

        public Builder subdivisaoNome(String subdivisaoNome) {
            this.subdivisaoNome = subdivisaoNome;
            return this;
        }

        public Builder localTrabalho(String localTrabalho) {
            this.localTrabalho = localTrabalho;
            return this;
        }

        public Builder localTrabalhoNome(String localTrabalhoNome) {
            this.localTrabalhoNome = localTrabalhoNome;
            return this;
        }
    }
}

