/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo.go.tcetcm;

import br.com.fiorilli.sipweb.vo.go.tcetcm.NotaEmpenho;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;

public enum CamposNotaEmpenho {
    COD_PROGRAMA(1, "CODPROGRAMA"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setCodPrograma(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    COD_ORGAO(2, "CODORGAO"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setCodOrgao(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    COD_UNIDADE(3, "CODUNIDADE"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setCodUnidade(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    COD_FUNCAO(4, "CODFUNCAO"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setCodFuncao(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    COD_SUBFUNCAO(5, "CODSUBFUNCAO"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setCodSubFuncao(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    NATUREZA_ACAO(6, "NATUREZAACAO"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setNaturezaAcao(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    NR_SEQUENCIAL_PROJETO_ATIVIDADE(7, "NRSEQUENCIALPROJETOATIVIDADE"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setNumeroSequencialProjetoAtividade(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    ELEMENTO_DESPESA(8, "ELEMENTODESPESA"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setElementoDespesa(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    SUBELEMENTO_DESPESA(9, "SUBELEMENTODESPESA"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setSubElementoDespesa(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    NRO_EMPENHO(10, "NROEMPENHO"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            notaEmpenho.setNumeroEmpenho(Integer.parseInt(valor));
            return notaEmpenho;
        }
    }
    ,
    DT_EMPENHO(11, "DTEMPENHO"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            try {
                notaEmpenho.setDataEmpenho(simpleDateFormat.parse(valor));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return notaEmpenho;
        }
    }
    ,
    VALOR_TOTAL_EMPENHO(12, "VALORTOTALEMPENHO"){

        @Override
        public NotaEmpenho read(NotaEmpenho notaEmpenho, String valor) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            try {
                notaEmpenho.setValorTotalEmpenho(numberFormat.parse(valor).doubleValue());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return notaEmpenho;
        }
    };

    private final int id;
    private final String campo;

    public static CamposNotaEmpenho getBy(String campo) {
        if (!StringUtils.isEmpty((CharSequence)campo)) {
            for (CamposNotaEmpenho campoNotaEmpenho : CamposNotaEmpenho.values()) {
                if (!campoNotaEmpenho.getCampo().equals(campo)) continue;
                return campoNotaEmpenho;
            }
        }
        return null;
    }

    public abstract NotaEmpenho read(NotaEmpenho var1, String var2);

    private CamposNotaEmpenho(int id, String campo) {
        this.id = id;
        this.campo = campo;
    }

    public int getId() {
        return this.id;
    }

    public String getCampo() {
        return this.campo;
    }
}

