/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.persistence.entity.TrabalhadorDadosPessoais;
import br.com.fiorilli.sipweb.vo.EnderecoVo;
import br.com.fiorilli.sipweb.vo.TrabalhadorCaracteristicasFisicasVo;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(name="dados-pessoais")
@XmlType(propOrder={"nacionalidade", "estadoCivil", "grauInstrucao", "email", "telefone", "celular", "endereco", "caracteristicasFisicas"})
class TrabalhadorDadosPessoaisVo {
    private TrabalhadorDadosPessoais dadosPessoais;
    private EnderecoVo endereco;
    private TrabalhadorCaracteristicasFisicasVo caracteristicasFisicas;

    public TrabalhadorDadosPessoaisVo() {
    }

    public TrabalhadorDadosPessoaisVo(TrabalhadorDadosPessoais dadosPessoais) {
        if (dadosPessoais == null) {
            dadosPessoais = new TrabalhadorDadosPessoais();
        }
        this.dadosPessoais = dadosPessoais;
        this.endereco = new EnderecoVo(dadosPessoais.getEndereco(), dadosPessoais.getCodigoCidadeIBGE());
        this.caracteristicasFisicas = new TrabalhadorCaracteristicasFisicasVo(dadosPessoais.getCaracteristicasFisicas());
    }

    @XmlAttribute
    public String getNacionalidade() {
        if (this.dadosPessoais.getNacionalidade() != null) {
            return this.dadosPessoais.getNacionalidade().getNome();
        }
        return null;
    }

    @XmlAttribute(name="estado-civil")
    public String getEstadoCivil() {
        if (this.dadosPessoais.getEstadoCivil() != null) {
            return this.dadosPessoais.getEstadoCivil().getNome();
        }
        return "";
    }

    @XmlAttribute(name="grau-instrucao")
    public String getGrauInstrucao() {
        if (this.dadosPessoais.getInstrucao() != null) {
            return this.dadosPessoais.getInstrucao().getNome();
        }
        return "";
    }

    @XmlAttribute
    public String getEmail() {
        return StringUtils.defaultString((String)this.dadosPessoais.getEmail());
    }

    @XmlAttribute
    public String getTelefone() {
        if (this.dadosPessoais.getTelefone() != null) {
            return this.dadosPessoais.getTelefone().toString();
        }
        return "";
    }

    @XmlAttribute
    public String getCelular() {
        if (this.dadosPessoais.getCelular() != null) {
            return this.dadosPessoais.getCelular().toString();
        }
        return "";
    }

    @XmlElement
    public EnderecoVo getEndereco() {
        return this.endereco;
    }

    @XmlElement
    public TrabalhadorCaracteristicasFisicasVo getCaracteristicasFisicas() {
        return this.caracteristicasFisicas;
    }
}

