/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.persistence.entity.TrabalhadorConta;
import br.com.fiorilli.sipweb.vo.AgenciaVo;
import br.com.fiorilli.sipweb.vo.BancoVo;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(name="conta")
@XmlType(propOrder={"tipo", "numero", "digito", "banco", "agencia"})
class TrabalhadorContaVo {
    private TrabalhadorConta conta;
    private AgenciaVo agencia;
    private BancoVo banco;

    public TrabalhadorContaVo() {
    }

    public TrabalhadorContaVo(TrabalhadorConta conta) {
        if (conta == null) {
            conta = new TrabalhadorConta();
        }
        this.conta = conta;
        this.agencia = new AgenciaVo(conta.getAgenciaCodigo(), conta.getAgenciaDigitoVerificador());
        this.banco = new BancoVo(conta.getBanco());
    }

    @XmlAttribute
    public String getTipo() {
        return StringUtils.defaultString((String)this.conta.getTipo());
    }

    @XmlAttribute
    public String getNumero() {
        return this.conta.getContaCodigo();
    }

    @XmlAttribute
    public String getDigito() {
        return this.conta.getContaDigitoVerificador();
    }

    @XmlElement
    public AgenciaVo getAgencia() {
        return this.agencia;
    }

    @XmlElement
    public BancoVo getBanco() {
        return this.banco;
    }
}

