/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorConta;
import br.com.fiorilli.sipweb.vo.JornadaVo;
import br.com.fiorilli.sipweb.vo.LocalTrabalhoVo;
import br.com.fiorilli.sipweb.vo.TrabalhadorContaVo;
import br.com.fiorilli.sipweb.vo.TrabalhadorDadosAdicionaisVo;
import br.com.fiorilli.sipweb.vo.TrabalhadorDadosPessoaisVo;
import br.com.fiorilli.sipweb.vo.TrabalhadorDocumentosPessoaisVo;
import br.com.fiorilli.sipweb.vo.VinculoVo;
import br.com.fiorilli.sipweb.vo.ws.AmbienteTrabalhoMinWsVo;
import br.com.fiorilli.sipweb.vo.ws.AtividadeWsVo;
import br.com.fiorilli.sipweb.vo.ws.CargoWsVo;
import br.com.fiorilli.sipweb.vo.ws.DivisaoWsVo;
import br.com.fiorilli.sipweb.vo.ws.SalarioWsVo;
import br.com.fiorilli.sipweb.vo.ws.SubdivisaoWsVo;
import br.com.fiorilli.sipweb.vo.ws.UnidadeWsVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.codec.binary.Base64;

@XmlRootElement(name="trabalhador")
@XmlType(propOrder={"registro", "matricula", "contrato", "nome", "nomeSocial", "dataNascimento", "dataAdmissao", "dataDemissao", "vinculo", "cargo", "atividade", "salario", "localTrabalho", "jornada", "divisao", "subdivisao", "unidade", "ambienteTrabalho", "documentosPessoais", "dadosPessoais", "situacaoFuncional", "dataNomeacaoPosseCargo", "matriculaEsocial"})
public class TrabalhadorCompletoVo {
    private Trabalhador trabalhador;
    private TrabalhadorDocumentosPessoaisVo documentosPessoais;
    private TrabalhadorDadosPessoaisVo dadosPessoais;
    private VinculoVo vinculo;
    private CargoWsVo cargo;
    private AtividadeWsVo atividade;
    private SalarioWsVo salario;
    private LocalTrabalhoVo localTrabalho;
    private JornadaVo jornada;
    private DivisaoWsVo divisao;
    private SubdivisaoWsVo subdivisao;
    private UnidadeWsVo unidade;
    private AmbienteTrabalhoMinWsVo ambienteTrabalho;
    private TrabalhadorContaVo conta;
    private String foto;
    private String dataObito;
    private String nascimentoNumero;
    private String nascimentoLivro;
    private String nascimentoFolha;
    private String nascimentoCidade;
    private String nascimentoUf;
    private String nascimentoRegistroUnico;
    private String admissaoContratoCodigoSalario;
    private String admissaoContratoValorSalario;
    private String admissaoContratoClasse;
    private String admissaoContratoNivel;
    private String admissaoContratoLegAdmissaoTipo;
    private String admissaoContratoLegAdmissaoNumero;
    private String admissaoContratoLegAdmissaoData;
    private String situacaoFuncional;
    private String dataNomeacaoPosseCargo;

    public TrabalhadorCompletoVo() {
    }

    public TrabalhadorCompletoVo(Trabalhador trabalhador, TrabalhadorConta conta, TrabalhadorDadosAdicionaisVo dadosAdicionais) {
        if (trabalhador == null) {
            trabalhador = new Trabalhador();
        }
        this.trabalhador = trabalhador;
        this.documentosPessoais = new TrabalhadorDocumentosPessoaisVo(trabalhador.getDocumentosPessoais());
        this.dadosPessoais = new TrabalhadorDadosPessoaisVo(trabalhador.getDadosPessoais());
        this.cargo = new CargoWsVo(trabalhador.getCargoAtual().getCargoPK().getCodigo(), trabalhador.getCargoAtual().getNome(), trabalhador.getCargoAtual().getNatureza(), trabalhador.getCargoAtual().getSiprevAcumula(), trabalhador.getCargoAtual().getCbo());
        this.salario = trabalhador.getSalarioAtual() != null ? new SalarioWsVo(trabalhador.getSalarioAtual().getSalarioPK().getCodigo(), trabalhador.getSalarioAtual().getNome(), trabalhador.getSalarioAtual().getValor() != null ? trabalhador.getSalarioAtual().getValor().doubleValue() : 0.0) : null;
        this.vinculo = new VinculoVo(trabalhador.getVinculoCodigo(), trabalhador.getVinculo().getNome(), trabalhador.getVinculo().getTabelaPrevidenciaria());
        if (trabalhador.getJornada() != null) {
            this.jornada = new JornadaVo(trabalhador.getJornada());
        }
        this.localTrabalho = new LocalTrabalhoVo(trabalhador.getLocalTrabalho());
        if (trabalhador.getDivisao() != null) {
            this.divisao = new DivisaoWsVo(trabalhador.getDivisao().getCodigo(), trabalhador.getDivisao().getNome());
        }
        if (trabalhador.getSubdivisao() != null) {
            this.subdivisao = new SubdivisaoWsVo(trabalhador.getSubdivisao().getCodigo(), trabalhador.getSubdivisao().getNome());
        }
        this.unidade = new UnidadeWsVo(trabalhador.getUnidade().getDepartamentoDespesa(), trabalhador.getUnidade().getNome());
        this.conta = new TrabalhadorContaVo(conta);
        if (trabalhador.getFoto() != null && trabalhador.getFoto().getFoto() != null) {
            this.foto = Base64.encodeBase64String((byte[])trabalhador.getFoto().getFoto());
        }
        if (dadosAdicionais.getAdmissaoContratoValorSalario() != null) {
            this.dataObito = dadosAdicionais.getDataObito() != null ? this.formataDataStringToString(dadosAdicionais.getDataObito()) : null;
            this.nascimentoNumero = dadosAdicionais.getNascimentoNumero();
            this.nascimentoLivro = dadosAdicionais.getNascimentoLivro();
            this.nascimentoFolha = dadosAdicionais.getNascimentoFolha();
            this.nascimentoCidade = dadosAdicionais.getNascimentoCidade();
            this.nascimentoUf = dadosAdicionais.getNascimentoUf();
            this.nascimentoRegistroUnico = dadosAdicionais.getNascimentoRegistroUnico();
            this.admissaoContratoCodigoSalario = dadosAdicionais.getAdmissaoContratoCodigoSalario();
            this.admissaoContratoValorSalario = dadosAdicionais.getAdmissaoContratoValorSalario();
            this.admissaoContratoClasse = dadosAdicionais.getAdmissaoContratoClasse();
            this.admissaoContratoNivel = dadosAdicionais.getAdmissaoContratoNivel();
            this.admissaoContratoLegAdmissaoTipo = dadosAdicionais.getAdmissaoContratoLegAdmissaoTipo();
            this.admissaoContratoLegAdmissaoNumero = dadosAdicionais.getAdmissaoContratoLegAdmissaoNumero();
            this.admissaoContratoLegAdmissaoData = dadosAdicionais.getAdmissaoContratoLegAdmissaoData() != null ? this.formataDataStringToString(dadosAdicionais.getAdmissaoContratoLegAdmissaoData()) : null;
            this.dataNomeacaoPosseCargo = dadosAdicionais.getDataNomeacaoPosseCargo() != null ? this.formataDataStringToString(dadosAdicionais.getDataNomeacaoPosseCargo()) : null;
        }
        this.situacaoFuncional = trabalhador.getSituacaoFuncional() != null ? trabalhador.getSituacaoFuncional().getDescricao() : "";
        if (trabalhador.getAmbienteTrabalho() != null) {
            this.ambienteTrabalho = new AmbienteTrabalhoMinWsVo(trabalhador.getAmbienteTrabalho().getPk().getCodigo(), trabalhador.getAmbienteTrabalho().getNome());
        }
        if (trabalhador.getAtividade() != null) {
            this.atividade = new AtividadeWsVo(trabalhador.getAtividade().getAtividadePK().getCodigo(), trabalhador.getAtividade().getNome());
        }
    }

    public String formataDataStringToString(String data) {
        if (data.length() == 10) {
            String dia = data.substring(8, 10);
            String mes = data.substring(5, 7);
            String ano = data.substring(0, 4);
            return dia + "-" + mes + "-" + ano;
        }
        return data;
    }

    @XmlAttribute
    public String getRegistro() {
        return this.trabalhador.getTrabalhadorPK().getRegistro();
    }

    @XmlAttribute
    public int getMatricula() {
        return this.trabalhador.getMatricula();
    }

    @XmlAttribute
    public short getContrato() {
        return this.trabalhador.getContrato();
    }

    @XmlAttribute
    public String getNome() {
        return this.trabalhador.getNome();
    }

    @XmlAttribute(name="nome-social")
    public String getNomeSocial() {
        return this.trabalhador.getNomeSocial();
    }

    @XmlAttribute(name="data-nascimento")
    public String getDataNascimento() {
        if (this.trabalhador.getDataNascimento() != null) {
            return new SimpleDateFormat("dd-MM-yyyy").format(this.trabalhador.getDataNascimento());
        }
        return "";
    }

    @XmlAttribute(name="data-admissao")
    public String getDataAdmissao() {
        if (this.trabalhador.getDataAdmissao() != null) {
            return new SimpleDateFormat("dd-MM-yyyy").format(this.trabalhador.getDataAdmissao());
        }
        return "";
    }

    @XmlAttribute(name="data-demissao")
    public String getDataDemissao() {
        if (this.trabalhador.getDataDemissao() != null) {
            return new SimpleDateFormat("dd-MM-yyyy").format(this.trabalhador.getDataDemissao());
        }
        return "";
    }

    @XmlAttribute(name="hora-semanal")
    public BigDecimal getHoraSemanal() {
        BigDecimal horaSemanal = BigDecimal.ZERO;
        if (this.trabalhador.getHorasSemanal() != null) {
            horaSemanal = this.trabalhador.getHorasSemanal();
        }
        return horaSemanal.setScale(2, 6);
    }

    @XmlAttribute(name="hora-mensal")
    public BigDecimal getHoraMensal() {
        BigDecimal horaMensal = BigDecimal.ZERO;
        if (this.trabalhador.getHorasMes() != null) {
            horaMensal = this.trabalhador.getHorasMes();
        }
        return horaMensal.setScale(2, 6);
    }

    @XmlAttribute(name="horas-efetivas")
    public BigDecimal getHorasEfetivas() {
        BigDecimal horasEfetivas = BigDecimal.ZERO;
        if (this.trabalhador.getHorasEfetivas() != null) {
            horasEfetivas = this.trabalhador.getHorasEfetivas();
        }
        return horasEfetivas.setScale(4, 6);
    }

    @XmlAttribute(name="dias-semana")
    public BigDecimal getDiasSemana() {
        BigDecimal diasSemana = BigDecimal.ZERO;
        if (this.trabalhador.getDiasSemana() != null) {
            diasSemana = this.trabalhador.getDiasSemana();
        }
        return diasSemana.setScale(2, 6);
    }

    @XmlElement(name="documentos-pessoais")
    public TrabalhadorDocumentosPessoaisVo getDocumentosPessoais() {
        return this.documentosPessoais;
    }

    @XmlElement(name="dados-pessoais")
    public TrabalhadorDadosPessoaisVo getDadosPessoais() {
        return this.dadosPessoais;
    }

    @XmlElement
    public VinculoVo getVinculo() {
        return this.vinculo;
    }

    @XmlElement
    public CargoWsVo getCargo() {
        return this.cargo;
    }

    @XmlElement
    public AtividadeWsVo getAtividade() {
        return this.atividade;
    }

    public void setAtividade(AtividadeWsVo atividade) {
        this.atividade = atividade;
    }

    @XmlElement
    public SalarioWsVo getSalario() {
        return this.salario;
    }

    @XmlElement(name="local-trabalho")
    public LocalTrabalhoVo getLocalTrabalho() {
        return this.localTrabalho;
    }

    @XmlElement
    public JornadaVo getJornada() {
        return this.jornada;
    }

    @XmlElement
    public DivisaoWsVo getDivisao() {
        return this.divisao;
    }

    @XmlElement
    public SubdivisaoWsVo getSubdivisao() {
        return this.subdivisao;
    }

    @XmlElement
    public UnidadeWsVo getUnidade() {
        return this.unidade;
    }

    public TrabalhadorContaVo getConta() {
        return this.conta;
    }

    @XmlAttribute(name="situacao-funcional")
    public String getSituacaoFuncional() {
        return this.situacaoFuncional;
    }

    public void setSituacaoFuncional(String situacaoFuncional) {
        this.situacaoFuncional = situacaoFuncional;
    }

    @XmlAttribute(name="data-nomeacao-posse-cargo")
    public String getDataNomeacaoPosseCargo() {
        return this.dataNomeacaoPosseCargo;
    }

    public void setDataNomeacaoPosseCargo(String dataNomeacaoPosseCargo) {
        this.dataNomeacaoPosseCargo = dataNomeacaoPosseCargo;
    }

    @XmlElement
    public AmbienteTrabalhoMinWsVo getAmbienteTrabalho() {
        return this.ambienteTrabalho;
    }

    public void setAmbienteTrabalho(AmbienteTrabalhoMinWsVo ambienteTrabalho) {
        this.ambienteTrabalho = ambienteTrabalho;
    }

    @XmlAttribute(name="matricula-esocial")
    public String getMatriculaEsocial() {
        return this.trabalhador.getCodigoEsocial() != null ? this.trabalhador.getCodigoEsocial() : this.trabalhador.getTrabalhadorPK().toMatriculaEsocial();
    }

    public String getFoto() {
        return this.foto;
    }

    public String getDataObito() {
        return this.dataObito;
    }

    public String getNascimentoNumero() {
        return this.nascimentoNumero;
    }

    public String getNascimentoLivro() {
        return this.nascimentoLivro;
    }

    public String getNascimentoFolha() {
        return this.nascimentoFolha;
    }

    public String getNascimentoCidade() {
        return this.nascimentoCidade;
    }

    public String getNascimentoUf() {
        return this.nascimentoUf;
    }

    public String getNascimentoRegistroUnico() {
        return this.nascimentoRegistroUnico;
    }

    public String getAdmissaoContratoCodigoSalario() {
        return this.admissaoContratoCodigoSalario;
    }

    public String getAdmissaoContratoValorSalario() {
        return this.admissaoContratoValorSalario;
    }

    public String getAdmissaoContratoClasse() {
        return this.admissaoContratoClasse;
    }

    public String getAdmissaoContratoNivel() {
        return this.admissaoContratoNivel;
    }

    public String getAdmissaoContratoLegAdmissaoTipo() {
        return this.admissaoContratoLegAdmissaoTipo;
    }

    public String getAdmissaoContratoLegAdmissaoNumero() {
        return this.admissaoContratoLegAdmissaoNumero;
    }

    public String getAdmissaoContratoLegAdmissaoData() {
        return this.admissaoContratoLegAdmissaoData;
    }
}

