/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.commons.jaxb.adapter.DateTimeJaxbAdapter;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="trabalhador")
@XmlType(propOrder={"registro", "matricula", "contrato", "dataHoraAlteracao", "entidade"})
public class TrabalhadorAlteradoVo {
    private String registro;
    private Integer matricula;
    private Short contrato;
    private Date dataHoraAlteracao;
    private String matriculaContrato;
    private String entidade;

    public TrabalhadorAlteradoVo() {
    }

    public TrabalhadorAlteradoVo(String registro, Integer matricula, Short contrato, Date dataHoraAlteracao, String entidade) {
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.dataHoraAlteracao = dataHoraAlteracao;
        this.matriculaContrato = matricula != null && contrato != null ? String.valueOf(matricula) + "-" + String.valueOf(contrato) : "";
        this.entidade = entidade;
    }

    @XmlAttribute
    public String getRegistro() {
        return this.registro;
    }

    @XmlAttribute
    public Integer getMatricula() {
        return this.matricula;
    }

    @XmlAttribute
    public Short getContrato() {
        return this.contrato;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=DateTimeJaxbAdapter.class)
    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    @XmlAttribute
    public String getMatriculaContrato() {
        return this.matriculaContrato;
    }

    @XmlAttribute
    public String getEntidade() {
        return this.entidade;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.registro == null ? 0 : this.registro.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrabalhadorAlteradoVo other = (TrabalhadorAlteradoVo)obj;
        return !(this.registro == null ? other.registro != null : !this.registro.equals(other.registro));
    }

    public String toString() {
        return "TrabalhadorAlteradoVo [registro=" + this.registro + "]";
    }

    public static class TrabalhadorAlteradoVoSql {
        public static final String GET_ALTERADOS_BY_ENTIDADE_NO_PERIODO = "SELECT NEW " + TrabalhadorAlteradoVo.class.getName() + "(t.trabalhadorPK.registro, t.matricula, t.contrato, t.dataHoraAlteracao, t.trabalhadorPK.entidade) " + "FROM Trabalhador t " + "WHERE t.trabalhadorPK.entidade = :entidadeCodigo " + "AND t.dataHoraAlteracao BETWEEN :dataInicial AND :dataFinal " + "AND ((t.dataDemissao is null) OR (t.dataDemissao >= :dataInicial)) ";
        public static final String GET_ALTERADOS_BY_PIS_NO_PERIODO = "SELECT NEW " + TrabalhadorAlteradoVo.class.getName() + "(t.trabalhadorPK.registro, t.matricula, t.contrato, t.dataHoraAlteracao, t.trabalhadorPK.entidade) " + "FROM Trabalhador t " + "WHERE t.documentosPessoais.pis = :pis " + "AND t.dataHoraAlteracao BETWEEN :dataInicial AND :dataFinal " + "AND ((t.dataDemissao is null) OR (t.dataDemissao >= :dataInicial)) ";
    }
}

