/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

public class SalarioPrevidenciaVo {
    public static final String QUERY = "SELECT NEW br.com.fiorilli.sipweb.vo.SalarioPrevidenciaVo (tr.trabalhadorPK.registro, tr.trabalhadorPK.entidade, COALESCE(re.mes.mesPK.ano, hi.ano), COALESCE(re.mes.mesPK.mes, hi.mes), SUM(CASE WHEN re.tipo = '1' THEN (COALESCE(ba.basePrevidenciaMes, hi.salarioMensal) + COALESCE(ba.basePrevidenciaFerias, 0)) ELSE (COALESCE(ba.basePrevidenciaMes, hi.salarioMensal) + COALESCE(ba.basePrevidenciaFerias, 0) + COALESCE(ba.basePrevidencia13, 0)) END), SUM(CASE WHEN re.tipo = '1' THEN COALESCE(ba.valorPrevidenciaMes, hi.contribuicaoMensal) ELSE (COALESCE(ba.valorPrevidenciaMes, hi.contribuicaoMensal) + COALESCE(ba.valorPrevidencia13, hi.contribuicaoMensal)) END), SUM(COALESCE(ba.basePrevidenciaSegurado, 0)), SUM(COALESCE(ba.totalPatronal, hi.totalPatronal)) ) FROM Trabalhador tr LEFT JOIN tr.bases ba LEFT JOIN ba.referencia re WITH (re.tipo IN ('1', '5', '6', '7')) LEFT JOIN tr.rpssHistoricosFinanceiros hi WHERE tr.trabalhadorPK = :trabalhadorPK  AND (COALESCE(ba.valorPrevidenciaMes, hi.contribuicaoMensal) + COALESCE(ba.valorPrevidencia13, hi.contribuicao13) + COALESCE(ba.basePrevidenciaFerias, 0) > 0) AND COALESCE(re.mes.mesPK.ano, hi.ano) IS NOT NULL AND re.encerrado IS TRUE AND re.situacao = 0 AND re.sipweb IS TRUE GROUP BY tr.trabalhadorPK.registro, tr.trabalhadorPK.entidade, COALESCE(re.mes.mesPK.ano, hi.ano), COALESCE(re.mes.mesPK.mes, hi.mes) ";
    private String registro;
    private String empresaId;
    private String ano;
    private String mes;
    private Double basePrevidencia;
    private Double valorPrevidencia;
    private Double totalPatronal;
    private Double basePrevidenciaSegurado;

    public SalarioPrevidenciaVo(String registro, String empresaId, String ano, String mes, Double basePrevidencia, Double valorPrevidencia, Double basePrevidenciaSegurado, Double totalPatronal) {
        this.registro = registro;
        this.empresaId = empresaId;
        this.ano = ano;
        this.mes = mes;
        this.basePrevidencia = basePrevidencia;
        this.valorPrevidencia = valorPrevidencia;
        this.basePrevidenciaSegurado = basePrevidenciaSegurado;
        this.totalPatronal = totalPatronal;
    }

    public String getRegistro() {
        return this.registro;
    }

    public String getEmpresaId() {
        return this.empresaId;
    }

    public String getAno() {
        return this.ano;
    }

    public String getMes() {
        return this.mes;
    }

    public Double getBasePrevidencia() {
        return this.basePrevidencia;
    }

    public Double getTotalPatronal() {
        return this.totalPatronal;
    }

    public Double getValorPrevidencia() {
        return this.valorPrevidencia;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public void setEmpresaId(String empresaId) {
        this.empresaId = empresaId;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public void setBasePrevidencia(Double basePrevidencia) {
        this.basePrevidencia = basePrevidencia;
    }

    public void setValorPrevidencia(Double valorPrevidencia) {
        this.valorPrevidencia = valorPrevidencia;
    }

    public void setTotalPatronal(Double totalPatronal) {
        this.totalPatronal = totalPatronal;
    }

    public String toString() {
        return "<br />SalarioPrevidenciaVo [registro=" + this.registro + ", empresaId=" + this.empresaId + ", ano=" + this.ano + ", mes=" + this.mes + ", basePrevidencia=" + this.basePrevidencia + ", valorPrevidencia=" + this.valorPrevidencia + ", basePrevidenciaSegurado=" + this.basePrevidenciaSegurado + ", totalPatronal=" + this.totalPatronal + "]<br />";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ano == null ? 0 : this.ano.hashCode());
        result = 31 * result + (this.empresaId == null ? 0 : this.empresaId.hashCode());
        result = 31 * result + (this.mes == null ? 0 : this.mes.hashCode());
        result = 31 * result + (this.registro == null ? 0 : this.registro.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SalarioPrevidenciaVo other = (SalarioPrevidenciaVo)obj;
        if (this.ano == null ? other.ano != null : !this.ano.equals(other.ano)) {
            return false;
        }
        if (this.empresaId == null ? other.empresaId != null : !this.empresaId.equals(other.empresaId)) {
            return false;
        }
        if (this.mes == null ? other.mes != null : !this.mes.equals(other.mes)) {
            return false;
        }
        return !(this.registro == null ? other.registro != null : !this.registro.equals(other.registro));
    }

    public Double getBasePrevidenciaSegurado() {
        return this.basePrevidenciaSegurado;
    }

    public void setBasePrevidenciaSegurado(Double basePrevidenciaSegurado) {
        this.basePrevidenciaSegurado = basePrevidenciaSegurado;
    }
}

