/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;

public class ReferenciaSelecionada {
    private String ano;
    private MesNomeEnum mes;
    private ReferenciaTipo[] tipos;

    public ReferenciaSelecionada() {
        this.ano = SIPDateUtil.getCurrentYear().toString();
        String mesStr = SIPDateUtil.getCurrentMonth();
        this.mes = MesNomeEnum.of(mesStr);
        this.tipos = new ReferenciaTipo[]{ReferenciaTipo.FOLHA_MENSAL};
    }

    public ReferenciaSelecionada(String ano, MesNomeEnum mes, ReferenciaTipo[] tipos) {
        this.ano = ano;
        this.mes = mes;
        this.tipos = tipos;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public MesNomeEnum getMes() {
        return this.mes;
    }

    public void setMes(MesNomeEnum mes) {
        this.mes = mes;
    }

    public ReferenciaTipo[] getTipos() {
        return this.tipos;
    }

    public void setTipos(ReferenciaTipo[] tipos) {
        this.tipos = tipos;
    }

    public ReferenciaTipo getTipo() {
        if (this.tipos != null && this.tipos.length > 0) {
            return this.tipos[0];
        }
        return null;
    }

    public void setTipo(ReferenciaTipo tipo) {
        if (this.tipos == null || this.tipos.length < 1) {
            this.tipos = new ReferenciaTipo[1];
        }
        this.tipos[0] = tipo;
    }

    public String getTiposToString() {
        if (this.tipos == null || this.tipos.length == 0) {
            return "Selecione";
        }
        if (this.tipos.length == ReferenciaTipo.values().length) {
            return "Todas as Refer\u00eancias";
        }
        StringBuilder sb = new StringBuilder();
        if (this.tipos.length == 1) {
            sb.append(this.tipos[0].getCodigo());
            sb.append(" - ");
            sb.append(this.tipos[0].getDescricao());
            return sb.toString();
        }
        sb.append("Mix: (");
        for (ReferenciaTipo r : this.tipos) {
            sb.append(r.getCodigo());
            sb.append(",");
        }
        sb.append(")");
        int start = sb.indexOf(",)");
        sb.replace(start, start + 1, "");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ano == null ? 0 : this.ano.hashCode());
        result = 31 * result + (this.mes == null ? 0 : this.mes.hashCode());
        result = 31 * result + (this.tipos == null ? 0 : this.tipos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenciaSelecionada other = (ReferenciaSelecionada)obj;
        if (this.ano == null ? other.ano != null : !this.ano.equals(other.ano)) {
            return false;
        }
        if (this.mes != other.mes) {
            return false;
        }
        return this.tipos == other.tipos;
    }

    public String toString() {
        return "ReferenciaAtual [ano=" + this.ano + ", mes=" + (Object)((Object)this.mes) + ", tipo=" + this.tipos + "]";
    }
}

