/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.Cid;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorSituacao;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(name="movimento-sefip")
@XmlType(propOrder={"situacaoMovimentoDescricao", "nome", "dataInicioF", "dataFimF"})
public class MovimentoSefipVo {
    public static final String JPQL_CONSTRUCTOR = "SELECT NEW " + MovimentoSefipVo.class.getName() + "(m.trabalhador.matricula, m.trabalhador.contrato, m.situacao, " + "coalesce(r.nome, s.nome, 'Causa Indefinida'), " + "m.dataInicio, m.dataFim, t.nome, d.data, c.codigo, c.nome, m.dataAlta, r.sefipReduzidoPK.codigo, s.codigo, s.nome) " + "FROM MovimentoSefip m " + "LEFT JOIN m.codigoAfastamento r " + "LEFT JOIN m.causa c " + "LEFT JOIN m.codigoMovimentoSefipSaida s " + "LEFT JOIN m.documentoSaida d " + "LEFT JOIN d.tipoLegal t ";
    public static final String SQL_FIND_LAST_DAYS_TO_HISTORY = "SELECT DISTINCT new " + MovimentoSefipVo.class.getName() + "(m.id, coalesce(a.nome, s.nome, 'Causa Indefinida'), m.dataInicio, m.dataFim) " + "FROM MovimentoSefip m " + "LEFT JOIN m.codigoAfastamento a " + "LEFT JOIN m.codigoMovimentoSefipSaida s " + "WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK " + "\tAND m.situacao = '3' " + "\tAND ((m.dataInicio >= (current_date - trunc(:dias))) " + "\t\tOR (coalesce(m.dataFim, current_date) >= (current_date - trunc(:dias)))) ";
    private Integer id;
    private Integer matricula;
    private Short contrato;
    private String situacao;
    private String nome;
    private Date dataInicio;
    private Date dataFim;
    private String tipoLegalSaida;
    private Date dataDocumentoSaida;
    private List<Cid> cids;
    private String causaCodigo;
    private String causaNome;
    private Date dataAlta;
    private Integer codigoAfastamento;
    private String movimentoSefipSaidaCodigo;
    private String movimentoSefipSaidaNome;

    public MovimentoSefipVo() {
    }

    public MovimentoSefipVo(Integer matricula, Short contrato, String situacao, String nome, Date dataInicio, Date dataFim, String tipoLegalSaida, Date dataDocumentoSaida, String causaCodigo, String causaNome, Date dataAlta, Integer codigoAfastamento, String movimentoSefipSaidaCodigo, String movimentoSefipSaidaNome) {
        this.matricula = matricula;
        this.contrato = contrato;
        this.situacao = situacao;
        this.nome = nome;
        this.dataInicio = dataInicio;
        this.dataFim = dataFim;
        this.tipoLegalSaida = tipoLegalSaida;
        this.dataDocumentoSaida = dataDocumentoSaida;
        this.causaCodigo = causaCodigo;
        this.causaNome = causaNome;
        this.dataAlta = dataAlta;
        this.codigoAfastamento = codigoAfastamento;
        this.movimentoSefipSaidaCodigo = movimentoSefipSaidaCodigo;
        this.movimentoSefipSaidaNome = movimentoSefipSaidaNome;
    }

    public MovimentoSefipVo(Integer id, String nome, Date dataInicio, Date dataFim) {
        this.id = id;
        this.nome = nome;
        this.dataInicio = dataInicio;
        this.dataFim = dataFim;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setMatricula(Integer matricula) {
        this.matricula = matricula;
    }

    public void setContrato(Short contrato) {
        this.contrato = contrato;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    @XmlTransient
    public Integer getId() {
        return this.id;
    }

    @XmlTransient
    public Integer getMatricula() {
        return this.matricula;
    }

    @XmlTransient
    public Short getContrato() {
        return this.contrato;
    }

    @XmlAttribute
    public String getNome() {
        return this.nome;
    }

    @XmlTransient
    public Date getDataInicio() {
        return this.dataInicio;
    }

    @XmlAttribute(name="data-inicio")
    public String getDataInicioF() {
        if (this.dataInicio != null) {
            return new SimpleDateFormat("yyyy-MM-dd").format(this.dataInicio);
        }
        return "";
    }

    @XmlTransient
    public Date getDataFim() {
        return this.dataFim;
    }

    @XmlAttribute(name="data-fim")
    public String getDataFimF() {
        if (this.dataFim != null) {
            return new SimpleDateFormat("yyyy-MM-dd").format(this.dataFim);
        }
        return "";
    }

    @XmlTransient
    public String getSituacao() {
        return this.situacao;
    }

    @XmlTransient
    public String getSituacaoMovimento() {
        return this.situacao;
    }

    @XmlAttribute(name="situacao-movimento")
    public String getSituacaoMovimentoDescricao() {
        return TrabalhadorSituacao.get(this.situacao).getDescricao();
    }

    @XmlTransient
    public String getTipoLegalSaida() {
        return this.tipoLegalSaida;
    }

    @XmlTransient
    public Date getDataDocumentoSaida() {
        return this.dataDocumentoSaida;
    }

    public void setCids(List<Cid> cids) {
        this.cids = cids;
    }

    @XmlTransient
    public String cidListToString(String separator) {
        return this.cidListToString(this.cids, separator, true);
    }

    @XmlTransient
    private String cidListToString(List<Cid> cids, String separator, boolean withDescription) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (cids != null && !cids.isEmpty()) {
            for (Cid cid : cids) {
                returnList.add(withDescription ? cid.getCodigo().trim().concat(" ").concat(cid.getNome().trim()) : cid.getCodigo().trim());
            }
        }
        return StringUtils.join(returnList, (String)separator);
    }

    @XmlTransient
    public Integer getDias() {
        Integer dias = 0;
        if (this.dataInicio != null && this.dataFim != null) {
            dias = SIPDateUtil.countDays((Date)this.dataInicio, (Date)this.dataFim);
        }
        return dias;
    }

    @XmlTransient
    public String getCausaCodigo() {
        return this.causaCodigo;
    }

    public void setCausaCodigo(String causaCodigo) {
        this.causaCodigo = causaCodigo;
    }

    @XmlTransient
    public String getCausaNome() {
        return this.causaNome;
    }

    public void setCausaNome(String causaNome) {
        this.causaNome = causaNome;
    }

    @XmlTransient
    public Date getDataAlta() {
        return this.dataAlta;
    }

    public void setDataAlta(Date dataAlta) {
        this.dataAlta = dataAlta;
    }

    @XmlTransient
    public Integer getCodigoAfastamento() {
        return this.codigoAfastamento;
    }

    public void setCodigoAfastamento(Integer codigoAfastamento) {
        this.codigoAfastamento = codigoAfastamento;
    }

    @XmlTransient
    public String getMovimentoSefipSaidaCodigo() {
        return this.movimentoSefipSaidaCodigo;
    }

    public void setMovimentoSefipSaidaCodigo(String movimentoSefipSaidaCodigo) {
        this.movimentoSefipSaidaCodigo = movimentoSefipSaidaCodigo;
    }

    @XmlTransient
    public String getMovimentoSefipSaidaNome() {
        return this.movimentoSefipSaidaNome;
    }

    public void setMovimentoSefipSaidaNome(String movimentoSefipSaidaNome) {
        this.movimentoSefipSaidaNome = movimentoSefipSaidaNome;
    }

    public String toString() {
        return "MovimentoSefipVo [getNome()=" + this.getNome() + ", getDataInicio()=" + this.getDataInicio() + ", getDataInicioF()=" + this.getDataInicioF() + ", getDataFim()=" + this.getDataFim() + ", getDataFimF()=" + this.getDataFimF() + ", getSituacao()=" + this.getSituacao() + ", getSituacaoMovimento()=" + this.getSituacaoMovimento() + ", getSituacaoMovimentoDescricao()=" + this.getSituacaoMovimentoDescricao() + "]";
    }
}

