/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sipweb.vo.BasesVo;
import br.com.fiorilli.sipweb.vo.EventoVo;
import br.com.fiorilli.sipweb.vo.MovimentoSefipVo;
import br.com.fiorilli.sipweb.vo.MovimentoVo;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(name="holerite")
@XmlType(propOrder={"refsalarial", "cbo", "divisao", "subdivisao", "unidade", "cargo", "vinculo", "localTrabalho", "bases", "mensagem", "eventos", "movimentosSefip", "regimeJuridico"})
public class HoleriteVo {
    private String refsalarial;
    private String cbo;
    private String divisao;
    private String subdivisao;
    private String unidade;
    private String cargo;
    private String regimeJuridico;
    private String vinculo;
    private String localTrabalho;
    private String mensagem;
    private String mes;
    private String referenciaTipo;
    private BasesVo bases;
    private Entidade entidade;
    private Trabalhador trabalhador;
    private List<EventoVo> eventos;
    private List<MovimentoSefipVo> movimentosSefip;
    private String refSalarialCodigo;
    private String refSalarialNome;
    private String refSalarialClasse;
    private String refSalarialNivel;
    private String nomeCargo;
    private String mensagemFerias;
    private Date primeiroDiaReferencia;
    private Date ultimoDiaReferencia;
    private List<MovimentoVo> movimentos;
    private Date aquisitivoInicio;
    private Date aquisitivoFim;
    private Date gozoInicio;
    private Date gozoFim;
    private Short diasPagto;
    private Short diasAbono;
    private byte[] brasao;

    public HoleriteVo() {
    }

    private HoleriteVo(Builder builder) {
        this.refsalarial = builder.refsalarial;
        this.cbo = builder.cbo;
        this.divisao = builder.divisao;
        this.subdivisao = builder.subdivisao;
        this.unidade = builder.unidade;
        this.cargo = builder.cargo;
        this.regimeJuridico = builder.regimeJuridico;
        this.vinculo = builder.vinculo;
        this.localTrabalho = builder.localTrabalho;
        this.mensagem = builder.mensagem;
        this.mes = builder.mes;
        this.referenciaTipo = builder.referenciaTipo;
        this.eventos = builder.eventoList;
        this.bases = builder.bases;
    }

    @XmlAttribute(name="referencia-salarial")
    public String getRefsalarial() {
        return this.refsalarial;
    }

    public void setRefsalarial(String refsalarial) {
        this.refsalarial = refsalarial;
    }

    @XmlTransient
    public String getRefSalarialCodigo() {
        return this.refSalarialCodigo;
    }

    public void setRefSalarialCodigo(String refSalarialCodigo) {
        this.refSalarialCodigo = refSalarialCodigo;
    }

    @XmlTransient
    public String getRefSalarialNome() {
        return this.refSalarialNome;
    }

    public void setRefSalarialNome(String refSalarialNome) {
        this.refSalarialNome = refSalarialNome;
    }

    @XmlTransient
    public String getRefSalarialClasse() {
        return this.refSalarialClasse;
    }

    public void setRefSalarialClasse(String refSalarialClasse) {
        this.refSalarialClasse = refSalarialClasse;
    }

    public String getRefSalarialNivel() {
        return this.refSalarialNivel;
    }

    public void setRefSalarialNivel(String refSalarialNivel) {
        this.refSalarialNivel = refSalarialNivel;
    }

    public String getNomeCargo() {
        return this.nomeCargo;
    }

    public void setNomeCargo(String nomeCargo) {
        this.nomeCargo = nomeCargo;
    }

    @XmlAttribute
    public String getCbo() {
        return this.cbo;
    }

    public void setCbo(String cbo) {
        this.cbo = cbo;
    }

    @XmlAttribute
    public String getDivisao() {
        return this.divisao;
    }

    public void setDivisao(String divisao) {
        this.divisao = divisao;
    }

    @XmlAttribute
    public String getSubdivisao() {
        return this.subdivisao;
    }

    public void setSubdivisao(String subdivisao) {
        this.subdivisao = subdivisao;
    }

    @XmlAttribute
    public String getUnidade() {
        return this.unidade;
    }

    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    @XmlAttribute
    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    @XmlAttribute
    public String getRegimeJuridico() {
        return this.regimeJuridico;
    }

    public void setRegimeJuridico(String regimeJuridico) {
        this.regimeJuridico = regimeJuridico;
    }

    @XmlAttribute
    public String getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(String vinculo) {
        this.vinculo = vinculo;
    }

    @XmlAttribute(name="local-trabalho")
    public String getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(String localTrabalho) {
        this.localTrabalho = localTrabalho;
    }

    @XmlElementWrapper(name="eventos")
    @XmlElement(name="evento")
    public List<EventoVo> getEventos() {
        return this.eventos;
    }

    public void setEventos(List<EventoVo> eventos) {
        this.eventos = eventos;
    }

    public BasesVo getBases() {
        return this.bases;
    }

    public void setBases(BasesVo bases) {
        this.bases = bases;
    }

    @XmlAttribute
    public String getMensagem() {
        return this.mensagem;
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    public void setMensagem(String mensagem, Short diasAcidente, Short diasDoenca, Short diasMaternidade) {
        this.mensagem = mensagem;
        if (mensagem != null) {
            if (diasAcidente != null && diasAcidente > 0) {
                if (!StringUtils.isEmpty((CharSequence)mensagem)) {
                    this.mensagem = this.mensagem + "/";
                }
                this.mensagem = this.mensagem + "Dias Acidente: " + diasAcidente;
            }
            if (diasDoenca != null && diasDoenca > 0) {
                if (!StringUtils.isEmpty((CharSequence)mensagem)) {
                    this.mensagem = this.mensagem + "/";
                }
                this.mensagem = this.mensagem + "Dias Doen\u00e7a: " + diasDoenca;
            }
            if (diasMaternidade != null && diasMaternidade > 0) {
                if (!StringUtils.isEmpty((CharSequence)mensagem)) {
                    this.mensagem = this.mensagem + "/";
                }
                this.mensagem = this.mensagem + "Dias Maternidade: " + diasMaternidade;
            }
        }
    }

    @XmlTransient
    public String getReferenciaTipo() {
        return this.referenciaTipo;
    }

    public void setReferenciaTipo(String tipoReferencia) {
        this.referenciaTipo = tipoReferencia;
    }

    @XmlElementWrapper(name="movimentos-sefip")
    @XmlElement(name="movimento-sefip")
    public List<MovimentoSefipVo> getMovimentosSefip() {
        return this.movimentosSefip;
    }

    public void setMovimentosSefip(List<MovimentoSefipVo> movimentosSefip) {
        this.movimentosSefip = movimentosSefip;
    }

    @XmlTransient
    public MovimentoSefipVo getLastMovimentoSefip() {
        if (this.movimentosSefip != null && !this.movimentosSefip.isEmpty()) {
            return this.movimentosSefip.get(this.movimentosSefip.size() - 1);
        }
        return null;
    }

    @XmlTransient
    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    @XmlTransient
    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    @XmlTransient
    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    @XmlTransient
    public String getMensagemFerias() {
        return this.mensagemFerias;
    }

    @XmlTransient
    public Date getPrimeiroDiaReferencia() {
        return this.primeiroDiaReferencia;
    }

    @XmlTransient
    public Date getUltimoDiaReferencia() {
        return this.ultimoDiaReferencia;
    }

    public String toString() {
        return "HoleriteVo [getRefsalarial()=" + this.getRefsalarial() + "\ngetCbo()=" + this.getCbo() + "\ngetDivisao()=" + this.getDivisao() + "\ngetSubdivisao()=" + this.getSubdivisao() + "\ngetUnidade()=" + this.getUnidade() + "\ngetCargo()=" + this.getCargo() + "\ngetVinculo()=" + this.getVinculo() + "\ngetLocalTrabalho()=" + this.getLocalTrabalho() + "\ngetEventos()=" + this.getEventos() + "\ngetBases()=" + this.getBases() + "\ngetMovimentosSefip()=" + this.getMovimentosSefip() + "\ngetRegimeJuridico()=" + this.getRegimeJuridico() + "]";
    }

    @XmlTransient
    public List<MovimentoVo> getMovimentos() {
        return this.movimentos;
    }

    public void setMovimentos(List<MovimentoVo> movimentos) {
        this.movimentos = movimentos;
    }

    @XmlTransient
    public Date getAquisitivoInicio() {
        return this.aquisitivoInicio;
    }

    @XmlTransient
    public Date getAquisitivoFim() {
        return this.aquisitivoFim;
    }

    @XmlTransient
    public Date getGozoInicio() {
        return this.gozoInicio;
    }

    @XmlTransient
    public Date getGozoFim() {
        return this.gozoFim;
    }

    @XmlTransient
    public Short getDiasPagto() {
        return this.diasPagto;
    }

    @XmlTransient
    public Short getDiasAbono() {
        return this.diasAbono;
    }

    @XmlTransient
    public byte[] getBrasao() {
        return this.brasao;
    }

    public void setBrasao(byte[] brasao) {
        this.brasao = brasao;
    }

    public void setMensagemFerias(String mensagemFerias) {
        this.mensagemFerias = mensagemFerias;
    }

    public void setPrimeiroDiaReferencia(Date primeiroDiaReferencia) {
        this.primeiroDiaReferencia = primeiroDiaReferencia;
    }

    public void setUltimoDiaReferencia(Date ultimoDiaReferencia) {
        this.ultimoDiaReferencia = ultimoDiaReferencia;
    }

    public void setAquisitivoInicio(Date aquisitivoInicio) {
        this.aquisitivoInicio = aquisitivoInicio;
    }

    public void setAquisitivoFim(Date aquisitivoFim) {
        this.aquisitivoFim = aquisitivoFim;
    }

    public void setGozoInicio(Date gozoInicio) {
        this.gozoInicio = gozoInicio;
    }

    public void setGozoFim(Date gozoFim) {
        this.gozoFim = gozoFim;
    }

    public void setDiasPagto(Short diasPagto) {
        this.diasPagto = diasPagto;
    }

    public void setDiasAbono(Short diasAbono) {
        this.diasAbono = diasAbono;
    }

    public static class Builder {
        private String refsalarial;
        private String cbo;
        private String divisao;
        private String subdivisao;
        private String unidade;
        private String cargo;
        private String regimeJuridico;
        private String vinculo;
        private String localTrabalho;
        private String mensagem;
        private String mes;
        private String referenciaTipo;
        private BasesVo bases;
        private List<EventoVo> eventoList;

        public HoleriteVo build() {
            return new HoleriteVo(this);
        }

        public Builder refsalarial(String refsalarial) {
            this.refsalarial = refsalarial;
            return this;
        }

        public Builder cbo(String cbo) {
            this.cbo = cbo;
            return this;
        }

        public Builder divisao(String divisao) {
            this.divisao = divisao;
            return this;
        }

        public Builder subdivisao(String subdivisao) {
            this.subdivisao = subdivisao;
            return this;
        }

        public Builder unidade(String unidade) {
            this.unidade = unidade;
            return this;
        }

        public Builder cargo(String cargo) {
            this.cargo = cargo;
            return this;
        }

        public Builder regimeJuridico(String regimeJuridico) {
            this.regimeJuridico = regimeJuridico;
            return this;
        }

        public Builder vinculo(String vinculo) {
            this.vinculo = vinculo;
            return this;
        }

        public Builder localTrabalho(String localTrabalho) {
            this.localTrabalho = localTrabalho;
            return this;
        }

        public Builder mensagem(String mensagem) {
            this.mensagem = mensagem;
            return this;
        }

        public Builder mes(String mes) {
            this.mes = mes;
            return this;
        }

        public Builder referenciaTipo(String referenciaTipo) {
            this.referenciaTipo = referenciaTipo;
            return this;
        }

        public Builder referenciaTipo(ReferenciaTipo referenciaTipo) {
            this.referenciaTipo = referenciaTipo.getDescricao();
            return this;
        }

        public Builder bases(BasesVo bases) {
            this.bases = bases;
            return this;
        }

        public Builder eventos(List<EventoVo> eventoList) {
            this.eventoList = eventoList;
            return this;
        }
    }
}

