/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.commons.jaxb.adapter.DateJaxbAdapter;
import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sipweb.vo.TipoAusencia;
import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

@XmlRootElement(name="frequencia")
@XmlType(propOrder={"entidade", "registro", "dataInicial", "dataFinal", "tipo", "subtipo", "chave", "matricula", "contrato", "cpf", "tipoEnum", "dataFinalString", "motivo", "qtdHorasFalta", "codigoReduzido", "dataDaAlteracao", "faltaMeioDia", "faltaMeioDiaPeriodo", "codigoFalta"})
public class FrequenciaVO {
    private String entidade;
    private String registro;
    private Date dataInicial;
    private Date dataFinal;
    private String tipo;
    private String subtipo;
    private String chave;
    private Integer matricula;
    private Short contrato;
    private String cpf;
    private TipoAusencia tipoEnum;
    private String dataFinalString;
    private String motivo;
    private Double qtdHorasFalta;
    private Integer codigoReduzido;
    private Date dataDaAlteracao;
    private Boolean faltaMeioDia;
    private Integer faltaMeioDiaPeriodo;
    private String codigoFalta;

    public FrequenciaVO() {
    }

    public FrequenciaVO(String entidade, String registro, Date dataInicial, Date dataFinal, String tipo, String subtipo, String chave, Integer matricula, Short contrato, String cpf, TipoAusencia tipoEnum, String dataFinalString, String motivo, Double qtdHorasFalta, Integer codigoReduzido, Date dataDaAlteracao) {
        this.entidade = entidade;
        this.registro = registro;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.tipo = tipo;
        this.subtipo = subtipo;
        this.chave = chave;
        this.matricula = matricula;
        this.contrato = contrato;
        this.cpf = cpf;
        this.tipoEnum = tipoEnum;
        this.dataFinalString = dataFinalString;
        this.motivo = motivo;
        this.qtdHorasFalta = qtdHorasFalta;
        this.codigoReduzido = codigoReduzido;
        this.dataDaAlteracao = dataDaAlteracao;
    }

    public FrequenciaVO(String entidade, String registro, Date dataInicial, Date dataFinal, String tipo, String chave, Integer matricula, Short contrato, String cpf, Date dataDaAlteracao) {
        this.entidade = entidade;
        this.registro = registro;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.tipo = tipo;
        this.subtipo = "";
        this.chave = chave;
        this.matricula = matricula;
        this.contrato = contrato;
        this.cpf = cpf;
        if (tipo != null && !tipo.isEmpty()) {
            this.tipoEnum = TipoAusencia.getBy(tipo);
        }
        if (this.tipoEnum != null) {
            this.motivo = this.tipoEnum.getDescricao();
        }
        this.dataDaAlteracao = dataDaAlteracao;
    }

    public FrequenciaVO(String entidade, String registro, Date dataInicial, Date dataFinal, String tipo, String subtipo, String chave) {
        this.entidade = entidade;
        this.registro = registro;
        this.dataInicial = dataInicial;
        this.tipo = StringUtils.defaultString((String)tipo);
        this.subtipo = StringUtils.defaultString((String)subtipo);
        this.chave = StringUtils.defaultString((String)chave);
        this.dataFinal = dataFinal;
    }

    public FrequenciaVO(String entidade, String registro, Date dataInicial, Date dataFinal, String tipo, String subtipo, String chave, Integer matricula, Short contrato, String cpf, Double qtdHoras, String codigoEvento, String nomeEvento, Integer codSefipReduzido, String descricaoSefipREduzido) {
        this.entidade = entidade;
        this.registro = registro;
        this.dataInicial = dataInicial;
        this.tipo = StringUtils.defaultString((String)tipo);
        this.subtipo = StringUtils.defaultString((String)subtipo);
        this.chave = StringUtils.defaultString((String)chave);
        this.dataFinal = dataFinal;
        this.matricula = matricula;
        this.contrato = contrato;
        this.cpf = cpf;
        this.tipoEnum = TipoAusencia.getBy(tipo);
        this.qtdHorasFalta = qtdHoras;
        this.codigoReduzido = codSefipReduzido;
        this.motivo = this.getMotivoFrom(this.tipoEnum, this.codigoReduzido, descricaoSefipREduzido, codigoEvento, nomeEvento);
        if (this.tipoEnum != null && this.tipoEnum.isFalta()) {
            this.codigoFalta = codigoEvento;
        }
    }

    public FrequenciaVO(String entidade, String registro, Date dataInicial, Double dias, String tipo, String subtipo, String chave, Integer matricula, Short contrato, String cpf, Double qtdHoras, String codigoEvento, String nomeEvento, Integer codSefipReduzido, String descricaoSefipREduzido, Boolean meioDia, Integer meioDiaPeriodo) {
        this.entidade = entidade;
        this.registro = registro;
        this.dataInicial = dataInicial;
        this.tipo = StringUtils.defaultString((String)tipo);
        this.subtipo = StringUtils.defaultString((String)subtipo);
        this.chave = StringUtils.defaultString((String)chave);
        this.dataFinal = dataInicial;
        if (dias != null && dias > 0.0) {
            this.dataFinal = DateUtils.addDays((Date)this.dataFinal, (int)(dias.intValue() >= 1 ? dias.intValue() - 1 : 0));
        }
        this.matricula = matricula;
        this.contrato = contrato;
        this.cpf = cpf;
        this.tipoEnum = TipoAusencia.getBy(tipo);
        this.qtdHorasFalta = qtdHoras;
        this.codigoReduzido = codSefipReduzido;
        this.motivo = this.getMotivoFrom(this.tipoEnum, this.codigoReduzido, descricaoSefipREduzido, codigoEvento, nomeEvento);
        this.faltaMeioDia = meioDia;
        this.faltaMeioDiaPeriodo = meioDiaPeriodo;
        if (this.tipoEnum != null && this.tipoEnum.isFalta()) {
            this.codigoFalta = codigoEvento;
        }
    }

    private String getMotivoFrom(TipoAusencia tipoAusencia, Integer codSefipReduzido, String descricaoSefipReduzido, String codigoEvento, String nomeEvento) {
        String motivo = "";
        if (tipoAusencia != null) {
            switch (tipoAusencia) {
                case FERIAS: {
                    motivo = TipoAusencia.FERIAS.getDescricao();
                    break;
                }
                case AFASTAMENTO: {
                    motivo = codSefipReduzido + " - " + descricaoSefipReduzido;
                    break;
                }
                case FALTA: {
                    motivo = codigoEvento + " - " + nomeEvento;
                    break;
                }
                case LICENCA_PREMIO: {
                    motivo = TipoAusencia.LICENCA_PREMIO.getDescricao();
                }
            }
        }
        return motivo;
    }

    @XmlAttribute
    public String getEntidade() {
        return this.entidade;
    }

    @XmlAttribute
    public String getRegistro() {
        return this.registro;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=DateJaxbAdapter.class)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=DateJaxbAdapter.class)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    @XmlAttribute
    public String getTipo() {
        return this.tipo;
    }

    @XmlAttribute
    public String getSubtipo() {
        return this.subtipo;
    }

    @XmlAttribute
    public String getChave() {
        return this.chave;
    }

    @XmlAttribute
    public Integer getMatricula() {
        return this.matricula;
    }

    @XmlAttribute
    public Short getContrato() {
        return this.contrato;
    }

    @XmlAttribute
    public String getCpf() {
        return this.cpf;
    }

    @XmlAttribute
    public TipoAusencia getTipoEnum() {
        return this.tipoEnum;
    }

    @XmlAttribute
    public Double getQtdHorasFalta() {
        return this.qtdHorasFalta;
    }

    @XmlAttribute
    public String getDataFinalString() {
        if ((this.dataFinalString == null || this.dataFinalString.isEmpty()) && this.dataFinal != null) {
            this.dataFinalString = SIPDateUtil.toString((String)"yyyy-MM-dd", (Date)this.dataFinal);
        }
        return this.dataFinalString;
    }

    @XmlAttribute
    public String getMotivo() {
        return this.motivo;
    }

    @XmlAttribute
    public Integer getCodigoReduzido() {
        return this.codigoReduzido;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=DateJaxbAdapter.class)
    public Date getDataDaAlteracao() {
        return this.dataDaAlteracao;
    }

    @XmlAttribute
    public Boolean getFaltaMeioDia() {
        return this.faltaMeioDia;
    }

    public void setFaltaMeioDia(Boolean faltaMeioDia) {
        this.faltaMeioDia = faltaMeioDia;
    }

    @XmlAttribute
    public Integer getFaltaMeioDiaPeriodo() {
        return this.faltaMeioDiaPeriodo;
    }

    public void setFaltaMeioDiaPeriodo(Integer faltaMeioDiaPeriodo) {
        this.faltaMeioDiaPeriodo = faltaMeioDiaPeriodo;
    }

    @XmlAttribute
    public String getCodigoFalta() {
        return this.codigoFalta;
    }

    public void setCodigoFalta(String codigoFalta) {
        this.codigoFalta = codigoFalta;
    }

    public String toCsvFormat() {
        String SEPARTOR = ",";
        return this.entidade + "," + this.registro + "," + this.dataInicial + "," + this.dataFinal + "," + this.tipo + "," + this.subtipo + "," + this.chave + "\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequenciaVO that = (FrequenciaVO)o;
        return Objects.equals(this.chave, that.chave) && Objects.equals(this.dataDaAlteracao, that.dataDaAlteracao);
    }

    public int hashCode() {
        return Objects.hash(this.chave, this.dataDaAlteracao);
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setSubtipo(String subtipo) {
        this.subtipo = subtipo;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public void setMatricula(Integer matricula) {
        this.matricula = matricula;
    }

    public void setContrato(Short contrato) {
        this.contrato = contrato;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public void setTipoEnum(TipoAusencia tipoEnum) {
        this.tipoEnum = tipoEnum;
    }

    public void setDataFinalString(String dataFinalString) {
        this.dataFinalString = dataFinalString;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public void setQtdHorasFalta(Double qtdHorasFalta) {
        this.qtdHorasFalta = qtdHorasFalta;
    }

    public void setCodigoReduzido(Integer codigoReduzido) {
        this.codigoReduzido = codigoReduzido;
    }

    public void setDataDaAlteracao(Date dataDaAlteracao) {
        this.dataDaAlteracao = dataDaAlteracao;
    }
}

