/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import java.io.Serializable;
import java.util.Date;

public class ContratoVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String descricao;
    private final Date dataAdmissao;
    private final Date dataDemissao;
    private final Date dataImplantacaoCartao;
    private final TrabalhadorPK pk;
    private final Integer matricula;
    private final Short contrato;
    private final Short jornadaCodigo;
    private final String cargoAtual;

    public ContratoVo(Integer matricula, Short contrato, Date dataAdmissao, Date dataDemissao, TrabalhadorPK pk) {
        this.pk = pk;
        this.dataAdmissao = dataAdmissao;
        this.dataDemissao = dataDemissao;
        this.matricula = matricula;
        this.contrato = contrato;
        this.cargoAtual = null;
        this.descricao = this.buildDescricao();
        this.dataImplantacaoCartao = null;
        this.jornadaCodigo = null;
    }

    public ContratoVo(Integer matricula, Short contrato, Date dataAdmissao, Date dataDemissao, TrabalhadorPK pk, Date dataImplantacaoCartao, Short jornadaCodigo, String cargoAtual) {
        this.pk = pk;
        this.dataAdmissao = dataAdmissao;
        this.dataDemissao = dataDemissao;
        this.matricula = matricula;
        this.contrato = contrato;
        this.cargoAtual = cargoAtual;
        this.descricao = this.buildDescricao();
        this.dataImplantacaoCartao = dataImplantacaoCartao;
        this.jornadaCodigo = jornadaCodigo;
    }

    private String buildDescricao() {
        StringBuilder sb = new StringBuilder().append(this.pk.getEntidade()).append("/").append(this.matricula).append("-").append(this.contrato).append("/").append(this.pk.getRegistro());
        if (this.getDataAdmissao() != null) {
            sb.append(": ").append(SIPDateUtil.toString((Date)this.getDataAdmissao()));
        }
        if (this.getDataDemissao() != null) {
            sb.append(" \u00e0 ").append(SIPDateUtil.toString((Date)this.getDataDemissao()));
        }
        if (this.getCargoAtual() != null) {
            sb.append(" - ").append(this.cargoAtual);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContratoVo other = (ContratoVo)obj;
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }

    public TrabalhadorPK getPk() {
        return this.pk;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String toString() {
        return this.descricao;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public Date getDataDemissao() {
        return this.dataDemissao;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public Date getDataImplantacaoCartao() {
        return this.dataImplantacaoCartao;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public String getCargoAtual() {
        return this.cargoAtual;
    }
}

