/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import java.util.Date;

public class BasesVo {
    private Double totalProventos;
    private Double totalDescontos;
    private Double liquido;
    private Double valorsalario;
    private Double baseinss;
    private Double basefgts;
    private Double valorfgts;
    private Double baseirrf;
    private String banco;
    private String agencia;
    private String conta;
    private String tipoConta;
    private Short qtddeptsirrf;
    private Double baseCalculo;
    private String categoriaFuncional;
    private String bancoNome;
    private Short qtdDependentesFamilia;
    private Double valorDependentesIrrf;
    private Double valorPrevidencia;
    private Date dataCredito;
    private Integer faltasAbonadas;
    private Date dataPagamento;

    public BasesVo() {
    }

    private BasesVo(Builder builder) {
        this.totalProventos = builder.totalProventos;
        this.totalDescontos = builder.totalDescontos;
        this.liquido = builder.liquido;
        this.valorsalario = builder.valorsalario;
        this.baseinss = builder.baseinss;
        this.basefgts = builder.basefgts;
        this.valorfgts = builder.valorfgts;
        this.baseirrf = builder.baseirrf;
        this.banco = builder.banco;
        this.bancoNome = builder.bancoNome;
        this.agencia = builder.agencia;
        this.conta = builder.conta;
        this.tipoConta = builder.tipoConta;
        this.qtddeptsirrf = builder.qtddeptsirrf;
        this.baseCalculo = builder.baseCalculo;
        this.categoriaFuncional = builder.categoriaFuncional;
    }

    public Double getTotalProventos() {
        return this.totalProventos;
    }

    public void setTotalProventos(Double totalProventos) {
        this.totalProventos = totalProventos;
    }

    public Double getTotalDescontos() {
        return this.totalDescontos;
    }

    public void setTotalDescontos(Double totalDescontos) {
        this.totalDescontos = totalDescontos;
    }

    public Double getLiquido() {
        return this.liquido;
    }

    public void setLiquido(Double liquido) {
        this.liquido = liquido;
    }

    public Double getValorsalario() {
        return this.valorsalario;
    }

    public void setValorsalario(Double valorsalario) {
        this.valorsalario = valorsalario;
    }

    public Double getBaseinss() {
        return this.baseinss;
    }

    public void setBaseinss(Double baseinss) {
        this.baseinss = baseinss;
    }

    public Double getBasefgts() {
        return this.basefgts;
    }

    public void setBasefgts(Double basefgts) {
        this.basefgts = basefgts;
    }

    public Double getValorfgts() {
        return this.valorfgts;
    }

    public void setValorfgts(Double valorfgts) {
        this.valorfgts = valorfgts;
    }

    public Double getBaseirrf() {
        return this.baseirrf;
    }

    public void setBaseirrf(Double baseirrf) {
        this.baseirrf = baseirrf;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    public String getBanco() {
        return this.banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public Short getQtddeptsirrf() {
        return this.qtddeptsirrf;
    }

    public void setQtddeptsirrf(Short qtddeptsirrf) {
        this.qtddeptsirrf = qtddeptsirrf;
    }

    public String getBancoNome() {
        return this.bancoNome;
    }

    public void setBancoNome(String bancoNome) {
        this.bancoNome = bancoNome;
    }

    public Short getQtdDependentesFamilia() {
        return this.qtdDependentesFamilia;
    }

    public void setQtdDependentesFamilia(Short qtdDependentesFamilia) {
        this.qtdDependentesFamilia = qtdDependentesFamilia;
    }

    public Double getValorDependentesIrrf() {
        return this.valorDependentesIrrf;
    }

    public void setValorDependentesIrrf(Double valorDependentesIrrf) {
        this.valorDependentesIrrf = valorDependentesIrrf;
    }

    public String getTipoConta() {
        return this.tipoConta;
    }

    public void setTipoConta(String tipoConta) {
        this.tipoConta = tipoConta;
    }

    public Double getBaseCalculo() {
        return this.baseCalculo;
    }

    public void setBaseCalculo(Double baseCalculo) {
        this.baseCalculo = baseCalculo;
    }

    public String getCategoriaFuncional() {
        return this.categoriaFuncional;
    }

    public void setCategoriaFuncional(String categoriaFuncional) {
        this.categoriaFuncional = categoriaFuncional;
    }

    public Double getValorPrevidencia() {
        return this.valorPrevidencia;
    }

    public void setValorPrevidencia(Double valorPrevidencia) {
        this.valorPrevidencia = valorPrevidencia;
    }

    public Date getDataCredito() {
        return this.dataCredito;
    }

    public void setDataCredito(Date dataCredito) {
        this.dataCredito = dataCredito;
    }

    public Integer getFaltasAbonadas() {
        return this.faltasAbonadas;
    }

    public void setFaltasAbonadas(Integer faltasAbonadas) {
        this.faltasAbonadas = faltasAbonadas;
    }

    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    public String toString() {
        return "BasesVo [getTotalProventos()=" + this.getTotalProventos() + ", getTotalDescontos()=" + this.getTotalDescontos() + ", getLiquido()=" + this.getLiquido() + ", getValorsalario()=" + this.getValorsalario() + ", getBaseinss()=" + this.getBaseinss() + ", getBasefgts()=" + this.getBasefgts() + ", getValorfgts()=" + this.getValorfgts() + ", getBaseirrf()=" + this.getBaseirrf() + ", getAgencia()=" + this.getAgencia() + ", getConta()=" + this.getConta() + ", getBanco()=" + this.getBanco() + ", getQtddeptsirrf()=" + this.getQtddeptsirrf() + "]";
    }

    public static class Builder {
        private Double totalProventos = 0.0;
        private Double totalDescontos = 0.0;
        private Double liquido = null;
        private Double valorsalario = 0.0;
        private Double baseinss = 0.0;
        private Double basefgts = 0.0;
        private Double valorfgts = 0.0;
        private Double baseirrf = 0.0;
        private String banco = "";
        private String bancoNome = "";
        private String agencia = "";
        private String conta = "";
        private String tipoConta = "";
        private Short qtddeptsirrf = 0;
        private Double baseCalculo = 0.0;
        private String categoriaFuncional = "";

        public BasesVo build() {
            if (this.liquido == null) {
                this.liquido = this.totalProventos - this.totalDescontos;
            }
            return new BasesVo(this);
        }

        public Builder addProventos(Double provento) {
            Builder builder = this;
            builder.totalProventos = builder.totalProventos + provento;
            return this;
        }

        public Builder addDescontos(Double desconto) {
            Builder builder = this;
            builder.totalDescontos = builder.totalDescontos + desconto;
            return this;
        }

        public Builder liquido(Double liquido) {
            this.liquido = liquido;
            return this;
        }

        public Builder valorsalario(Double valorsalario) {
            this.valorsalario = valorsalario;
            return this;
        }

        public Builder addBaseinss(Double baseinss) {
            Builder builder = this;
            builder.baseinss = builder.baseinss + baseinss;
            return this;
        }

        public Builder addBasefgts(Double basefgts) {
            Builder builder = this;
            builder.basefgts = builder.basefgts + basefgts;
            return this;
        }

        public Builder addValorfgts(Double valorfgts) {
            Builder builder = this;
            builder.valorfgts = builder.valorfgts + valorfgts;
            return this;
        }

        public Builder addBaseirrf(Double baseirrf) {
            Builder builder = this;
            builder.baseirrf = builder.baseirrf + baseirrf;
            return this;
        }

        public Builder banco(String banco) {
            this.banco = banco;
            return this;
        }

        public Builder bancoNome(String bancoNome) {
            this.bancoNome = bancoNome;
            return this;
        }

        public Builder agencia(String agencia) {
            this.agencia = agencia;
            return this;
        }

        public Builder conta(String conta) {
            this.conta = conta;
            return this;
        }

        public Builder tipoConta(String tipo) {
            this.tipoConta = tipo;
            return this;
        }

        public Builder qtddeptsirrf(Short qtddeptsirrf) {
            this.qtddeptsirrf = qtddeptsirrf;
            return this;
        }

        public Builder baseCalculo(Double baseCalculo) {
            this.baseCalculo = baseCalculo;
            return this;
        }

        public Builder categoriaFuncional(String categoriaFuncional) {
            this.categoriaFuncional = categoriaFuncional;
            return this;
        }
    }
}

