/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sipweb.vo;

import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.vo.cartaoponto.JornadaPeriodoVO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class BasePontoData {
    private String vinculoCodigo;
    private Date dataBaseDsr;
    private Boolean hasSobreaviso;
    private List<JornadaPeriodoVO> jornadaPeriodos;
    private Duration limiteDeHorasExtras;
    private String descontarDsrInjustificada;
    private String eventoDescontoDSRFaltaInjustificada;
    private Boolean hasCompensacoes;
    private Boolean hasFaltas;
    private Boolean hasTrocaDeTurno;
    private Boolean hasPontoFacultativo;
    private Boolean hasPontoFacultativoNominal;
    private Date dataAdmissao;

    public BasePontoData(String vinculoCodigo, String limiteHorasExtras, Date dataBaseDsr, String descontarDsrInjustificada, String eventoDescontoDSRFaltaInjustificada, Boolean hasCompensacoes, Boolean hasFaltas, Boolean hasSobreaviso, Boolean hasTrocaDeTurno, Boolean hasPontoFacultativo, Boolean hasPontoFacultativoNominal, List<JornadaPeriodoVO> jornadaPeriodos, Date dataAdmissao) {
        this.vinculoCodigo = vinculoCodigo;
        this.dataBaseDsr = dataBaseDsr;
        this.descontarDsrInjustificada = descontarDsrInjustificada;
        this.eventoDescontoDSRFaltaInjustificada = eventoDescontoDSRFaltaInjustificada;
        this.hasSobreaviso = hasSobreaviso;
        this.hasTrocaDeTurno = hasTrocaDeTurno;
        this.hasPontoFacultativo = hasPontoFacultativo;
        this.hasPontoFacultativoNominal = hasPontoFacultativoNominal;
        this.jornadaPeriodos = jornadaPeriodos;
        this.dataAdmissao = dataAdmissao;
        this.limiteDeHorasExtras = limiteHorasExtras != null && limiteHorasExtras.startsWith("  :") ? TimeUtils.toDuration((String)"") : TimeUtils.toDuration((String)limiteHorasExtras);
        this.hasCompensacoes = hasCompensacoes;
        this.hasFaltas = hasFaltas;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public Date getDataBaseDsr() {
        return this.dataBaseDsr;
    }

    public Short getJornada(Date dataPonto) {
        return this.getJornadaPeriodo(dataPonto).getJornadaCodigo();
    }

    public Boolean isJornadaLivre(Date dataPonto) {
        return this.getJornadaPeriodo(dataPonto).isJornadaLivre();
    }

    private JornadaPeriodoVO getJornadaPeriodo(Date dataPonto) {
        DateTime dateTimeDoPonto = new DateTime((Object)dataPonto);
        for (JornadaPeriodoVO jornadaPeriodo : this.jornadaPeriodos) {
            if (dateTimeDoPonto.getMillis() < jornadaPeriodo.getPeriodo().getStartMillis() || dateTimeDoPonto.getMillis() > jornadaPeriodo.getPeriodo().getEndMillis()) continue;
            return jornadaPeriodo;
        }
        throw new ContextedRuntimeException("Jornada n\u00e3o encontrada").addContextValue("DATA_PONTO", (Object)dataPonto).addContextValue("PERIODOS", this.jornadaPeriodos);
    }

    public List<JornadaPeriodoVO> getJornadaPeriodos() {
        return this.jornadaPeriodos;
    }

    public Duration getLimiteDeHorasExtras() {
        return this.limiteDeHorasExtras;
    }

    public boolean hasLimitOfHorasExtras() {
        return this.limiteDeHorasExtras != null;
    }

    public String getDescontarDsrInjustificada() {
        return this.descontarDsrInjustificada;
    }

    public String getEventoDescontoDSRFaltaInjustificada() {
        return this.eventoDescontoDSRFaltaInjustificada;
    }

    public Boolean hasCompensacoes() {
        return this.hasCompensacoes;
    }

    public Boolean hasFaltas() {
        return this.hasFaltas;
    }

    public Boolean hasSobreaviso() {
        return this.hasSobreaviso;
    }

    public Boolean hasTrocaDeTurno() {
        return this.hasTrocaDeTurno;
    }

    public Boolean hasPontoFacultativo() {
        return this.hasPontoFacultativo;
    }

    public Boolean hasPontoFacultativoNominal() {
        return this.hasPontoFacultativoNominal;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }
}

