/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="divisaoCodigo", label="Divis\u00e3o", inputType=FilterInputType.TEXT, condition=FilterCondition.IGUAL, order=1), @FilterConfigParameter(fieldClass=String.class, id="subdivisaoCodigo", label="Subdivis\u00e3o", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=2), @FilterConfigParameter(fieldClass=Integer.class, id="departamentoDespesa", label="Unidade Or\u00e7ament\u00e1ria", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=3), @FilterConfigParameter(fieldClass=String.class, id="vinculoCodigo", label="V\u00ednculo", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=4), @FilterConfigParameter(fieldClass=String.class, id="localTrabalhoCodigo", label="Local de Trabalho", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=5), @FilterConfigParameter(fieldClass=Integer.class, id="categoriaFuncionalCodigo", label="Cat. Funcional", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=6)})
public class RelatorioSituacaoVO {
    public static final String FILTER = "$P{[divisaoCodigo],[t.divisaoCodigo],[:divisaoCodigo]} AND $P{[subdivisaoCodigo],[t.subdivisaoCodigo],[:subdivisaoCodigo]} AND $P{[departamentoDespesa],[t.unidadeCodigo],[:departamentoDespesa]} AND $P{[vinculoCodigo],[t.vinculoCodigo],[:vinculoCodigo]} AND $P{[localTrabalhoCodigo],[t.localTrabalhoCodigo],[:localTrabalhoCodigo]} AND $P{[categoriaFuncionalCodigo],[t.categoriaFuncionalCodigo],[:categoriaFuncionalCodigo]} \n ";
    public static final String SELECT1 = " SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelatorioSituacaoVO ( \n m.causaCodigo, c.nome as nome_rais, COUNT(m.registro) as quantidade ) \n FROM MovimentoSefip m \n JOIN m.trabalhador t \n LEFT JOIN t.cargoAtual \n g LEFT JOIN m.causa c \n WHERE m.entidadeCodigo=:entidadeCodigo \n AND m.situacao='3' \n AND m.dataInicio <=:dataOcupacao \n AND ((m.dataFim >:dataOcupacao) or (m.dataFim IS NULL)) and \n $P{[divisaoCodigo],[t.divisaoCodigo],[:divisaoCodigo]} AND $P{[subdivisaoCodigo],[t.subdivisaoCodigo],[:subdivisaoCodigo]} AND $P{[departamentoDespesa],[t.unidadeCodigo],[:departamentoDespesa]} AND $P{[vinculoCodigo],[t.vinculoCodigo],[:vinculoCodigo]} AND $P{[localTrabalhoCodigo],[t.localTrabalhoCodigo],[:localTrabalhoCodigo]} AND $P{[categoriaFuncionalCodigo],[t.categoriaFuncionalCodigo],[:categoriaFuncionalCodigo]} \n  GROUP BY m.causaCodigo, c.nome ";
    public static final String SELECT2 = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelatorioSituacaoVO ( \n CAST(t.situacao as string), cast('Normal' as string), count(t.trabalhadorPK.registro) ) \n FROM Trabalhador t LEFT JOIN t.cargoAtual g LEFT JOIN t.movimentoSefipList m WITH m.dataInicio <= :dataOcupacao AND ((m.dataFim > :dataOcupacao) OR (m.dataFim  IS NULL)) WHERE t.trabalhadorPK.entidade =:entidadeCodigo AND ((t.situacao = '1') OR (((t.dataDemissao > :dataOcupacao) AND (COALESCE(t.diaDemissaoTrabalhado,'N') = 'N')) OR ((t.dataDemissao >= :dataOcupacao) AND (t.diaDemissaoTrabalhado = 'S')))) AND m.registro IS NULL  and \n $P{[divisaoCodigo],[t.divisaoCodigo],[:divisaoCodigo]} AND $P{[subdivisaoCodigo],[t.subdivisaoCodigo],[:subdivisaoCodigo]} AND $P{[departamentoDespesa],[t.unidadeCodigo],[:departamentoDespesa]} AND $P{[vinculoCodigo],[t.vinculoCodigo],[:vinculoCodigo]} AND $P{[localTrabalhoCodigo],[t.localTrabalhoCodigo],[:localTrabalhoCodigo]} AND $P{[categoriaFuncionalCodigo],[t.categoriaFuncionalCodigo],[:categoriaFuncionalCodigo]} \n GROUP BY 1, 2 ORDER BY 3";
    private final String causaCodigo;
    private final String nome;
    private final Long quantidade;

    public RelatorioSituacaoVO(String causaCodigo, String nome, Long quantidade) {
        this.causaCodigo = causaCodigo;
        this.nome = nome;
        this.quantidade = quantidade;
    }

    public static String getFilter() {
        return FILTER;
    }

    public static String getSelect1() {
        return SELECT1;
    }

    public static String getSelect2() {
        return SELECT2;
    }

    public String getCausaCodigo() {
        return this.causaCodigo;
    }

    public String getNome() {
        return this.nome;
    }

    public Long getQuantidade() {
        return this.quantidade;
    }
}

