/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.CategoriaFuncional;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.util.Date;

@FilterConfigType(query="LEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.unidade u \nLEFT JOIN b.localTrabalho l \nLEFT JOIN b.vinculo v \nLEFT JOIN b.cargo c \nLEFT JOIN b.categoriaFuncional f \nLEFT JOIN b.salario rs \nWHERE r.entidadeCodigo = :entidadeCodigo \nAND r.tipo = :tipoReferencia AND \n$P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nomeTrabalhador],[t],[:nomeTrabalhador]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[divisaoCodigo],[d],[:divisaoCodigo]} AND $P{[subdivisaoCodigo],[s],[:subdivisaoCodigo]} AND $P{[departamentoDespesa],[u],[:departamentoDespesa]} AND $P{[vinculoCodigo],[v],[:vinculoCodigo]} AND $P{[localTrabalhoCodigo],[l],[:localTrabalhoCodigo]} AND $P{[categoriaFuncionalCodigo],[f],[:categoriaFuncionalCodigo]} AND $P{[cargoCodigo],[c],[:cargoCodigo]} AND $P{[proventos],[b.totalProventos],[:proventos]} AND $P{[descontos],[b.totalDescontos],[:descontos]} AND $P{[liquido],[b.liquido],[:liquido]} AND $P{[custo],[SUM(b.totalProventos + b.totalPatronal - b.valorSalarioFamiliaDeducao - b.valorSalarioMaternidadeDeducao - b.outrasDeducoes + b.valorFgtsMes + b.valorFgtsAdiantamento13 + b.valorFgtsFechamento13 + b.fgtsLeiComplementar110)],[:custo]} AND $P{[atividade],[t.atividadeCodigo],[:atividade]} AND ")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Trabalhador.class, id="nomeTrabalhador", label="Nome", inputType=FilterInputType.AUTO_COMPLETE, order=4, query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Data Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Salario", enumClass=TrabalhadorTipoSalario.class, enumId="label"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisaoCodigo", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisaoCodigo", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Unidade.class, id="departamentoDespesa", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculoCodigo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalhoCodigo", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=CategoriaFuncional.class, id="categoriaFuncionalCodigo", label="Categoria Funcional", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM CategoriaFuncional c where UPPER(c.nome) LIKE UPPER('%'||:param||'%') AND c.categoriaFuncionalPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargoCodigo", label=" Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Double.class, id="proventos", label="Proventos", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="descontos", label="Descontos", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="liquido", label="Liquido", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="custo", label="Custo", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Integer.class, id="atividade", label="Atividade", inputType=FilterInputType.NUMBER)})
public class RelatorioListagemPlanilhaCustoPlanilhaVo {
    public static final String SELECT = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelatorioListagemPlanilhaCustoPlanilhaVo( \nlin.nome AS nomeLinha, col.nome AS nomeColuna, \n";
    public static final String WHERE = "LEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.unidade u \nLEFT JOIN b.localTrabalho l \nLEFT JOIN b.vinculo v \nLEFT JOIN b.cargo c \nLEFT JOIN b.categoriaFuncional f \nLEFT JOIN b.salario rs \nWHERE r.entidadeCodigo = :entidadeCodigo \nAND r.tipo = :tipoReferencia AND \n$P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nomeTrabalhador],[t],[:nomeTrabalhador]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[divisaoCodigo],[d],[:divisaoCodigo]} AND $P{[subdivisaoCodigo],[s],[:subdivisaoCodigo]} AND $P{[departamentoDespesa],[u],[:departamentoDespesa]} AND $P{[vinculoCodigo],[v],[:vinculoCodigo]} AND $P{[localTrabalhoCodigo],[l],[:localTrabalhoCodigo]} AND $P{[categoriaFuncionalCodigo],[f],[:categoriaFuncionalCodigo]} AND $P{[cargoCodigo],[c],[:cargoCodigo]} AND $P{[proventos],[b.totalProventos],[:proventos]} AND $P{[descontos],[b.totalDescontos],[:descontos]} AND $P{[liquido],[b.liquido],[:liquido]} AND $P{[custo],[SUM(b.totalProventos + b.totalPatronal - b.valorSalarioFamiliaDeducao - b.valorSalarioMaternidadeDeducao - b.outrasDeducoes + b.valorFgtsMes + b.valorFgtsAdiantamento13 + b.valorFgtsFechamento13 + b.fgtsLeiComplementar110)],[:custo]} AND $P{[atividade],[t.atividadeCodigo],[:atividade]} AND ";
    private final String nomeLinha;
    private final String nomeColuna;
    private final String nomeMes;
    private final Double valor;

    public RelatorioListagemPlanilhaCustoPlanilhaVo(String nomeLinha, String nomeColuna, String nomeMes, Double valor) {
        this.nomeLinha = nomeLinha;
        this.nomeColuna = nomeColuna;
        this.nomeMes = nomeMes;
        this.valor = valor;
    }

    public String getNomeLinha() {
        return this.nomeLinha;
    }

    public String getNomeColuna() {
        return this.nomeColuna;
    }

    public String getNomeMes() {
        return this.nomeMes;
    }

    public Double getValor() {
        return this.valor;
    }
}

