/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoCargo;
import br.gov.sp.tce.persistence.entity.TipoExercicioAtividadeCargoAudesp;

public class RelatorioDeTrabalhadoresPorCargoVo
implements Comparable<RelatorioDeTrabalhadoresPorCargoVo> {
    private final String cargoCodigo;
    private final String cargoNome;
    private final Short vagasDeCargo;
    private final Short vagasDeComissao;
    private final Short vagasDeEmprego;
    private final Short vagasDeContrato;
    private final String registro;
    private final String trabalhadorNome;
    private final TrabalhadorTipoCargo tipoCargo;

    public RelatorioDeTrabalhadoresPorCargoVo(String cargoCodigo, String cargoNome, Short vagasDeCargo, Short vagasDeComissao, Short vagasDeEmprego, Short vagasDeContrato, String registro, String trabalhadorNome, String tipoCargoCodigo) {
        this.cargoCodigo = cargoCodigo;
        this.cargoNome = cargoNome;
        this.vagasDeCargo = vagasDeCargo;
        this.vagasDeComissao = vagasDeComissao;
        this.vagasDeEmprego = vagasDeEmprego;
        this.vagasDeContrato = vagasDeContrato;
        this.registro = registro;
        this.trabalhadorNome = trabalhadorNome;
        this.tipoCargo = TrabalhadorTipoCargo.of(tipoCargoCodigo);
    }

    public RelatorioDeTrabalhadoresPorCargoVo(String cargoCodigo, String cargoNome, Short vagasDeCargo, Short vagasDeComissao, Short vagasDeEmprego, Short vagasDeContrato, String registro, String trabalhadorNome, TipoExercicioAtividadeCargoAudesp tipoExercicioAtividade) {
        this.cargoCodigo = cargoCodigo;
        this.cargoNome = cargoNome;
        this.vagasDeCargo = vagasDeCargo;
        this.vagasDeComissao = vagasDeComissao;
        this.vagasDeEmprego = vagasDeEmprego;
        this.vagasDeContrato = vagasDeContrato;
        this.registro = registro;
        this.trabalhadorNome = trabalhadorNome;
        this.tipoCargo = this.convertTipoExercicioToTipoCargo(tipoExercicioAtividade);
    }

    private TrabalhadorTipoCargo convertTipoExercicioToTipoCargo(TipoExercicioAtividadeCargoAudesp tipoExercicioAtividade) {
        if (tipoExercicioAtividade == null) {
            return TrabalhadorTipoCargo.NENHUM;
        }
        switch (tipoExercicioAtividade) {
            case EFETIVO: {
                return TrabalhadorTipoCargo.CARGO_EFETIVO;
            }
            case EFETIVO_EM_COMISSAO: {
                return TrabalhadorTipoCargo.COMISSAO_CONFIANCA;
            }
            case TEMPORARIO: {
                return TrabalhadorTipoCargo.CONTRATO_TEMPORARIO;
            }
            case ESTAGIO: {
                return TrabalhadorTipoCargo.EMPREGO_EFETIVO;
            }
            case EXCLUSIVAMENTE_EM_COMISSAO: {
                return TrabalhadorTipoCargo.COMISSAO_CONFIANCA;
            }
            case ESTAVEL: {
                return TrabalhadorTipoCargo.EMPREGO_EFETIVO;
            }
        }
        return TrabalhadorTipoCargo.CARGO_EFETIVO;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public String getCargoNome() {
        return this.cargoNome;
    }

    public Short getVagasDeCargo() {
        return this.vagasDeCargo;
    }

    public Short getVagasDeComissao() {
        return this.vagasDeComissao;
    }

    public Short getVagasDeEmprego() {
        return this.vagasDeEmprego;
    }

    public Short getVagasDeContrato() {
        return this.vagasDeContrato;
    }

    public String getRegistro() {
        return this.registro;
    }

    public String getTrabalhadorNome() {
        return this.trabalhadorNome;
    }

    public TrabalhadorTipoCargo getTipoCargo() {
        return this.tipoCargo;
    }

    @Override
    public int compareTo(RelatorioDeTrabalhadoresPorCargoVo o) {
        return (this.cargoCodigo + this.trabalhadorNome).compareTo(o.cargoCodigo + o.trabalhadorNome);
    }
}

