/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoCargo;
import br.gov.sp.tce.persistence.entity.TipoExercicioAtividadeCargoAudesp;

public class RelatorioDeTrabalhadoresOcupandoMaisDeUmCargoVo {
    private final String cpf;
    private final String registro;
    private final String nomeTrabalhador;
    private final String codigoCargoInicial;
    private final String nomeCargoInicial;
    private final TrabalhadorTipoCargo tipoCargoInicial;
    private final String codigoCargoAtual;
    private final String nomeCargoAtual;
    private final TrabalhadorTipoCargo tipoCargoAtual;

    public RelatorioDeTrabalhadoresOcupandoMaisDeUmCargoVo(String cpf, String registro, String nomeTrabalhador, String codigoCargoInicial, String nomeCargoInicial, String tipoCargoInicial, String codigoCargoAtual, String nomeCargoAtual, TipoExercicioAtividadeCargoAudesp tipoExercicioAtividade) {
        this.cpf = cpf;
        this.registro = registro;
        this.nomeTrabalhador = nomeTrabalhador;
        this.codigoCargoInicial = codigoCargoInicial;
        this.nomeCargoInicial = nomeCargoInicial;
        this.tipoCargoInicial = TrabalhadorTipoCargo.of(tipoCargoInicial);
        this.codigoCargoAtual = codigoCargoAtual;
        this.nomeCargoAtual = nomeCargoAtual;
        this.tipoCargoAtual = this.convertTipoExercicioToTipoCargo(tipoExercicioAtividade);
    }

    private TrabalhadorTipoCargo convertTipoExercicioToTipoCargo(TipoExercicioAtividadeCargoAudesp tipoExercicioAtividade) {
        if (tipoExercicioAtividade == null) {
            return TrabalhadorTipoCargo.NENHUM;
        }
        switch (tipoExercicioAtividade) {
            case EFETIVO: {
                return TrabalhadorTipoCargo.CARGO_EFETIVO;
            }
            case EFETIVO_EM_COMISSAO: {
                return TrabalhadorTipoCargo.COMISSAO_CONFIANCA;
            }
            case TEMPORARIO: {
                return TrabalhadorTipoCargo.CONTRATO_TEMPORARIO;
            }
            case ESTAGIO: {
                return TrabalhadorTipoCargo.EMPREGO_EFETIVO;
            }
            case EXCLUSIVAMENTE_EM_COMISSAO: {
                return TrabalhadorTipoCargo.COMISSAO_CONFIANCA;
            }
            case ESTAVEL: {
                return TrabalhadorTipoCargo.EMPREGO_EFETIVO;
            }
        }
        return TrabalhadorTipoCargo.CARGO_EFETIVO;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getNomeTrabalhador() {
        return this.nomeTrabalhador;
    }

    public String getCodigoCargoInicial() {
        return this.codigoCargoInicial;
    }

    public String getNomeCargoInicial() {
        return this.nomeCargoInicial;
    }

    public TrabalhadorTipoCargo getTipoCargoInicial() {
        return this.tipoCargoInicial;
    }

    public String getCodigoCargoAtual() {
        return this.codigoCargoAtual;
    }

    public String getNomeCargoAtual() {
        return this.nomeCargoAtual;
    }

    public TrabalhadorTipoCargo getTipoCargoAtual() {
        return this.tipoCargoAtual;
    }

    public String getRegistro() {
        return this.registro;
    }
}

