/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Agencia;
import br.com.fiorilli.sip.persistence.entity.Banco;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.CategoriaFuncional;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Salario;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.util.Date;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matricula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Trabalhador.class, id="nomeTrabalhador", label="Nome", inputType=FilterInputType.AUTO_COMPLETE, order=4, query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Date.class, id="dataNascimento", label="Dt. Nascimento", inputType=FilterInputType.CALENDAR, order=5), @FilterConfigParameter(fieldClass=Divisao.class, id="divisaoCodigo", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="divisaoNome", label="Nome Divis\u00e3o", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisaoCodigo", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="subdivisaoNome", label="Nome Subdivis\u00e3o", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculoCodigo", label="V\u00ednculo", inputType=FilterInputType.NUMBER, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="vinculoNome", label="V\u00ednculo Nome", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Unidade.class, id="unidadeNome", label="Nome Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano"), @FilterConfigParameter(fieldClass=String.class, id="departamentoDespesa", label="Unidade", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="cargoCodigo", label="Cargo", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Cargo.class, id="cargoNome", label="Cargo Nome", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=CategoriaFuncional.class, id="categoriaFuncionalCodigo", label="Cat. Funcional", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM CategoriaFuncional c where UPPER(c.nome) LIKE UPPER('%'||:param||'%') AND c.categoriaFuncionalPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalhoCodigo", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="localTrabalhoNome", label="Nome Local de Trabalho", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="proventos", label="Proventos", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="liquido", label="L\u00edquido", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Banco.class, id="codigoBanco", label="Banco", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT b FROM Banco b WHERE (b.nome LIKE :param||'%') OR (b.codigo = :param)"), @FilterConfigParameter(fieldClass=Agencia.class, id="agenciaCodigo", label="Ag\u00eancia", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="contaCodigo", label="Conta", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="tipoConta", label="Tipo Conta", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Salario.class, id="referenciaSalarial", label="C\u00f3d. Ref. Salarial", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Salario s WHERE UPPER(s.nome) LIKE UPPER('%'||:param||'%') AND s.salarioPK.entidade = :entidadeCodigo ORDER BY s.nome"), @FilterConfigParameter(fieldClass=String.class, id="valorSalario", label="Valor. Ref. Salarial", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="nomeSalario", label="Nome. Ref. Salarial", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Banco.class, id="codigoOutroBanco", label="Outro Banco", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT b FROM Banco b WHERE (b.nome LIKE :param||'%') OR (b.codigo = :param)"), @FilterConfigParameter(fieldClass=String.class, id="dataPagamento", label="Data Pagamento", inputType=FilterInputType.CALENDAR)})
public class RelacaoValoresVO {
    public static final String SELECT = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoValoresVO( \nt.matricula, t.contrato, t.nome, d.divisaoPK.codigo, s.subdivisaoPK.codigo, \nb.vinculoCodigo, u.departamentoDespesa, c.cargoPK.codigo, d.nome, s.nome, v.nome, u.nome, c.nome, \n";
    public static final String DADOS_BANCARIOS = " ct.banco.codigo, ct.agenciaCodigo, ct.agenciaDigitoVerificador, \nct.contaCodigo, ct.contaDigitoVerificador, ct.outroBanco.codigo, \n";
    public static final String SEM_DADOS_BANCARIOS = "cast(null as string) AS banco, cast(null as string) AS agencia, \ncast(null as string) AS dvAgencia, cast(null as string) AS conta, \ncast(null as string) AS dvConta, \ncast(null as string) AS outroBanco, \n";
    public static final String FROM = " b.totalProventos, b.totalDescontos, b.liquido) \nFROM Referencia r \nLEFT JOIN r.basesList b \nLEFT JOIN b.trabalhador t \nLEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.vinculo v \nLEFT JOIN b.cargo c \nLEFT JOIN b.unidade u \nLEFT JOIN t.contaList ct \nLEFT JOIN b.salario rs \nLEFT JOIN b.localTrabalho lt \nWHERE r.entidadeCodigo = :entidadeCodigo \nAND r.ano = :ano AND r.mesCodigo = :mes AND r.tipo IN (:tipoReferencia) \nAND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nomeTrabalhador],[t],[:nomeTrabalhador]} AND $P{[dataNascimento],[t.dataNascimento],[:dataNascimento]} AND $P{[divisaoCodigo],[d],[:divisaoCodigo]} AND $P{[divisaoNome],[d.nome],[:divisaoNome]} AND $P{[subdivisaoCodigo],[s],[:subdivisaoCodigo]} AND $P{[subdivisaoNome],[s.nome],[:subdivisaoNome]} AND $P{[vinculoCodigo],[v],[:vinculoCodigo]} AND $P{[vinculoNome],[v.nome],[:vinculoNome]} AND $P{[salario],[s.valor],[:salario]} AND $P{[departamentoDespesa],[u.departamentoDespesa],[:departamentoDespesa]} AND $P{[unidadeNome],[u],[:unidadeNome]} AND $P{[cargoCodigo],[c.cargoPK.codigo],[:cargoCodigo]} AND $P{[cargoNome],[c],[:cargoNome]} AND $P{[localTrabalhoCodigo],[lt],[:localTrabalhoCodigo]} AND $P{[localTrabalhoNome],[lt.nome],[:localTrabalhoNome]} AND $P{[proventos],[b.totalProventos],[:proventos]} AND $P{[liquido],[b.liquido],[:liquido]} AND $P{[codigoBanco],[ct.banco],[:codigoBanco]} AND $P{[agenciaCodigo],[ct.agencia],[:agenciaCodigo]} AND $P{[contaCodigo],[ct.contaCodigo],[:contaCodigo]} AND $P{[tipoConta],[ct.tipo],[:tipoConta]} AND $P{[referenciaSalarial],[rs],[:referenciaSalarial]} AND $P{[valorSalario],[s.valor],[:valorSalario]} AND $P{[nomeSalario],[s.nome],[:nomeSalario]} AND $P{[codigoOutroBanco],[ct.outroBanco],[:codigoOutroBanco]} AND $P{[dataPagamento],[r.dataPagamento],[:dataPagamento]} AND $P{[categoriaFuncionalCodigo],[t.categoriaFuncional],[:categoriaFuncionalCodigo]} ";
    public static final String SELECT_COM_DADOS_BANCARIOS = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoValoresVO( \nt.matricula, t.contrato, t.nome, d.divisaoPK.codigo, s.subdivisaoPK.codigo, \nb.vinculoCodigo, u.departamentoDespesa, c.cargoPK.codigo, d.nome, s.nome, v.nome, u.nome, c.nome, \n ct.banco.codigo, ct.agenciaCodigo, ct.agenciaDigitoVerificador, \nct.contaCodigo, ct.contaDigitoVerificador, ct.outroBanco.codigo, \n b.totalProventos, b.totalDescontos, b.liquido) \nFROM Referencia r \nLEFT JOIN r.basesList b \nLEFT JOIN b.trabalhador t \nLEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.vinculo v \nLEFT JOIN b.cargo c \nLEFT JOIN b.unidade u \nLEFT JOIN t.contaList ct \nLEFT JOIN b.salario rs \nLEFT JOIN b.localTrabalho lt \nWHERE r.entidadeCodigo = :entidadeCodigo \nAND r.ano = :ano AND r.mesCodigo = :mes AND r.tipo IN (:tipoReferencia) \nAND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nomeTrabalhador],[t],[:nomeTrabalhador]} AND $P{[dataNascimento],[t.dataNascimento],[:dataNascimento]} AND $P{[divisaoCodigo],[d],[:divisaoCodigo]} AND $P{[divisaoNome],[d.nome],[:divisaoNome]} AND $P{[subdivisaoCodigo],[s],[:subdivisaoCodigo]} AND $P{[subdivisaoNome],[s.nome],[:subdivisaoNome]} AND $P{[vinculoCodigo],[v],[:vinculoCodigo]} AND $P{[vinculoNome],[v.nome],[:vinculoNome]} AND $P{[salario],[s.valor],[:salario]} AND $P{[departamentoDespesa],[u.departamentoDespesa],[:departamentoDespesa]} AND $P{[unidadeNome],[u],[:unidadeNome]} AND $P{[cargoCodigo],[c.cargoPK.codigo],[:cargoCodigo]} AND $P{[cargoNome],[c],[:cargoNome]} AND $P{[localTrabalhoCodigo],[lt],[:localTrabalhoCodigo]} AND $P{[localTrabalhoNome],[lt.nome],[:localTrabalhoNome]} AND $P{[proventos],[b.totalProventos],[:proventos]} AND $P{[liquido],[b.liquido],[:liquido]} AND $P{[codigoBanco],[ct.banco],[:codigoBanco]} AND $P{[agenciaCodigo],[ct.agencia],[:agenciaCodigo]} AND $P{[contaCodigo],[ct.contaCodigo],[:contaCodigo]} AND $P{[tipoConta],[ct.tipo],[:tipoConta]} AND $P{[referenciaSalarial],[rs],[:referenciaSalarial]} AND $P{[valorSalario],[s.valor],[:valorSalario]} AND $P{[nomeSalario],[s.nome],[:nomeSalario]} AND $P{[codigoOutroBanco],[ct.outroBanco],[:codigoOutroBanco]} AND $P{[dataPagamento],[r.dataPagamento],[:dataPagamento]} AND $P{[categoriaFuncionalCodigo],[t.categoriaFuncional],[:categoriaFuncionalCodigo]} ";
    public static final String SELECT_SEM_DADOS_BANCARIOS = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoValoresVO( \nt.matricula, t.contrato, t.nome, d.divisaoPK.codigo, s.subdivisaoPK.codigo, \nb.vinculoCodigo, u.departamentoDespesa, c.cargoPK.codigo, d.nome, s.nome, v.nome, u.nome, c.nome, \ncast(null as string) AS banco, cast(null as string) AS agencia, \ncast(null as string) AS dvAgencia, cast(null as string) AS conta, \ncast(null as string) AS dvConta, \ncast(null as string) AS outroBanco, \n b.totalProventos, b.totalDescontos, b.liquido) \nFROM Referencia r \nLEFT JOIN r.basesList b \nLEFT JOIN b.trabalhador t \nLEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.vinculo v \nLEFT JOIN b.cargo c \nLEFT JOIN b.unidade u \nLEFT JOIN t.contaList ct \nLEFT JOIN b.salario rs \nLEFT JOIN b.localTrabalho lt \nWHERE r.entidadeCodigo = :entidadeCodigo \nAND r.ano = :ano AND r.mesCodigo = :mes AND r.tipo IN (:tipoReferencia) \nAND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nomeTrabalhador],[t],[:nomeTrabalhador]} AND $P{[dataNascimento],[t.dataNascimento],[:dataNascimento]} AND $P{[divisaoCodigo],[d],[:divisaoCodigo]} AND $P{[divisaoNome],[d.nome],[:divisaoNome]} AND $P{[subdivisaoCodigo],[s],[:subdivisaoCodigo]} AND $P{[subdivisaoNome],[s.nome],[:subdivisaoNome]} AND $P{[vinculoCodigo],[v],[:vinculoCodigo]} AND $P{[vinculoNome],[v.nome],[:vinculoNome]} AND $P{[salario],[s.valor],[:salario]} AND $P{[departamentoDespesa],[u.departamentoDespesa],[:departamentoDespesa]} AND $P{[unidadeNome],[u],[:unidadeNome]} AND $P{[cargoCodigo],[c.cargoPK.codigo],[:cargoCodigo]} AND $P{[cargoNome],[c],[:cargoNome]} AND $P{[localTrabalhoCodigo],[lt],[:localTrabalhoCodigo]} AND $P{[localTrabalhoNome],[lt.nome],[:localTrabalhoNome]} AND $P{[proventos],[b.totalProventos],[:proventos]} AND $P{[liquido],[b.liquido],[:liquido]} AND $P{[codigoBanco],[ct.banco],[:codigoBanco]} AND $P{[agenciaCodigo],[ct.agencia],[:agenciaCodigo]} AND $P{[contaCodigo],[ct.contaCodigo],[:contaCodigo]} AND $P{[tipoConta],[ct.tipo],[:tipoConta]} AND $P{[referenciaSalarial],[rs],[:referenciaSalarial]} AND $P{[valorSalario],[s.valor],[:valorSalario]} AND $P{[nomeSalario],[s.nome],[:nomeSalario]} AND $P{[codigoOutroBanco],[ct.outroBanco],[:codigoOutroBanco]} AND $P{[dataPagamento],[r.dataPagamento],[:dataPagamento]} AND $P{[categoriaFuncionalCodigo],[t.categoriaFuncional],[:categoriaFuncionalCodigo]} ";
    private final Integer matricula;
    private final Short contrato;
    private final String nomeTrabalhador;
    private final String divisaoCodigo;
    private final String subdivisaoCodigo;
    private final String vinculoCodigo;
    private final String departamentoDespesa;
    private final String cargoCodigo;
    private final String divisaoNome;
    private final String subdivisaoNome;
    private final String vinculoNome;
    private final String unidadeNome;
    private final String cargoNome;
    private final String codigoBanco;
    private final String agenciaCodigo;
    private final String agenciaDigitoVerificador;
    private final String contaCodigo;
    private final String contaDigitoVerificador;
    private final String codigoOutroBanco;
    private final Double totalProventos;
    private final Double totalDescontos;
    private final Double liquido;

    public RelacaoValoresVO(Integer matricula, Short contrato, String nomeTrabalhador, String divisaoCodigo, String subdivisaoCodigo, String vinculoCodigo, String departamentoDespesa, String cargoCodigo, String divisaoNome, String subdivisaoNome, String vinculoNome, String unidadeNome, String cargoNome, String codigoBanco, String agenciaCodigo, String agenciaDigitoVerificador, String contaCodigo, String contaDigitoVerificador, String codigoOutroBanco, Double totalProventos, Double totalDescontos, Double liquido) {
        this.matricula = matricula;
        this.contrato = contrato;
        this.nomeTrabalhador = nomeTrabalhador;
        this.divisaoCodigo = divisaoCodigo;
        this.subdivisaoCodigo = subdivisaoCodigo;
        this.vinculoCodigo = vinculoCodigo;
        this.departamentoDespesa = departamentoDespesa;
        this.cargoCodigo = cargoCodigo;
        this.divisaoNome = divisaoNome;
        this.subdivisaoNome = subdivisaoNome;
        this.vinculoNome = vinculoNome;
        this.unidadeNome = unidadeNome;
        this.cargoNome = cargoNome;
        this.codigoBanco = codigoBanco;
        this.agenciaCodigo = agenciaCodigo;
        this.agenciaDigitoVerificador = agenciaDigitoVerificador;
        this.contaCodigo = contaCodigo;
        this.contaDigitoVerificador = contaDigitoVerificador;
        this.codigoOutroBanco = codigoOutroBanco;
        this.totalProventos = totalProventos;
        this.totalDescontos = totalDescontos;
        this.liquido = liquido;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNomeTrabalhador() {
        return this.nomeTrabalhador;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public String getSubdivisaoCodigo() {
        return this.subdivisaoCodigo;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public String getDepartamentoDespesa() {
        return this.departamentoDespesa;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public String getDivisaoNome() {
        return this.divisaoNome;
    }

    public String getSubdivisaoNome() {
        return this.subdivisaoNome;
    }

    public String getVinculoNome() {
        return this.vinculoNome;
    }

    public String getUnidadeNome() {
        return this.unidadeNome;
    }

    public String getCargoNome() {
        return this.cargoNome;
    }

    public String getCodigoBanco() {
        return this.codigoBanco;
    }

    public String getAgenciaCodigo() {
        return this.agenciaCodigo;
    }

    public String getAgenciaDigitoVerificador() {
        return this.agenciaDigitoVerificador;
    }

    public String getContaCodigo() {
        return this.contaCodigo;
    }

    public String getContaDigitoVerificador() {
        return this.contaDigitoVerificador;
    }

    public String getCodigoOutroBanco() {
        return this.codigoOutroBanco;
    }

    public Double getTotalProventos() {
        return this.totalProventos;
    }

    public Double getTotalDescontos() {
        return this.totalDescontos;
    }

    public Double getLiquido() {
        return this.liquido;
    }
}

