/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra.PontoEventoVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class RelacaoSaldoHoraPorEventoVO {
    private String registro;
    private Integer matricula;
    private Short contrato;
    private String nome;
    private List<PontoEventoVO> eventosSoma = new ArrayList<PontoEventoVO>();
    private List<PontoEventoVO> eventosDesconto = new ArrayList<PontoEventoVO>();

    public RelacaoSaldoHoraPorEventoVO(String registro, Integer matricula, Short contrato, String nome) {
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public List<PontoEventoVO> getEventosSoma() {
        return this.eventosSoma;
    }

    public List<PontoEventoVO> getEventosDesconto() {
        return this.eventosDesconto;
    }

    public List<PontoEventoVO> getEventos() {
        ArrayList<PontoEventoVO> eventosVO = new ArrayList<PontoEventoVO>();
        if (!this.eventosSoma.isEmpty()) {
            eventosVO.addAll(this.eventosSoma);
        }
        if (!this.eventosDesconto.isEmpty()) {
            for (PontoEventoVO vo : this.eventosDesconto) {
                vo.setQuantidadeMillis(vo.getQuantidadeMillis() * -1L);
                eventosVO.add(vo);
            }
        }
        Collections.sort(eventosVO, new Comparator<PontoEventoVO>(){

            @Override
            public int compare(PontoEventoVO o1, PontoEventoVO o2) {
                return o1.getData().compareTo(o2.getData());
            }
        });
        return eventosVO;
    }

    public void setEventosSoma(List<PontoEventoVO> eventosSoma) {
        this.eventosSoma = eventosSoma;
    }

    public void setEventosDesconto(List<PontoEventoVO> eventosDesconto) {
        this.eventosDesconto = eventosDesconto;
    }

    public Duration getTotalOfList(List<PontoEventoVO> listaEventos) {
        Duration duration = Duration.ZERO;
        for (PontoEventoVO pontoEvento : listaEventos) {
            duration = duration.plus(pontoEvento.getQuantidadeMillis().longValue());
        }
        return duration;
    }

    public String getSaldo() {
        Duration duration = Duration.ZERO;
        duration = duration.plus((ReadableDuration)this.getTotalOfList(this.eventosSoma));
        duration = duration.minus((ReadableDuration)this.getTotalOfList(this.eventosDesconto));
        return TimeUtils.durationToString((Duration)duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelacaoSaldoHoraPorEventoVO that = (RelacaoSaldoHoraPorEventoVO)o;
        return this.registro.equals(that.registro);
    }

    public int hashCode() {
        return Objects.hash(this.registro);
    }
}

