/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.model.FilterEntity;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.vo.EntidadeMinVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RelacaoSaldoHoraPorEventoParameters {
    private EntidadeMinVo entidade;
    private FilterEntity filter;
    private Date dataLimite = new Date();
    private List<Evento> eventosSoma;
    private List<Evento> eventosDesconto;
    private boolean detalharEventos;
    private boolean ocultarTrabalhadoresSemSaldo;

    public EntidadeMinVo getEntidade() {
        return this.entidade;
    }

    public void setEntidade(EntidadeMinVo entidade) {
        this.entidade = entidade;
    }

    public FilterEntity getFilter() {
        return this.filter;
    }

    public void setFilter(FilterEntity filter) {
        this.filter = filter;
    }

    public Date getDataLimite() {
        return this.dataLimite;
    }

    public void setDataLimite(Date dataLimite) {
        this.dataLimite = dataLimite;
    }

    public List<Evento> getEventosSoma() {
        return this.eventosSoma;
    }

    public void setEventosSoma(List<Evento> eventosSoma) {
        this.eventosSoma = eventosSoma;
    }

    public List<Evento> getEventosDesconto() {
        return this.eventosDesconto;
    }

    public void setEventosDesconto(List<Evento> eventosDesconto) {
        this.eventosDesconto = eventosDesconto;
    }

    public boolean isDetalharEventos() {
        return this.detalharEventos;
    }

    public void setDetalharEventos(boolean detalharEventos) {
        this.detalharEventos = detalharEventos;
    }

    public boolean isOcultarTrabalhadoresSemSaldo() {
        return this.ocultarTrabalhadoresSemSaldo;
    }

    public void setOcultarTrabalhadoresSemSaldo(boolean ocultarTrabalhadoresSemSaldo) {
        this.ocultarTrabalhadoresSemSaldo = ocultarTrabalhadoresSemSaldo;
    }

    private String getFiltroEventos(List<Evento> eventoList) {
        String filtro = "";
        for (Evento evento : eventoList) {
            String mask = eventoList.indexOf(evento) > 0 ? (eventoList.indexOf(evento) == eventoList.size() - 1 ? " e %s" : ", %s") : "%s";
            filtro = filtro + String.format(mask, evento.getEventoPK().getCodigo());
        }
        return filtro;
    }

    public String getFiltroEventos() {
        String filtro = "";
        String filtroEventosSoma = this.getFiltroEventosSoma();
        String filtroEventosDesconto = this.getFiltroEventosDesconto();
        if (!filtroEventosSoma.equals("")) {
            filtro = filtro.concat(String.format("Eventos para Soma (%s)", filtroEventosSoma));
        }
        if (!filtroEventosDesconto.equals("")) {
            filtro = filtro.concat((!filtro.equals("") ? "; " : "") + String.format("Eventos para Desconto (%s)", filtroEventosDesconto));
        }
        return filtro;
    }

    private String getFiltroEventosSoma() {
        String filtroSoma = this.getFiltroEventos(this.eventosSoma);
        return !filtroSoma.equals("") ? filtroSoma : "";
    }

    private String getFiltroEventosDesconto() {
        String filtroDesconto = this.getFiltroEventos(this.eventosDesconto);
        return !filtroDesconto.equals("") ? filtroDesconto : "";
    }

    public List<Evento> getEventosFalta() {
        ArrayList<Evento> eventosFalta = new ArrayList<Evento>();
        if (!this.eventosDesconto.isEmpty()) {
            for (Evento evento : this.eventosDesconto) {
                if (!evento.isFalta()) continue;
                if (this.entidade.isMarau()) {
                    if (!evento.getEventoPK().getCodigo().equals("717")) continue;
                    eventosFalta.add(evento);
                    continue;
                }
                eventosFalta.add(evento);
            }
        }
        return eventosFalta;
    }
}

