/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.CargoNatureza;
import java.util.Date;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="cargoCodigo", label="Cargo", inputType=FilterInputType.NUMBER, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome", condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=String.class, id="nomeCargo", label="Nome Cargo", condition=FilterCondition.COMECE, inputType=FilterInputType.TEXT), @FilterConfigParameter(fieldClass=String.class, id="refSalarial", label="Ref. Salarial", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=String.class, id="nomeRefSalarial", label="Nome Ref. Salarial", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE), @FilterConfigParameter(fieldClass=Double.class, id="valor", label="Valor Sal\u00e1rio", condition=FilterCondition.IGUAL, inputType=FilterInputType.DECIMAL), @FilterConfigParameter(fieldClass=String.class, id="cbo", label="C.B.O", condition=FilterCondition.IGUAL, inputType=FilterInputType.TEXT), @FilterConfigParameter(fieldClass=Short.class, id="vagaCargo", label="Vagas Cargo", inputType=FilterInputType.DECIMAL, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=Short.class, id="vagaFuncao", label="Vagas Fun\u00e7\u00e3o", inputType=FilterInputType.DECIMAL, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=Short.class, id="vagaEmprego", label="Vagas Emprego", inputType=FilterInputType.DECIMAL, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=Boolean.class, id="mudaRefSal", label="Muda Ref. Sal. [S/N]", inputType=FilterInputType.BOOLEAN_RADIO, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=Double.class, id="mudaRefSalAnos", label="Muda Ref. Sal. [Anos]", inputType=FilterInputType.DECIMAL, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=Date.class, id="dtCriacao", label="Dt. Cria\u00e7\u00e3o", inputType=FilterInputType.CALENDAR, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=Integer.class, id="tipoLegalCriacao", label="Tipo Legal Cria\u00e7\u00e3o", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=String.class, id="numDocCriacao", label="Num. Doc. Cria\u00e7\u00e3o", condition=FilterCondition.IGUAL, inputType=FilterInputType.TEXT), @FilterConfigParameter(fieldClass=Integer.class, id="conselhoRegional", label="Conselho Regional", condition=FilterCondition.IGUAL, inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Date.class, id="dtExtincao", label="Dt. Extin\u00e7\u00e3o", condition=FilterCondition.IGUAL, inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Integer.class, id="tipoLegalExtincao", label="Tipo Legal Extin\u00e7\u00e3o", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=String.class, id="numeroDocumentoExtincao", label="Num. Doc. Extin\u00e7\u00e3o", condition=FilterCondition.IGUAL, inputType=FilterInputType.TEXT), @FilterConfigParameter(fieldClass=Double.class, id="horasMes", label="Horas/M\u00eas", condition=FilterCondition.IGUAL, inputType=FilterInputType.DECIMAL), @FilterConfigParameter(fieldClass=Double.class, id="horasSemana", label="Horas/Semana", condition=FilterCondition.IGUAL, inputType=FilterInputType.DECIMAL), @FilterConfigParameter(fieldClass=Double.class, id="diasSemana", label="Dias/Semana", condition=FilterCondition.IGUAL, inputType=FilterInputType.DECIMAL), @FilterConfigParameter(fieldClass=Double.class, id="horasEfetivas", label="Horas/Efetivas", condition=FilterCondition.IGUAL, inputType=FilterInputType.DECIMAL), @FilterConfigParameter(fieldClass=String.class, id="natureza", label="Natureza", inputType=FilterInputType.SELECT_ONE_MENU, enumClass=CargoNatureza.class, enumId="codigo", enumLabel="descricao"), @FilterConfigParameter(fieldClass=String.class, id="vinculoNome", label="V\u00ednculo Nome", condition=FilterCondition.COMECE, inputType=FilterInputType.TEXT), @FilterConfigParameter(fieldClass=String.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL)})
public class RelacaoSalariosCargoVo {
    public static final String QUERY_1 = "SELECT DISTINCT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoSalariosCargoVo( \nb.cargoCodigo, c.nome, s.nome as nomeRefSalarial, b.referenciaSalarial as refSalarial, b.valorsalario as valor) \nFROM Referencia r \n LEFT JOIN r.basesList b \nLEFT JOIN b.cargo c \nLEFT JOIN b.salario s \nLEFT JOIN b.vinculo v \nWHERE r.entidadeCodigo = :entidadeCodigo \nAND r.ano = :ano \nAND r.mesCodigo = :mes AND r.tipo IN ('1', '7') AND \n$P{[cargoCodigo],[b.cargoCodigo],[:cargoCodigo]} AND $P{[nomeCargo],[c.nome],[:nomeCargo]} AND $P{[refSalarial],[b.referenciaSalarial],[:refSalarial]} AND $P{[nomeRefSalarial],[s.nome],[:nomeRefSalarial]} AND $P{[valor],[b.valorsalario],[:valor]} AND $P{[cbo],[b.cbo],[:cbo]} AND $P{[vagaCargo],[c.vagaCargo],[:vagaCargo]} AND $P{[vagaFuncao],[c.vagaFuncao],[:vagaFuncao]} AND $P{[vagaEmprego],[c.vagaEmprego],[:vagaEmprego]} AND $P{[mudaRefSal],[c.mudarSalarioAutomaticamente],[:mudaRefSal]} AND $P{[mudaRefSalAnos],[c.tempoAnos],[:mudaRefSalAnos]} AND $P{[dtCriacao],[c.criacao.data],[:dtCriacao]} AND $P{[tipoLegalCriacao],[c.criacao.tipoLegalCodigo],[:tipoLegalCriacao]} AND $P{[numDocCriacao],[c.cricao.numeroDocumento],[:numDocCriacao]} AND $P{[conselhoRegional],[c.conselhoRegionalCodigo],[:conselhoRegional]} AND $P{[dtExtincao],[c.extincao.data],[:dtExtincao]} AND $P{[tipoLegalCodigo],[c.extincao.tipoLegalCodigo],[:tipoLegalCodigo]} AND $P{[numeroDocumentoExtincao],[c.extincao.numeroDocumento],[:numeroDocumentoExtincao]} AND $P{[horasMes],[c.horasMes],[:horasMes]} AND $P{[horasSemana],[c.horasSemana],[:horasSemana]} AND $P{[diasSemana],[c.diasSemana],[:diasSemana]} AND $P{[horasEfetivas],[c.horasEfetivas],[:horasEfetivas]} AND $P{[natureza],[c.natureza],[:natureza]} AND $P{[vinculo],[b.vinculoCodigo],[:vinculo]} AND $P{[vinculoNome],[v.nome],[:vinculoNome]}  ORDER BY c.nome";
    public static final String QUERY_2 = "SELECT DISTINCT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoSalariosCargoVo( \nc.codigo, c.nome, s.nome as nomeRefSalarial, s.salarioPK.codigo as refSalarial, s.valor) \nFROM PlanoCargo pc \nINNER JOIN pc.planoCargosCargoList pcc \nINNER JOIN pcc.cargo c \nINNER JOIN pcc.cargoSalarioList cs \nINNER JOIN cs.salario s \nWHERE pc.entidadeCodigo = :entidadeCodigo AND pc.ativo = 'S' AND \n$P{[cargoCodigo],[b.cargoCodigo],[:cargoCodigo]} AND $P{[nomeCargo],[c.nome],[:nomeCargo]} AND $P{[refSalarial],[b.salario],[:refSalarial]} AND $P{[nomeRefSalarial],[s],[:nomeRefSalarial]} AND $P{[valor],[b.valorsalario],[:valor]} AND $P{[cbo],[b.cbo],[:cbo]} AND $P{[vagaCargo],[c.vagaCargo],[:vagaCargo]} AND $P{[vagaFuncao],[c.vagaFuncao],[:vagaFuncao]} AND $P{[vagaEmprego],[c.vagaEmprego],[:vagaEmprego]} AND $P{[mudaRefSal],[c.mudarSalarioAutomaticamente],[:mudaRefSal]} AND $P{[mudaRefSalAnos],[c.tempoAnos],[:mudaRefSalAnos]} AND $P{[dtCriacao],[c.criacao.data],[:dtCriacao]} AND $P{[tipoLegalCriacao],[c.criacao.tipoLegalCodigo],[:tipoLegalCriacao]} AND $P{[numDocCriacao],[c.cricao.numeroDocumento],[:numDocCriacao]} AND $P{[conselhoRegional],[c.conselhoRegionalCodigo],[:conselhoRegional]} AND $P{[dtExtincao],[c.extincao.data],[:dtExtincao]} AND $P{[tipoLegalCodigo],[c.extincao.tipoLegalCodigo],[:tipoLegalCodigo]} AND $P{[numeroDocumentoExtincao],[c.extincao.numeroDocumento],[:numeroDocumentoExtincao]} AND $P{[horasMes],[c.horasMes],[:horasMes]} AND $P{[horasSemana],[c.horasSemana],[:horasSemana]} AND $P{[diasSemana],[c.diasSemana],[:diasSemana]} AND $P{[horasEfetivas],[c.horasEfetivas],[:horasEfetivas]} AND $P{[natureza],[c.natureza],[:natureza]} AND $P{[vinculo],[b.vinculoCodigo],[:vinculo]} AND $P{[vinculoNome],[v.nome],[:vinculoNome]}  ORDER BY c.nome";
    private final String cargoCodigo;
    private final String cargoNome;
    private final String nomeRefSalarial;
    private final String refSalarial;
    private final Double valor;

    public RelacaoSalariosCargoVo(String cargoCodigo, String cargoNome, String nomeRefSalarial, String refSalarial, Double valor) {
        this.cargoCodigo = cargoCodigo;
        this.cargoNome = cargoNome;
        this.nomeRefSalarial = nomeRefSalarial;
        this.refSalarial = refSalarial;
        this.valor = valor;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public String getCargoNome() {
        return this.cargoNome;
    }

    public String getNomeRefSalarial() {
        return this.nomeRefSalarial;
    }

    public String getRefSalarial() {
        return this.refSalarial;
    }

    public Double getValor() {
        return this.valor;
    }
}

