/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.CategoriaFuncional;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.DivisaoPK;
import br.com.fiorilli.sip.persistence.entity.GrupoPonto;
import br.com.fiorilli.sip.persistence.entity.GrupoPontoPK;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaSemana;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Salario;
import br.com.fiorilli.sip.persistence.entity.Sexo;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TipoPonto;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorSituacao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoCargo;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import br.com.fiorilli.sip.persistence.entity.VinculoRais;
import java.math.BigDecimal;
import java.util.Date;

@FilterConfigType(query="FROM Trabalhador t LEFT JOIN t.jornada j LEFT JOIN j.jornadasDias jd LEFT JOIN t.cargoInicial ciLEFT JOIN t.cargoAtual ca LEFT JOIN t.salarioInicial si LEFT JOIN t.salarioAtual sa LEFT JOIN t.vinculo v LEFT JOIN t.divisao d LEFT JOIN t.subdivisao s LEFT JOIN t.localTrabalho l LEFT JOIN t.categoriaFuncional cf LEFT JOIN t.unidade u WHERE t.jornadaCodigo IS NOT NULL AND t.trabalhadorPK.entidade = :entidadeCodigo AND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[jornada],[t.jornada],[:jornada]} AND $P{[cargoInicial],[t.cargoInicial],[:cargoInicial]} AND $P{[cargoAtual],[t.cargoAtual],[:cargoAtual]} AND $P{[salarioAtual],[t.salarioAtual],[:salarioAtual]} AND $P{[salarioInicial],[t.salarioInicial],[:salarioInicial]} AND $P{[vinculo],[t.vinculo],[:vinculo]} AND $P{[sexo],[t.dadosPessoais.caracteristicasFisicas.sexo],[:sexo]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[tipoCargoAtual],[t.tipoCargoAtual],[:tipoCargoAtual]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[numeroCartao],[t.ponto.numeroCartao],[:numeroCartao]} AND $P{[numeroChapeira],[t.ponto.numeroChapeira],[:numeroChapeira]} AND $P{[horasMes],[t.horasMes],[:horasMes]} AND $P{[horasSemana],[t.horasSemanal],[:horasSemana]} AND $P{[divisao],[t.divisao],[:divisao]} AND $P{[subdivisao],[t.subdivisao],[:subdivisao]} AND $P{[dataTermino],[t.dataTermino],[:dataTermino]} AND $P{[localTrabalho],[t.localTrabalho],[:localTrabalho]} AND $P{[tipoPonto],[t.ponto.tipo],[:tipoPonto]} AND $P{[categoriaFuncional],[t.categoriaFuncional],[t.categoriaFuncional]} AND $P{[unidade],[t.unidade],[:unidade]} AND $P{[vinculoRais],[t.vinculo.vinculoRais],[:vinculoRais]} AND $P{[numeroConcurso],[t.concurso.numeroConcurso],[:numeroConcurso]} AND $P{[grupoPonto],[t.grupoPonto],[:grupoPonto]} AND $P{[nome],[t.nome],[:nome]} AND $P{[pis],[t.documentosPessoais.pis],[:pis]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[dataDemissao],[t.dataDemissao],[:dataDemissao]} AND $P{[divisoesPerfil], [t.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[gruposPontoPerfil], [t.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ", displayField=9)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=2), @FilterConfigParameter(fieldClass=String.class, id="pis", label="PIS", inputType=FilterInputType.TEXT, order=7), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))", order=6), @FilterConfigParameter(fieldClass=Cargo.class, id="cargoInicial", label="Cargo Inicial", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Salario.class, id="salarioInicial", label="Ref. Sal. Inicial", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Salario s WHERE UPPER(s.nome) LIKE UPPER('%'||:param||'%') AND s.salarioPK.entidade = :entidadeCodigo ORDER BY s.nome"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargoAtual", label="Cargo Atual", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Salario.class, id="salarioAtual", label="Ref. Sal. Atual", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Salario s WHERE UPPER(s.nome) LIKE UPPER('%'||:param||'%') AND s.salarioPK.entidade = :entidadeCodigo ORDER BY s.nome"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo", order=8), @FilterConfigParameter(fieldClass=Sexo.class, id="sexo", label="Sexo", enumClass=Sexo.class, enumLabel="label", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=TrabalhadorSituacao.class, id="situacao", label="Situa\u00e7\u00e3o", enumClass=TrabalhadorSituacao.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Ref. Sal. Atual", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=TrabalhadorTipoCargo.class, id="tipoCargoAtual", label="Tipo Cargo Atual", enumClass=TrabalhadorTipoCargo.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasSemana", label="Horas Semana", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasMes", label="Horas M\u00eas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="numeroCartao", label="N\u00fam. Cart\u00e3o Ponto"), @FilterConfigParameter(fieldClass=String.class, id="numeroChapeira", label="N\u00fam. Chapeira Ponto"), @FilterConfigParameter(fieldClass=Date.class, id="dataDemissao", label="Dt. Desligamento", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo", order=5), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo", order=4), @FilterConfigParameter(fieldClass=TipoPonto.class, id="tipoPonto", label="Tipo Ponto", enumClass=TipoPonto.class, enumId="id", enumLabel="label", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=Date.class, id="dataTermino", label="Dt. T\u00e9rmino Contrato", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=CategoriaFuncional.class, id="categoriaFuncional", label="Cat. Funcional", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM CategoriaFuncional c where UPPER(c.nome) LIKE UPPER('%'||:param||'%') AND c.categoriaFuncionalPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano"), @FilterConfigParameter(fieldClass=VinculoRais.class, id="vinculoRais", label="V\u00ednculo RAIS", enumClass=VinculoRais.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=String.class, id="numeroConcurso", label="N\u00famero Concurso"), @FilterConfigParameter(fieldClass=GrupoPonto.class, id="grupoPonto", label="Grupo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT g FROM GrupoPonto g where g.grupoPontoPK.entidade = :entidadeCodigo AND concat(g.grupoPontoPK.codigo, g.nome) LIKE concat('%', :param, '%') ", order=9), @FilterConfigParameter(fieldClass=DivisaoPK.class, id="divisoesPerfil", label="Divis\u00f5es Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true), @FilterConfigParameter(fieldClass=GrupoPontoPK.class, id="gruposPontoPerfil", label="Grupo Ponto Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true)})
public class RelacaoJornadasTrabalhadorVo {
    public static final String FROM_WHERE = "FROM Trabalhador t LEFT JOIN t.jornada j LEFT JOIN j.jornadasDias jd LEFT JOIN t.cargoInicial ciLEFT JOIN t.cargoAtual ca LEFT JOIN t.salarioInicial si LEFT JOIN t.salarioAtual sa LEFT JOIN t.vinculo v LEFT JOIN t.divisao d LEFT JOIN t.subdivisao s LEFT JOIN t.localTrabalho l LEFT JOIN t.categoriaFuncional cf LEFT JOIN t.unidade u WHERE t.jornadaCodigo IS NOT NULL AND t.trabalhadorPK.entidade = :entidadeCodigo AND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[jornada],[t.jornada],[:jornada]} AND $P{[cargoInicial],[t.cargoInicial],[:cargoInicial]} AND $P{[cargoAtual],[t.cargoAtual],[:cargoAtual]} AND $P{[salarioAtual],[t.salarioAtual],[:salarioAtual]} AND $P{[salarioInicial],[t.salarioInicial],[:salarioInicial]} AND $P{[vinculo],[t.vinculo],[:vinculo]} AND $P{[sexo],[t.dadosPessoais.caracteristicasFisicas.sexo],[:sexo]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[tipoCargoAtual],[t.tipoCargoAtual],[:tipoCargoAtual]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[numeroCartao],[t.ponto.numeroCartao],[:numeroCartao]} AND $P{[numeroChapeira],[t.ponto.numeroChapeira],[:numeroChapeira]} AND $P{[horasMes],[t.horasMes],[:horasMes]} AND $P{[horasSemana],[t.horasSemanal],[:horasSemana]} AND $P{[divisao],[t.divisao],[:divisao]} AND $P{[subdivisao],[t.subdivisao],[:subdivisao]} AND $P{[dataTermino],[t.dataTermino],[:dataTermino]} AND $P{[localTrabalho],[t.localTrabalho],[:localTrabalho]} AND $P{[tipoPonto],[t.ponto.tipo],[:tipoPonto]} AND $P{[categoriaFuncional],[t.categoriaFuncional],[t.categoriaFuncional]} AND $P{[unidade],[t.unidade],[:unidade]} AND $P{[vinculoRais],[t.vinculo.vinculoRais],[:vinculoRais]} AND $P{[numeroConcurso],[t.concurso.numeroConcurso],[:numeroConcurso]} AND $P{[grupoPonto],[t.grupoPonto],[:grupoPonto]} AND $P{[nome],[t.nome],[:nome]} AND $P{[pis],[t.documentosPessoais.pis],[:pis]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[dataDemissao],[t.dataDemissao],[:dataDemissao]} AND $P{[divisoesPerfil], [t.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[gruposPontoPerfil], [t.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ";
    public static final String GROUP_BY_JORNADA = "SELECT DISTINCT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoJornadasTrabalhadorVo(j.jornadaPK.codigo, j.nome, t.matricula, t.contrato, t.nome, ca.nome, l.nome, t.horasMes) FROM Trabalhador t LEFT JOIN t.jornada j LEFT JOIN j.jornadasDias jd LEFT JOIN t.cargoInicial ciLEFT JOIN t.cargoAtual ca LEFT JOIN t.salarioInicial si LEFT JOIN t.salarioAtual sa LEFT JOIN t.vinculo v LEFT JOIN t.divisao d LEFT JOIN t.subdivisao s LEFT JOIN t.localTrabalho l LEFT JOIN t.categoriaFuncional cf LEFT JOIN t.unidade u WHERE t.jornadaCodigo IS NOT NULL AND t.trabalhadorPK.entidade = :entidadeCodigo AND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[jornada],[t.jornada],[:jornada]} AND $P{[cargoInicial],[t.cargoInicial],[:cargoInicial]} AND $P{[cargoAtual],[t.cargoAtual],[:cargoAtual]} AND $P{[salarioAtual],[t.salarioAtual],[:salarioAtual]} AND $P{[salarioInicial],[t.salarioInicial],[:salarioInicial]} AND $P{[vinculo],[t.vinculo],[:vinculo]} AND $P{[sexo],[t.dadosPessoais.caracteristicasFisicas.sexo],[:sexo]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[tipoCargoAtual],[t.tipoCargoAtual],[:tipoCargoAtual]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[numeroCartao],[t.ponto.numeroCartao],[:numeroCartao]} AND $P{[numeroChapeira],[t.ponto.numeroChapeira],[:numeroChapeira]} AND $P{[horasMes],[t.horasMes],[:horasMes]} AND $P{[horasSemana],[t.horasSemanal],[:horasSemana]} AND $P{[divisao],[t.divisao],[:divisao]} AND $P{[subdivisao],[t.subdivisao],[:subdivisao]} AND $P{[dataTermino],[t.dataTermino],[:dataTermino]} AND $P{[localTrabalho],[t.localTrabalho],[:localTrabalho]} AND $P{[tipoPonto],[t.ponto.tipo],[:tipoPonto]} AND $P{[categoriaFuncional],[t.categoriaFuncional],[t.categoriaFuncional]} AND $P{[unidade],[t.unidade],[:unidade]} AND $P{[vinculoRais],[t.vinculo.vinculoRais],[:vinculoRais]} AND $P{[numeroConcurso],[t.concurso.numeroConcurso],[:numeroConcurso]} AND $P{[grupoPonto],[t.grupoPonto],[:grupoPonto]} AND $P{[nome],[t.nome],[:nome]} AND $P{[pis],[t.documentosPessoais.pis],[:pis]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[dataDemissao],[t.dataDemissao],[:dataDemissao]} AND $P{[divisoesPerfil], [t.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[gruposPontoPerfil], [t.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ORDER BY j.nome, t.nome";
    public static final String GROUP_BY_TRABALHADOR = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoJornadasTrabalhadorVo(j.jornadaPK.codigo, j.nome, t.matricula, t.contrato, t.nome, ca.nome, l.nome, t.horasMes, jd.nome, jd.jornadaDiaPK.dia, jd.entrada1, jd.saida1, jd.entrada2, jd.saida2, jd.horasNormais) FROM Trabalhador t LEFT JOIN t.jornada j LEFT JOIN j.jornadasDias jd LEFT JOIN t.cargoInicial ciLEFT JOIN t.cargoAtual ca LEFT JOIN t.salarioInicial si LEFT JOIN t.salarioAtual sa LEFT JOIN t.vinculo v LEFT JOIN t.divisao d LEFT JOIN t.subdivisao s LEFT JOIN t.localTrabalho l LEFT JOIN t.categoriaFuncional cf LEFT JOIN t.unidade u WHERE t.jornadaCodigo IS NOT NULL AND t.trabalhadorPK.entidade = :entidadeCodigo AND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[jornada],[t.jornada],[:jornada]} AND $P{[cargoInicial],[t.cargoInicial],[:cargoInicial]} AND $P{[cargoAtual],[t.cargoAtual],[:cargoAtual]} AND $P{[salarioAtual],[t.salarioAtual],[:salarioAtual]} AND $P{[salarioInicial],[t.salarioInicial],[:salarioInicial]} AND $P{[vinculo],[t.vinculo],[:vinculo]} AND $P{[sexo],[t.dadosPessoais.caracteristicasFisicas.sexo],[:sexo]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[tipoCargoAtual],[t.tipoCargoAtual],[:tipoCargoAtual]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[numeroCartao],[t.ponto.numeroCartao],[:numeroCartao]} AND $P{[numeroChapeira],[t.ponto.numeroChapeira],[:numeroChapeira]} AND $P{[horasMes],[t.horasMes],[:horasMes]} AND $P{[horasSemana],[t.horasSemanal],[:horasSemana]} AND $P{[divisao],[t.divisao],[:divisao]} AND $P{[subdivisao],[t.subdivisao],[:subdivisao]} AND $P{[dataTermino],[t.dataTermino],[:dataTermino]} AND $P{[localTrabalho],[t.localTrabalho],[:localTrabalho]} AND $P{[tipoPonto],[t.ponto.tipo],[:tipoPonto]} AND $P{[categoriaFuncional],[t.categoriaFuncional],[t.categoriaFuncional]} AND $P{[unidade],[t.unidade],[:unidade]} AND $P{[vinculoRais],[t.vinculo.vinculoRais],[:vinculoRais]} AND $P{[numeroConcurso],[t.concurso.numeroConcurso],[:numeroConcurso]} AND $P{[grupoPonto],[t.grupoPonto],[:grupoPonto]} AND $P{[nome],[t.nome],[:nome]} AND $P{[pis],[t.documentosPessoais.pis],[:pis]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[dataDemissao],[t.dataDemissao],[:dataDemissao]} AND $P{[divisoesPerfil], [t.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[gruposPontoPerfil], [t.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ORDER BY t.matricula, jd.jornadaDiaPK.dia";
    private Short jornadaCodigo;
    private String jornadaNome;
    private Integer matricula;
    private Short contrato;
    private String trabalhadorNome;
    private String cargoAtualNome;
    private String localTrabalhoNome;
    private Double horasMes;
    private String jornadaDiaNome;
    private String jornadaDiaSemana;
    private String entrada1;
    private String saida1;
    private String entrada2;
    private String saida2;
    private String horasNormais;

    public RelacaoJornadasTrabalhadorVo() {
    }

    public RelacaoJornadasTrabalhadorVo(Short jornadaCodigo, String jornadaNome, Integer matricula, Short contrato, String trabalhadorNome, String cargoAtualNome, String localTrabalhoNome, BigDecimal horasMes, String jornadaDiaNome, Integer jornadaDiaSemana, String entrada1, String saida1, String entrada2, String saida2, String horasNormais) {
        this.jornadaCodigo = jornadaCodigo;
        this.jornadaNome = jornadaNome;
        this.matricula = matricula;
        this.contrato = contrato;
        this.trabalhadorNome = trabalhadorNome;
        this.cargoAtualNome = cargoAtualNome;
        this.localTrabalhoNome = localTrabalhoNome;
        this.horasMes = horasMes.doubleValue();
        this.jornadaDiaSemana = JornadaDiaSemana.get(jornadaDiaSemana).getNome();
        this.jornadaDiaNome = jornadaDiaNome;
        this.entrada1 = entrada1;
        this.saida1 = saida1;
        this.entrada2 = entrada2;
        this.saida2 = saida2;
        this.horasNormais = horasNormais;
    }

    public RelacaoJornadasTrabalhadorVo(Short jornadaCodigo, String jornadaNome, Integer matricula, Short contrato, String trabalhadorNome, String cargoAtualNome, String localTrabalhoNome, BigDecimal horasMes) {
        this.jornadaCodigo = jornadaCodigo;
        this.jornadaNome = jornadaNome;
        this.matricula = matricula;
        this.contrato = contrato;
        this.trabalhadorNome = trabalhadorNome;
        this.cargoAtualNome = cargoAtualNome;
        this.localTrabalhoNome = localTrabalhoNome;
        this.horasMes = horasMes.doubleValue();
    }

    public String getJornadaNome() {
        return this.jornadaNome;
    }

    public String getTrabalhadorNome() {
        return this.trabalhadorNome;
    }

    public String getCargoAtualNome() {
        return this.cargoAtualNome;
    }

    public String getLocalTrabalhoNome() {
        return this.localTrabalhoNome;
    }

    public Double getHorasMes() {
        return this.horasMes;
    }

    public String getJornadaDiaNome() {
        return this.jornadaDiaNome;
    }

    public String getHorasNormais() {
        return this.horasNormais;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getEntrada1() {
        return this.entrada1;
    }

    public String getSaida1() {
        return this.saida1;
    }

    public String getJornadaDiaSemana() {
        return this.jornadaDiaSemana;
    }

    public String getEntrada2() {
        return this.entrada2;
    }

    public String getSaida2() {
        return this.saida2;
    }

    public String toString() {
        return "RelacaoJornadasTrabalhadorVo [matricula=" + this.matricula + ", contrato=" + this.contrato + ", jornadaCodigo=" + this.jornadaCodigo + ", jornadaNome=" + this.jornadaNome + ", trabalhadorNome=" + this.trabalhadorNome + ", cargoAtualNome=" + this.cargoAtualNome + ", localTrabalhoNome=" + this.localTrabalhoNome + ", horasMes=" + this.horasMes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cargoAtualNome == null ? 0 : this.cargoAtualNome.hashCode());
        result = 31 * result + (this.contrato == null ? 0 : this.contrato.hashCode());
        result = 31 * result + (this.jornadaCodigo == null ? 0 : this.jornadaCodigo.hashCode());
        result = 31 * result + (this.localTrabalhoNome == null ? 0 : this.localTrabalhoNome.hashCode());
        result = 31 * result + (this.matricula == null ? 0 : this.matricula.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelacaoJornadasTrabalhadorVo other = (RelacaoJornadasTrabalhadorVo)obj;
        if (this.cargoAtualNome == null ? other.cargoAtualNome != null : !this.cargoAtualNome.equals(other.cargoAtualNome)) {
            return false;
        }
        if (this.contrato == null ? other.contrato != null : !this.contrato.equals(other.contrato)) {
            return false;
        }
        if (this.jornadaCodigo == null ? other.jornadaCodigo != null : !this.jornadaCodigo.equals(other.jornadaCodigo)) {
            return false;
        }
        if (this.localTrabalhoNome == null ? other.localTrabalhoNome != null : !this.localTrabalhoNome.equals(other.localTrabalhoNome)) {
            return false;
        }
        return !(this.matricula == null ? other.matricula != null : !this.matricula.equals(other.matricula));
    }
}

