/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorSituacao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.math.BigDecimal;
import java.util.Date;
import org.joda.time.Duration;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Date.class, id="data", label="Data", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=TrabalhadorSituacao.class, id="situacao", label="Situa\u00e7\u00e3o", enumClass=TrabalhadorSituacao.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU, order=4), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="Vinculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Trabalhador.class, id="nome", label="Nome Trabalhador", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo", order=3), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo", order=5), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasSemanal", label="Horas Semanal", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasMes", label="Horas M\u00eas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Sal\u00e1rio", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano")})
public class RelacaoHorasTrabalhadaSemanaVo {
    public static final String QUERY = "SELECT DISTINCT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoHorasTrabalhadaSemanaVo(t.matricula, t.contrato, t.nome, c.nome, p.data, p.horasTrabalhadas as Horas, d.nome, s.nome, u.nome, l.nome) FROM Ponto p JOIN p.trabalhador t LEFT JOIN t.cargoAtual c LEFT JOIN t.vinculo v LEFT JOIN t.divisao d LEFT JOIN t.subdivisao s LEFT JOIN t.unidade u LEFT JOIN t.localTrabalho l LEFT JOIN p.jornada j LEFT JOIN j.jornadasDias jd WHERE p.entidadeCodigo = :entidadeCodigo AND p.data BETWEEN :dataInicio AND :dataFim AND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[nome],[t],[:nome]} AND $P{[vinculo],[v],[:vinculo]} AND $P{[divisao],[d],[:divisao]} AND $P{[cargo],[c],[:cargo]} AND $P{[subdivisao],[s],[:subdivisao]} AND $P{[horasSemanal],[t.horasSemanal],[:horasSemanal]} AND $P{[horasMes],[t.horasMes],[:horasMes]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[unidade],[u],[:unidade]} AND $P{[localTrabalho],[l],[:localTrabalho]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[data], [p.data], [:data]} ";
    private final Integer matricula;
    private final Short contrato;
    private final String nome;
    private final String cargo;
    private final Date data;
    private final Duration horasTrabalhada;
    private final String divisao;
    private final String subdivisao;
    private final String unidade;
    private final String localTrabalho;
    private Double totalHorasTrabalhada;

    public RelacaoHorasTrabalhadaSemanaVo(Integer matricula, Short contrato, String nome, String cargo, Date data, Duration horasTrabalhada, String divisao, String subdivisao, String unidade, String localTrabalho) {
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.cargo = cargo;
        this.data = data;
        this.horasTrabalhada = horasTrabalhada;
        this.divisao = divisao;
        this.subdivisao = subdivisao;
        this.unidade = unidade;
        this.localTrabalho = localTrabalho;
    }

    public String getDivisao() {
        return this.divisao;
    }

    public String getSubdivisao() {
        return this.subdivisao;
    }

    public String getUnidade() {
        return this.unidade;
    }

    public String getLocalTrabalho() {
        return this.localTrabalho;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public String getCargo() {
        return this.cargo;
    }

    public Date getData() {
        return this.data;
    }

    public Duration getHorasTrabalhada() {
        return this.horasTrabalhada;
    }

    public void setTotalHorasTrabalhada(Double totalHorasTrabalhada) {
        this.totalHorasTrabalhada = totalHorasTrabalhada;
    }

    public Double getTotalHorasTrabalhada() {
        return this.totalHorasTrabalhada;
    }
}

