/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.model.FilterEntity;
import br.com.fiorilli.sip.persistence.entity.EventoClassificacao;
import br.com.fiorilli.sip.persistence.enums.StatusEventosPonto;
import br.com.fiorilli.sip.persistence.vo.EntidadeMinVo;
import br.com.fiorilli.sip.persistence.vo.reports.ReportOptions;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class RelacaoHorasExtrasFaltasParameters {
    private FilterEntity filterEntity;
    private ReportOptions[] groupBy;
    private ReportOptions[] newPageOn;
    private ReportOptions orderBy = ReportOptions.REGISTRO;
    private EntidadeMinVo entidade;
    private EventoClassificacao[] eventoClassificacao = new EventoClassificacao[]{EventoClassificacao.HORA_EXTRA, EventoClassificacao.FALTA_JUSTIFICADA, EventoClassificacao.FALTA_INJUSTIFICADA, EventoClassificacao.FALTA_ABONADA, EventoClassificacao.FALTA_ABONADA_DEMONSTRACAO, EventoClassificacao.ADICIONAL_NOTURNO};
    private Date dataInicio;
    private Date dataFim;
    private StatusEventosPonto[] statusEventoArray = new StatusEventosPonto[]{StatusEventosPonto.APROVADO};

    public EventoClassificacao[] getClassificacao() {
        EventoClassificacao[] classificacao = new EventoClassificacao[]{EventoClassificacao.HORA_EXTRA, EventoClassificacao.FALTA_JUSTIFICADA, EventoClassificacao.FALTA_INJUSTIFICADA, EventoClassificacao.FALTA_ABONADA, EventoClassificacao.FALTA_ABONADA_DEMONSTRACAO, EventoClassificacao.ADICIONAL_NOTURNO};
        return classificacao;
    }

    public StatusEventosPonto[] getStatus() {
        StatusEventosPonto[] status = new StatusEventosPonto[]{StatusEventosPonto.APROVADO, StatusEventosPonto.REPROVADO, StatusEventosPonto.PENDENTE};
        return status;
    }

    public ReportOptions[] getAllGroupBy() {
        ReportOptions[] all = new ReportOptions[]{ReportOptions.DIVISAO, ReportOptions.SUBDIVISAO, ReportOptions.UNIDADE, ReportOptions.LOCAL_TRABALHO, ReportOptions.VINCULO, ReportOptions.CARGO};
        return all;
    }

    public ReportOptions[] getAllNewPageOn() {
        ReportOptions[] all = new ReportOptions[]{ReportOptions.DIVISAO, ReportOptions.SUBDIVISAO, ReportOptions.UNIDADE, ReportOptions.LOCAL_TRABALHO, ReportOptions.VINCULO, ReportOptions.CARGO};
        return all;
    }

    public ReportOptions[] getAllOrderBy() {
        ReportOptions[] all = new ReportOptions[]{ReportOptions.REGISTRO, ReportOptions.MATRICULA, ReportOptions.ALFABETICA};
        return all;
    }

    public String getOrderBySql() {
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        if (ArrayUtils.isNotEmpty((Object[])this.getGroupBy())) {
            block11: for (ReportOptions r : this.getGroupBy()) {
                switch (r) {
                    case DIVISAO: {
                        sb.append("pm.divisaoCodigo, ");
                        continue block11;
                    }
                    case SUBDIVISAO: {
                        sb.append("pm.subdivisaoCodigo, ");
                        continue block11;
                    }
                    case UNIDADE: {
                        sb.append("pm.unidadeCodigo, ");
                        continue block11;
                    }
                    case LOCAL_TRABALHO: {
                        sb.append("pm.localTrabalhoCodigo, ");
                        continue block11;
                    }
                    case VINCULO: {
                        sb.append("pm.vinculoCodigo, ");
                        continue block11;
                    }
                    default: {
                        sb.append("pm.cargoCodigo, ");
                    }
                }
            }
        }
        if (this.getOrderBy() != null) {
            switch (this.getOrderBy()) {
                case REGISTRO: {
                    sb.append("tr.trabalhadorPK.registro, ");
                    break;
                }
                case MATRICULA: {
                    sb.append("tr.matricula, ");
                    break;
                }
                default: {
                    sb.append("tr.nome, ");
                }
            }
        }
        sb.append("pe.pontoEventoPK.evento, pt.data");
        return sb.toString();
    }

    public Map<String, Object> getReportParameters() {
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("ENTIDADE", this.getEntidade());
        if (ArrayUtils.isNotEmpty((Object[])this.getGroupBy())) {
            p.put("GROUP_BY", Arrays.asList(this.getGroupBy()));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.getNewPageOn())) {
            p.put("NEW_PAGE_ON", Arrays.asList(this.getNewPageOn()));
        }
        return p;
    }

    public FilterEntity getFilterEntity() {
        return this.filterEntity;
    }

    public void setFilterEntity(FilterEntity filterEntity) {
        this.filterEntity = filterEntity;
    }

    public ReportOptions[] getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(ReportOptions[] groupBy) {
        this.groupBy = groupBy;
    }

    public ReportOptions[] getNewPageOn() {
        return this.newPageOn;
    }

    public void setNewPageOn(ReportOptions[] newPageOn) {
        this.newPageOn = newPageOn;
    }

    public ReportOptions getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(ReportOptions orderBy) {
        this.orderBy = orderBy;
    }

    public EntidadeMinVo getEntidade() {
        return this.entidade;
    }

    public void setEntidade(EntidadeMinVo entidadeMinVo) {
        this.entidade = entidadeMinVo;
    }

    public EventoClassificacao[] getEventoClassificacao() {
        return this.eventoClassificacao;
    }

    public List<String> getCodigosDasClassificacoes() {
        LinkedList<String> codigoDasClassificacoes = new LinkedList<String>();
        for (EventoClassificacao classificacao : this.eventoClassificacao) {
            codigoDasClassificacoes.add(classificacao.getId());
        }
        return codigoDasClassificacoes;
    }

    public List<String> getCodigoDosStatus() {
        LinkedList<String> codigoDosStatus = new LinkedList<String>();
        for (StatusEventosPonto status : this.statusEventoArray) {
            codigoDosStatus.add(status.getId());
        }
        return codigoDosStatus;
    }

    public void setEventoClassificacao(EventoClassificacao[] eventoClassificacao) {
        this.eventoClassificacao = eventoClassificacao;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public StatusEventosPonto[] getStatusEventoArray() {
        return this.statusEventoArray;
    }

    public void setStatusEventoArray(StatusEventosPonto[] statusEventoArray) {
        this.statusEventoArray = statusEventoArray;
    }
}

