/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoCargo;
import java.util.Date;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="cargoCodigo", label="Cargo", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=1), @FilterConfigParameter(fieldClass=String.class, id="nomeCargo", label="Nome Cargo", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=2), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Dt. Admiss\u00e3o", inputType=FilterInputType.CALENDAR, order=3), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=4), @FilterConfigParameter(fieldClass=String.class, id="nomeTrabalhador", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=5), @FilterConfigParameter(fieldClass=String.class, id="localTrabalhoNome", label="Nome Local de Trabalho", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=6), @FilterConfigParameter(fieldClass=String.class, id="localTrabalhoCodigo", label="Local de Trabalho", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=7), @FilterConfigParameter(fieldClass=String.class, id="tipoCargoAtual", label="Tipo Cargo", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=8), @FilterConfigParameter(fieldClass=Short.class, id="vagas", label="Vagas", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=9), @FilterConfigParameter(fieldClass=String.class, id="salarioAtualCodigo", label="Ref. Sal. Atual", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=10), @FilterConfigParameter(fieldClass=String.class, id="salarioAtualNome", label="Nome Ref. Sal. Atual", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=11), @FilterConfigParameter(fieldClass=Double.class, id="salarioAtualValor", label="Valor Cad. Ref. Sal. Atual", inputType=FilterInputType.DECIMAL, order=12), @FilterConfigParameter(fieldClass=String.class, id="salarioInicialCodigo", label="Ref. Sal. Inicial", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=13), @FilterConfigParameter(fieldClass=String.class, id="salarioInicialNome", label="Nome Ref. Sal. Inicial", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=14), @FilterConfigParameter(fieldClass=Double.class, id="salarioInicialValor", label="Valor Cad. Ref. Sal. Inicial", inputType=FilterInputType.DECIMAL, order=15), @FilterConfigParameter(fieldClass=String.class, id="divisaoCodigo", label="Divis\u00e3o", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=16), @FilterConfigParameter(fieldClass=String.class, id="divisaoNome", label="Nome Divis\u00e3o", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=17), @FilterConfigParameter(fieldClass=String.class, id="subdivisaoCodigo", label="Subdivis\u00e3o", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=17), @FilterConfigParameter(fieldClass=String.class, id="subdivisaoNome", label="Nome Subdivis\u00e3o", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=18), @FilterConfigParameter(fieldClass=Integer.class, id="departamentoDespesa", label="Unidade Or\u00e7ament\u00e1ria", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=19), @FilterConfigParameter(fieldClass=String.class, id="nomeUnidade", label="Nome Unidade", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=20), @FilterConfigParameter(fieldClass=String.class, id="vinculoCodigo", label="V\u00ednculo", inputType=FilterInputType.TEXT, condition=FilterCondition.IGUAL, order=21), @FilterConfigParameter(fieldClass=String.class, id="vinculoNome", label="Nome V\u00ednculo", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=22)})
public class RelacaoFuncionariosCargoVO {
    public static final String FILTER_PARAMETERS = "$P{[cargoCodigo],[c.codigo],[:cargoCodigo]} AND $P{[nomeCargo],[c.nome],[:nomeCargo]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[nomeTrabalhador],[t.nome],[:nomeTrabalhador]} AND $P{[localTrabalhoNome],[l.nome],[:localTrabalhoNome]} AND $P{[localTrabalhoCodigo],[t.localTrabalhoCodigo],[:localTrabalhoCodigo]} AND $P{[tipoCargoAtual],[t.tipoCargoAtual],[:tipoCargoAtual]} AND $P{[vagas],[COALESCE(c.vagaCargo, 0)+COALESCE(c.vagaEmprego, 0)+COALESCE(c.vagaFuncao, 0)+COALESCE(c.vagaContrato, 0)][:vagas]} AND $P{[salarioAtualCodigo],[t.salarioAtualCodigo],[:salarioAtualCodigo]} AND $P{[salarioAtualNome],[sa.nome],[:salarioAtualNome]} AND $P{[salarioAtualValor],[sa.valor],[:salarioAtualValor]} AND $P{[salarioInicialCodigo],[t.salarioInicialCodigo],[:salarioInicialCodigo]} AND $P{[salarioInicialNome],[si.nome],[:salarioInicialNome]} AND $P{[salarioInicialValor],[si.valor],[:salarioInicialValor]} AND $P{[divisaoCodigo],[t.divisaoCodigo],[:divisaoCodigo]} AND $P{[divisaoNome],[d.nome],[:divisaoNome]} AND $P{[subdivisaoCodigo],[t.subdivisaoCodigo],[:subdivisaoCodigo]} AND $P{[subdivisaoNome],[s.nome],[:subdivisaoNome]} AND $P{[departamentoDespesa],[t.unidadeCodigo],[:departamentoDespesa]} AND $P{[nomeUnidade],[u.nome],[:nomeUnidade]} AND $P{[vinculoCodigo],[t.vinculoCodigo],[:vinculoCodigo]} AND $P{[vinculoNome],[v.nome],[:vinculoNome]} ";
    public static final String CARGO_INICIAL = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoFuncionariosCargoVO(c.codigo as cargo, c.nome as nomeCargo, t.trabalhadorPK.registro, t.matricula, t.contrato, t.nome as nomeFuncionario, t.dataAdmissao, t.tipoCargoInicial as tipoCargo, COALESCE(c.vagaCargo, 0)+COALESCE(c.vagaEmprego, 0)+COALESCE(c.vagaFuncao, 0)+COALESCE(c.vagaContrato, 0) as vagas) FROM Cargo c LEFT JOIN c.trabalhadorCargoInicial t WITH ((t.dataAdmissao <= :dataBase) AND ((t.situacao = '1') OR (t.dataDemissao > :dataBase))) LEFT JOIN t.salarioAtual sa LEFT JOIN t.salarioInicial si LEFT JOIN t.divisao d LEFT JOIN t.subdivisao s LEFT JOIN t.unidade u LEFT JOIN t.vinculo v LEFT JOIN t.localTrabalho l WHERE $P{[cargoCodigo],[c.codigo],[:cargoCodigo]} AND $P{[nomeCargo],[c.nome],[:nomeCargo]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[nomeTrabalhador],[t.nome],[:nomeTrabalhador]} AND $P{[localTrabalhoNome],[l.nome],[:localTrabalhoNome]} AND $P{[localTrabalhoCodigo],[t.localTrabalhoCodigo],[:localTrabalhoCodigo]} AND $P{[tipoCargoAtual],[t.tipoCargoAtual],[:tipoCargoAtual]} AND $P{[vagas],[COALESCE(c.vagaCargo, 0)+COALESCE(c.vagaEmprego, 0)+COALESCE(c.vagaFuncao, 0)+COALESCE(c.vagaContrato, 0)][:vagas]} AND $P{[salarioAtualCodigo],[t.salarioAtualCodigo],[:salarioAtualCodigo]} AND $P{[salarioAtualNome],[sa.nome],[:salarioAtualNome]} AND $P{[salarioAtualValor],[sa.valor],[:salarioAtualValor]} AND $P{[salarioInicialCodigo],[t.salarioInicialCodigo],[:salarioInicialCodigo]} AND $P{[salarioInicialNome],[si.nome],[:salarioInicialNome]} AND $P{[salarioInicialValor],[si.valor],[:salarioInicialValor]} AND $P{[divisaoCodigo],[t.divisaoCodigo],[:divisaoCodigo]} AND $P{[divisaoNome],[d.nome],[:divisaoNome]} AND $P{[subdivisaoCodigo],[t.subdivisaoCodigo],[:subdivisaoCodigo]} AND $P{[subdivisaoNome],[s.nome],[:subdivisaoNome]} AND $P{[departamentoDespesa],[t.unidadeCodigo],[:departamentoDespesa]} AND $P{[nomeUnidade],[u.nome],[:nomeUnidade]} AND $P{[vinculoCodigo],[t.vinculoCodigo],[:vinculoCodigo]} AND $P{[vinculoNome],[v.nome],[:vinculoNome]} ";
    public static final String CARGO_ATUAL = "SELECT DISTINCT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoFuncionariosCargoVO(c.codigo as cargo, c.nome as nomeCargo, t.trabalhadorPK.registro, t.matricula, t.contrato, t.nome as nomeFuncionario, t.dataAdmissao, t.tipoCargoAtual as tipoCargo, COALESCE(c.vagaCargo, 0)+COALESCE(c.vagaEmprego, 0)+COALESCE(c.vagaFuncao, 0)+COALESCE(c.vagaContrato, 0) as vagas) FROM Bases b LEFT JOIN b.cargo c LEFT JOIN b.trabalhador t INNER JOIN t.salarioAtual sa INNER JOIN t.salarioInicial si LEFT JOIN b.divisao d LEFT JOIN b.subdivisao s LEFT JOIN b.unidade u LEFT JOIN b.vinculo v LEFT JOIN b.localTrabalho l WHERE $P{[cargoCodigo],[c.codigo],[:cargoCodigo]} AND $P{[nomeCargo],[c.nome],[:nomeCargo]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[nomeTrabalhador],[t.nome],[:nomeTrabalhador]} AND $P{[localTrabalhoNome],[l.nome],[:localTrabalhoNome]} AND $P{[localTrabalhoCodigo],[t.localTrabalhoCodigo],[:localTrabalhoCodigo]} AND $P{[tipoCargoAtual],[t.tipoCargoAtual],[:tipoCargoAtual]} AND $P{[vagas],[COALESCE(c.vagaCargo, 0)+COALESCE(c.vagaEmprego, 0)+COALESCE(c.vagaFuncao, 0)+COALESCE(c.vagaContrato, 0)][:vagas]} AND $P{[salarioAtualCodigo],[t.salarioAtualCodigo],[:salarioAtualCodigo]} AND $P{[salarioAtualNome],[sa.nome],[:salarioAtualNome]} AND $P{[salarioAtualValor],[sa.valor],[:salarioAtualValor]} AND $P{[salarioInicialCodigo],[t.salarioInicialCodigo],[:salarioInicialCodigo]} AND $P{[salarioInicialNome],[si.nome],[:salarioInicialNome]} AND $P{[salarioInicialValor],[si.valor],[:salarioInicialValor]} AND $P{[divisaoCodigo],[t.divisaoCodigo],[:divisaoCodigo]} AND $P{[divisaoNome],[d.nome],[:divisaoNome]} AND $P{[subdivisaoCodigo],[t.subdivisaoCodigo],[:subdivisaoCodigo]} AND $P{[subdivisaoNome],[s.nome],[:subdivisaoNome]} AND $P{[departamentoDespesa],[t.unidadeCodigo],[:departamentoDespesa]} AND $P{[nomeUnidade],[u.nome],[:nomeUnidade]} AND $P{[vinculoCodigo],[t.vinculoCodigo],[:vinculoCodigo]} AND $P{[vinculoNome],[v.nome],[:vinculoNome]} ";
    private final String cargo;
    private final String nomeCargo;
    private final String registro;
    private final Integer matricula;
    private final Short contrato;
    private final String nomeFuncionario;
    private final Date dataAdmissao;
    private final String tipoCargo;
    private final Short vagas;

    public RelacaoFuncionariosCargoVO(String cargo, String nomeCargo, String registro, Integer matricula, Short contrato, String nomeFuncionario, Date dataAdmissao, String tipoCargo, Short vagas) {
        this.cargo = cargo;
        this.nomeCargo = nomeCargo;
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nomeFuncionario = nomeFuncionario;
        this.dataAdmissao = dataAdmissao;
        this.tipoCargo = tipoCargo;
        this.vagas = vagas;
    }

    public String getCargo() {
        return this.cargo;
    }

    public String getNomeCargo() {
        return this.nomeCargo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNomeFuncionario() {
        return this.nomeFuncionario;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public String getTipoCargo() {
        if (this.tipoCargo != null) {
            return TrabalhadorTipoCargo.of(this.tipoCargo).getDescricao();
        }
        return "Vago";
    }

    public Short getVagas() {
        return this.vagas;
    }
}

