/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TipoOcorrencia;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorSituacao;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.util.Date;
import org.joda.time.Duration;

@FilterConfigType(query="select new br.com.fiorilli.sip.persistence.vo.reports.RelacaoDeOcorrenciasVO(concat(oc.id, '-', oc.nome), concat(t.matricula, '-', t.contrato), t.nome, p.data, concat(p.jornadaCodigo, '-', p.jornada.nome), p.entrada1, p.saida1, p.entrada2, p.saida2, p.entrada3, p.saida3, p.horasTrabalhadas, p.horasNoturnas, coalesce((\tselect sum(pe.quantidadeMillis) from PontoEvento pe \twhere pe.pontoEventoPK.ponto = p.codigo and pe.tipo = 'D' and pe.evento.classificacao <> '24' ), 0), coalesce((\tselect sum(pe.quantidadeMillis) from PontoEvento pe \twhere pe.pontoEventoPK.ponto = p.codigo and pe.tipo = 'F' and pe.evento.classificacao <> '05' ), 0)) from PontoTipoOcorrencia po left join po.tipoOcorrencia oc left join po.ponto p left join p.pontoMes pm left join p.trabalhador t where p.entidadeCodigo = :entidadeCodigo AND p.data between :periodoInicio and :periodoFim AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[tipoOcorrencia],[po.tipoOcorrencia],[:tipoOcorrencia]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[numeroCartao],[t.ponto.numeroCartao],[:numeroCartao]} AND $P{[jornada],[p.jornada],[:jornada]} AND $P{[vinculo],[pm.vinculo],[:vinculo]} AND $P{[divisao],[pm.divisao],[:divisao]} AND $P{[subdivisao],[pm.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[pm.localTrabalho],[:localTrabalho]} AND $P{[unidade],[pm.unidade],[:unidade]} ", displayField=2)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TipoOcorrencia.class, id="tipoOcorrencia", label="Ocorr\u00eancia", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT o FROM TipoOcorrencia o where concat(o.id, o.nome) LIKE concat('%', :param, '%')"), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TrabalhadorSituacao.class, id="situacao", label="Situa\u00e7\u00e3o", enumClass=TrabalhadorSituacao.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=String.class, id="numeroCartao", label="N\u00fam. Cart\u00e3o Ponto"), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano")})
public class RelacaoDeOcorrenciasVO {
    public static final String QUERY = "select new br.com.fiorilli.sip.persistence.vo.reports.RelacaoDeOcorrenciasVO(concat(oc.id, '-', oc.nome), concat(t.matricula, '-', t.contrato), t.nome, p.data, concat(p.jornadaCodigo, '-', p.jornada.nome), p.entrada1, p.saida1, p.entrada2, p.saida2, p.entrada3, p.saida3, p.horasTrabalhadas, p.horasNoturnas, coalesce((\tselect sum(pe.quantidadeMillis) from PontoEvento pe \twhere pe.pontoEventoPK.ponto = p.codigo and pe.tipo = 'D' and pe.evento.classificacao <> '24' ), 0), coalesce((\tselect sum(pe.quantidadeMillis) from PontoEvento pe \twhere pe.pontoEventoPK.ponto = p.codigo and pe.tipo = 'F' and pe.evento.classificacao <> '05' ), 0)) from PontoTipoOcorrencia po left join po.tipoOcorrencia oc left join po.ponto p left join p.pontoMes pm left join p.trabalhador t where p.entidadeCodigo = :entidadeCodigo AND p.data between :periodoInicio and :periodoFim AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[tipoOcorrencia],[po.tipoOcorrencia],[:tipoOcorrencia]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[numeroCartao],[t.ponto.numeroCartao],[:numeroCartao]} AND $P{[jornada],[p.jornada],[:jornada]} AND $P{[vinculo],[pm.vinculo],[:vinculo]} AND $P{[divisao],[pm.divisao],[:divisao]} AND $P{[subdivisao],[pm.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[pm.localTrabalho],[:localTrabalho]} AND $P{[unidade],[pm.unidade],[:unidade]} ";
    private String ocorrencia;
    private String matriculaContrato;
    private String nome;
    private Date data;
    private String jornada;
    private String entrada1;
    private String saida1;
    private String entrada2;
    private String saida2;
    private String entrada3;
    private String saida3;
    private Duration horasTrabalhadas;
    private Duration horasNoturnas;
    private Long horasExtrasMillis;
    private Long faltasMillis;

    public RelacaoDeOcorrenciasVO(String ocorrencia, String matriculaContrato, String nome, Date data, String jornada, String entrada1, String saida1, String entrada2, String saida2, String entrada3, String saida3, Duration horasTrabalhadas, Duration horasNoturnas, Long horasExtrasMillis, Long faltasMillis) {
        this.ocorrencia = ocorrencia;
        this.matriculaContrato = matriculaContrato;
        this.nome = nome;
        this.data = data;
        this.jornada = jornada;
        this.entrada1 = entrada1;
        this.saida1 = saida1;
        this.entrada2 = entrada2;
        this.saida2 = saida2;
        this.entrada3 = entrada3;
        this.saida3 = saida3;
        this.horasTrabalhadas = horasTrabalhadas;
        this.horasNoturnas = horasNoturnas;
        this.horasExtrasMillis = horasExtrasMillis;
        this.faltasMillis = faltasMillis;
    }

    public String getMatriculaContrato() {
        return this.matriculaContrato;
    }

    public String getOcorrencia() {
        return this.ocorrencia;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getData() {
        return this.data;
    }

    public String getJornada() {
        return this.jornada;
    }

    public String getEntrada1() {
        return this.entrada1;
    }

    public String getSaida1() {
        return this.saida1;
    }

    public String getEntrada2() {
        return this.entrada2;
    }

    public String getSaida2() {
        return this.saida2;
    }

    public String getEntrada3() {
        return this.entrada3;
    }

    public String getSaida3() {
        return this.saida3;
    }

    public Duration getHorasTrabalhadas() {
        return this.horasTrabalhadas;
    }

    public Duration getHorasNoturnas() {
        return this.horasNoturnas;
    }

    public Long getHorasExtrasMillis() {
        return this.horasExtrasMillis;
    }

    public Long getFaltasMillis() {
        return this.faltasMillis;
    }
}

