/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasPorHorarioParams;
import br.com.fiorilli.sip.persistence.vo.reports.ReportOptions;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="Vinculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasSemanal", label="Horas Semanal", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasMes", label="Horas M\u00eas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Sal\u00e1rio", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano")})
public class RelacaoBatidasPorHorarioVo {
    private Integer matricula;
    private Short contrato;
    private String nome;
    private Date data;
    private String entrada1;
    private String saida1;
    private String entrada2;
    private String saida2;
    private String entrada3;
    private String saida3;
    private String entrada4;
    private String saida4;
    private String entrada5;
    private String saida5;
    private String jornada;
    public static final String QUERY = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasPorHorarioVo(tr.matricula, tr.contrato, tr.nome, p.data, case when ((:exibirAcimaLimite = true) and (((CASE p.entrada1 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada1 as time) END) - (CASE j.entrada1 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada1 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.entrada1,'</b>') else p.entrada1 end, case when ((:exibirAcimaLimite = true) and (((CASE j.saida1 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida1 as time) END) - (CASE p.saida1 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida1 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.saida1,'</b>') else p.saida1 end, case when ((:exibirAcimaLimite = true) and (((CASE p.entrada2 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada2 as time) END) - (CASE j.entrada2 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada2 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.entrada2,'</b>') else p.entrada2 end, case when ((:exibirAcimaLimite = true) and (((CASE j.saida2 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida2 as time) END) - (CASE p.saida2 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida2 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.saida2,'</b>') else p.saida2 end, case when ((:exibirAcimaLimite = true) and (((CASE p.entrada3 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada3 as time) END) - (CASE j.entrada3 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada3 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.entrada3,'</b>') else p.entrada3 end, case when ((:exibirAcimaLimite = true) and (((CASE j.saida3 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida3 as time) END) - (CASE p.saida3 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida3 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.saida3,'</b>') else p.saida3 end, case when ((:exibirAcimaLimite = true) and (((CASE p.entrada4 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada4 as time) END) - (CASE j.entrada4 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada4 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.entrada4,'</b>') else p.entrada4 end, case when ((:exibirAcimaLimite = true) and (((CASE j.saida4 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida4 as time) END) - (CASE p.saida4 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida4 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.saida4,'</b>') else p.saida4 end, case when ((:exibirAcimaLimite = true) and (((CASE p.entrada5 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada5 as time) END) - (CASE j.entrada5 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada5 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.entrada5,'</b>') else p.entrada5 end, case when ((:exibirAcimaLimite = true) and (((CASE j.saida5 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida5 as time) END) - (CASE p.saida5 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida5 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) then concat('<b>',p.saida5,'</b>') else p.saida5 end, trim(concat(coalesce(j.entrada1, ''), coalesce(concat('-', case when j.saida1 = '' then null else j.saida1 end), ''), ' ',             coalesce(j.entrada2, ''), coalesce(concat('-', case when j.saida2 = '' then null else j.saida2 end), ''), ' ',             coalesce(j.entrada3, ''), coalesce(concat('-', case when j.saida3 = '' then null else j.saida3 end), ''), ' ',             coalesce(j.entrada4, ''), coalesce(concat('-', case when j.saida4 = '' then null else j.saida4 end), ''), ' ',             coalesce(j.entrada5, ''), coalesce(concat('-', case when j.saida5 = '' then null else j.saida5 end), '')))) FROM Ponto p LEFT JOIN p.trabalhador tr LEFT JOIN tr.vinculo v LEFT JOIN tr.divisao d LEFT JOIN tr.subdivisao s LEFT JOIN tr.unidade u LEFT JOIN tr.localTrabalho l LEFT JOIN p.jornadaDia j WHERE p.entidadeCodigo = :entidadeCodigo AND p.data BETWEEN :periodoInicio AND :periodoFim ";
    public static final String QUERY_FILTER = "$P{[vinculo],[v],[:vinculo]} AND $P{[divisao],[d],[:divisao]} AND $P{[subdivisao],[s],[:subdivisao]} AND $P{[unidade],[u],[:unidade]} AND $P{[horasSemanal],[tr.horasSemanal],[:horasSemanal]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} AND $P{[localTrabalho],[l],[:localTrabalho]} ";

    public static String buildQueryBy(ReportOptions orderBy, List<RelacaoBatidasPorHorarioParams.TipoBatidasEnum> tiposBatida, boolean exibirSomenteAcimaLimite) {
        StringBuilder sbQuery = new StringBuilder(QUERY);
        if (tiposBatida != null && tiposBatida.size() > 0) {
            boolean primeiraCondicao = Boolean.TRUE;
            for (RelacaoBatidasPorHorarioParams.TipoBatidasEnum tipoBatida : tiposBatida) {
                sbQuery.append(tipoBatida.createWhereQuery(primeiraCondicao, exibirSomenteAcimaLimite));
                if (!primeiraCondicao) continue;
                primeiraCondicao = Boolean.FALSE;
            }
            sbQuery.append(") ");
            sbQuery.append("AND ").append(QUERY_FILTER);
            if (orderBy.equals((Object)ReportOptions.MATRICULA)) {
                sbQuery.append(" ORDER BY tr.matricula, p.data");
            } else {
                sbQuery.append(" ORDER BY tr.nome, p.data");
            }
        }
        return sbQuery.toString();
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getData() {
        return this.data;
    }

    public String getEntrada1() {
        return this.entrada1;
    }

    public String getSaida1() {
        return this.saida1;
    }

    public String getEntrada2() {
        return this.entrada2;
    }

    public String getSaida2() {
        return this.saida2;
    }

    public String getEntrada3() {
        return this.entrada3;
    }

    public String getSaida3() {
        return this.saida3;
    }

    public String getEntrada4() {
        return this.entrada4;
    }

    public String getSaida4() {
        return this.saida4;
    }

    public String getEntrada5() {
        return this.entrada5;
    }

    public String getSaida5() {
        return this.saida5;
    }

    public String getJornada() {
        return this.jornada;
    }

    public RelacaoBatidasPorHorarioVo(Integer matricula, Short contrato, String nome, Date data, String entrada1, String saida1, String entrada2, String saida2, String entrada3, String saida3, String entrada4, String saida4, String entrada5, String saida5, String jornada) {
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.data = data;
        this.entrada1 = entrada1;
        this.saida1 = saida1;
        this.entrada2 = entrada2;
        this.saida2 = saida2;
        this.entrada3 = entrada3;
        this.saida3 = saida3;
        this.entrada4 = entrada4;
        this.saida4 = saida4;
        this.entrada5 = entrada5;
        this.saida5 = saida5;
        this.jornada = jornada;
    }
}

