/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.sip.persistence.vo.reports.ReportOptions;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;

public class RelacaoBatidasPorHorarioParams {
    private Date periodoInicio;
    private Date periodoFim;
    private Date horarioInicio;
    private Date horarioFim;
    private ReportOptions orderBy;
    private List<TipoBatidasEnum> tiposBatida;
    private Integer minutosLimite;
    private boolean exibirSomenteAcimaLimite;

    public Date getHorarioInicioLimiteMenor() {
        DateTime horarioInicio = new DateTime((Object)this.horarioInicio);
        return this.minutosLimite == null ? this.horarioInicio : horarioInicio.minusMinutes(this.minutosLimite.intValue()).toDate();
    }

    public Date getHorarioInicioLimiteMaior() {
        DateTime horarioInicio = new DateTime((Object)this.horarioInicio);
        return this.minutosLimite == null ? this.horarioInicio : horarioInicio.plusMinutes(this.minutosLimite.intValue()).toDate();
    }

    public Date getHorarioFimLimiteMenor() {
        DateTime horarioFim = new DateTime((Object)this.horarioFim);
        return this.minutosLimite == null ? this.horarioFim : horarioFim.minusMinutes(this.minutosLimite.intValue()).toDate();
    }

    public Date getHorarioFimLimiteMaior() {
        DateTime horarioFim = new DateTime((Object)this.horarioFim);
        return this.minutosLimite == null ? this.horarioFim : horarioFim.plusMinutes(this.minutosLimite.intValue()).toDate();
    }

    public RelacaoBatidasPorHorarioParams(ReportOptions orderBy) {
        this.orderBy = orderBy;
    }

    public Date getPeriodoInicio() {
        return this.periodoInicio;
    }

    public Date getPeriodoFim() {
        return this.periodoFim;
    }

    public Date getHorarioInicio() {
        return this.horarioInicio;
    }

    public Date getHorarioFim() {
        return this.horarioFim;
    }

    public ReportOptions getOrderBy() {
        return this.orderBy;
    }

    public List<TipoBatidasEnum> getTiposBatida() {
        return this.tiposBatida;
    }

    public Integer getMinutosLimite() {
        return this.minutosLimite;
    }

    public boolean isExibirSomenteAcimaLimite() {
        return this.exibirSomenteAcimaLimite;
    }

    public void setPeriodoInicio(Date periodoInicio) {
        this.periodoInicio = periodoInicio;
    }

    public void setPeriodoFim(Date periodoFim) {
        this.periodoFim = periodoFim;
    }

    public void setHorarioInicio(Date horarioInicio) {
        this.horarioInicio = horarioInicio;
    }

    public void setHorarioFim(Date horarioFim) {
        this.horarioFim = horarioFim;
    }

    public void setOrderBy(ReportOptions orderBy) {
        this.orderBy = orderBy;
    }

    public void setTiposBatida(List<TipoBatidasEnum> tiposBatida) {
        this.tiposBatida = tiposBatida;
    }

    public void setMinutosLimite(Integer minutosLimite) {
        this.minutosLimite = minutosLimite;
    }

    public void setExibirSomenteAcimaLimite(boolean exibirSomenteAcimaLimite) {
        this.exibirSomenteAcimaLimite = exibirSomenteAcimaLimite;
    }

    public RelacaoBatidasPorHorarioParams() {
    }

    public static enum TipoBatidasEnum {
        ENTRADA_SAIDA_1(1, "Entrada e Sa\u00edda 1"){

            @Override
            public String createWhereQuery(Boolean primeiraCondicao, boolean exibirSomenteAcimaLimite) {
                StringBuilder sb = new StringBuilder(TipoBatidasEnum.createStringAndOr(primeiraCondicao));
                if (exibirSomenteAcimaLimite) {
                    sb.append("((p.entrada1 IS NOT NULL) AND (((((CASE p.entrada1 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada1 as time) END) - (CASE j.entrada1 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada1 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) ");
                    sb.append("OR ((p.saida1 IS NOT NULL) AND (((CASE j.saida1 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida1 as time) END) - (CASE p.saida1 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida1 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)))) ");
                } else {
                    sb.append(" (CASE p.entrada1 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada1 as time) END BETWEEN :horarioInicioLimiteMenor AND :horarioInicioLimiteMaior AND CASE p.saida1 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida1 as time) END BETWEEN :horarioFimLimiteMenor AND :horarioFimLimiteMaior");
                    sb.append(" AND p.entrada1 IS NOT NULL AND p.saida1 IS NOT NULL) ");
                }
                return sb.toString();
            }
        }
        ,
        ENTRADA_SAIDA_2(2, "Entrada e Sa\u00edda 2"){

            @Override
            public String createWhereQuery(Boolean primeiraCondicao, boolean exibirSomenteAcimaLimite) {
                StringBuilder sb = new StringBuilder(TipoBatidasEnum.createStringAndOr(primeiraCondicao));
                if (exibirSomenteAcimaLimite) {
                    sb.append("((p.entrada2 IS NOT NULL) AND (((((CASE p.entrada2 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada2 as time) END) - (CASE j.entrada2 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada2 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) ");
                    sb.append("OR ((p.saida2 IS NOT NULL) AND (((CASE j.saida2 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida2 as time) END) - (CASE p.saida2 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida2 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)))) ");
                } else {
                    sb.append(" (CASE p.entrada2 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada2 as time) END BETWEEN :horarioInicioLimiteMenor AND :horarioInicioLimiteMaior AND CASE p.saida2 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida2 as time) END BETWEEN :horarioFimLimiteMenor AND :horarioFimLimiteMaior");
                    sb.append(" AND p.entrada2 IS NOT NULL AND p.saida2 IS NOT NULL) ");
                }
                return sb.toString();
            }
        }
        ,
        ENTRADA_SAIDA_3(3, "Entrada e Sa\u00edda 3"){

            @Override
            public String createWhereQuery(Boolean primeiraCondicao, boolean exibirSomenteAcimaLimite) {
                StringBuilder sb = new StringBuilder(TipoBatidasEnum.createStringAndOr(primeiraCondicao));
                if (exibirSomenteAcimaLimite) {
                    sb.append("((p.entrada3 IS NOT NULL) AND (((((CASE p.entrada3 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada3 as time) END) - (CASE j.entrada3 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada3 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) ");
                    sb.append("OR ((p.saida3 IS NOT NULL) AND (((CASE j.saida3 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida3 as time) END) - (CASE p.saida3 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida3 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)))) ");
                } else {
                    sb.append(" (CASE p.entrada3 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada3 as time) END BETWEEN :horarioInicioLimiteMenor AND :horarioInicioLimiteMaior AND CASE p.saida3 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida3 as time) END BETWEEN :horarioFimLimiteMenor AND :horarioFimLimiteMaior");
                    sb.append(" AND p.entrada3 IS NOT NULL AND p.saida3 IS NOT NULL) ");
                }
                return sb.toString();
            }
        }
        ,
        ENTRADA_SAIDA_4(4, "Entrada e Sa\u00edda 4"){

            @Override
            public String createWhereQuery(Boolean primeiraCondicao, boolean exibirSomenteAcimaLimite) {
                StringBuilder sb = new StringBuilder(TipoBatidasEnum.createStringAndOr(primeiraCondicao));
                if (exibirSomenteAcimaLimite) {
                    sb.append("((p.entrada4 IS NOT NULL) AND (((((CASE p.entrada4 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada4 as time) END) - (CASE j.entrada4 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada4 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) ");
                    sb.append("OR ((p.saida4 IS NOT NULL) AND (((CASE j.saida4 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida4 as time) END) - (CASE p.saida4 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida4 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)))) ");
                } else {
                    sb.append(" (CASE p.entrada4 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada4 as time) END BETWEEN :horarioInicioLimiteMenor AND :horarioInicioLimiteMaior AND CASE p.saida4 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida4 as time) END BETWEEN :horarioFimLimiteMenor AND :horarioFimLimiteMaior");
                    sb.append(" AND p.entrada4 IS NOT NULL AND p.saida4 IS NOT NULL) ");
                }
                return sb.toString();
            }
        }
        ,
        ENTRADA_SAIDA_5(5, "Entrada e Sa\u00edda 5"){

            @Override
            public String createWhereQuery(Boolean primeiraCondicao, boolean exibirSomenteAcimaLimite) {
                StringBuilder sb = new StringBuilder(TipoBatidasEnum.createStringAndOr(primeiraCondicao));
                if (exibirSomenteAcimaLimite) {
                    sb.append("((p.entrada5 IS NOT NULL) AND (((((CASE p.entrada5 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada5 as time) END) - (CASE j.entrada5 WHEN '' THEN CAST(null as time) ELSE CAST(j.entrada5 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)) ");
                    sb.append("OR ((p.saida5 IS NOT NULL) AND (((CASE j.saida5 WHEN '' THEN CAST(null as time) ELSE CAST(j.saida5 as time) END) - (CASE p.saida5 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida5 as time) END)) / 60) > CAST(:limiteToleranciaMinutos as double)))) ");
                } else {
                    sb.append(" (CASE p.entrada5 WHEN '' THEN CAST(null as time) ELSE CAST(p.entrada5 as time) END BETWEEN :horarioInicioLimiteMenor AND :horarioInicioLimiteMaior AND CASE p.saida5 WHEN '' THEN CAST(null as time) ELSE CAST(p.saida5 as time) END BETWEEN :horarioFimLimiteMenor AND :horarioFimLimiteMaior");
                    sb.append(" AND p.entrada5 IS NOT NULL AND p.saida5 IS NOT NULL) ");
                }
                return sb.toString();
            }
        };

        private final int id;
        private final String descricao;

        public abstract String createWhereQuery(Boolean var1, boolean var2);

        private static String createStringAndOr(Boolean primeiraCondicao) {
            return primeiraCondicao != false ? " AND ( " : " OR ";
        }

        private TipoBatidasEnum(int id, String descricao) {
            this.id = id;
            this.descricao = descricao;
        }

        public int getId() {
            return this.id;
        }

        public String getDescricao() {
            return this.descricao;
        }
    }
}

