/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import java.math.BigDecimal;
import java.util.Date;

@FilterConfigType(query="SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasGeolocalizacaoDivergenteVo(pw.nsr, pw.registro, pw.dataHora, pw.latitude, pw.longitude, pw.ip, tr.matricula, tr.contrato, tr.nome, lo.nome, lo.latitude, lo.longitude, ca.nome, pw.distanciaBatidaMetros) FROM PontoWeb pw LEFT JOIN pw.trabalhador tr LEFT JOIN pw.localTrabalho lo LEFT JOIN tr.cargoAtual ca LEFT JOIN tr.divisao di LEFT JOIN tr.subdivisao su WHERE pw.entidadeCodigo = :entidadeCodigo AND pw.dataHora BETWEEN :periodoInicio AND :periodoFim AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[divisao],[tr.divisao],[:divisao]} AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[pw.localTrabalho],[:localTrabalho]} AND $P{[cargoAtual],[tr.cargoAtual],[:cargoAtual]} AND $P{[horasSemanal],[tr.horasSemanal],[:horasSemanal]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} AND $P{[distanciaBatidaMetros], [pw.distanciaBatidaMetros], [:distanciaBatidaMetros]} ORDER BY tr.nome, pw.nsr ")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Dt. Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargoAtual", label="Cargo Atual", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasSemanal", label="Horas Semanal", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasMes", label="Horas M\u00eas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Sal\u00e1rio", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Double.class, id="distanciaBatidaMetros", label="Dist\u00e2ncia da Batida em Metros (Raio)", inputType=FilterInputType.NUMBER, condition=FilterCondition.MAIOR, order=4)})
public class RelacaoBatidasGeolocalizacaoDivergenteVo {
    public static final String QUERY = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasGeolocalizacaoDivergenteVo(pw.nsr, pw.registro, pw.dataHora, pw.latitude, pw.longitude, pw.ip, tr.matricula, tr.contrato, tr.nome, lo.nome, lo.latitude, lo.longitude, ca.nome, pw.distanciaBatidaMetros) FROM PontoWeb pw LEFT JOIN pw.trabalhador tr LEFT JOIN pw.localTrabalho lo LEFT JOIN tr.cargoAtual ca LEFT JOIN tr.divisao di LEFT JOIN tr.subdivisao su WHERE pw.entidadeCodigo = :entidadeCodigo AND pw.dataHora BETWEEN :periodoInicio AND :periodoFim AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[divisao],[tr.divisao],[:divisao]} AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[pw.localTrabalho],[:localTrabalho]} AND $P{[cargoAtual],[tr.cargoAtual],[:cargoAtual]} AND $P{[horasSemanal],[tr.horasSemanal],[:horasSemanal]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} AND $P{[distanciaBatidaMetros], [pw.distanciaBatidaMetros], [:distanciaBatidaMetros]} ORDER BY tr.nome, pw.nsr ";
    private final Integer nsr;
    private final String registro;
    private final Date dataHora;
    private final Double latitudeBatida;
    private final Double longitudeBatida;
    private final String ip;
    private final Integer matricula;
    private final Short contrato;
    private final String nome;
    private final String localTrabalho;
    private final Double latitudeLocalTrabalho;
    private final Double longitudeLocalTrabalho;
    private final String cargo;
    private final Double distanciaBatidaMetros;

    public RelacaoBatidasGeolocalizacaoDivergenteVo(Integer nsr, String registro, Date dataHora, Double latitudeTrabalhador, Double longitudeTrabalhador, String ip, Integer matricula, Short contrato, String nome, String localTrabalho, Double latitudeLocalTrabalho, Double longitudeLocalTrabalho, String cargo, Double distanciaBatidaMetros) {
        this.nsr = nsr;
        this.registro = registro;
        this.dataHora = dataHora;
        this.latitudeBatida = latitudeTrabalhador;
        this.longitudeBatida = longitudeTrabalhador;
        this.ip = ip;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.localTrabalho = localTrabalho;
        this.latitudeLocalTrabalho = latitudeLocalTrabalho;
        this.longitudeLocalTrabalho = longitudeLocalTrabalho;
        this.cargo = cargo;
        this.distanciaBatidaMetros = distanciaBatidaMetros;
    }

    public Integer getNsr() {
        return this.nsr;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public Double getLatitudeBatida() {
        return this.latitudeBatida;
    }

    public Double getLongitudeBatida() {
        return this.longitudeBatida;
    }

    public String getIp() {
        return this.ip;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public String getLocalTrabalho() {
        return this.localTrabalho;
    }

    public Double getLatitudeLocalTrabalho() {
        return this.latitudeLocalTrabalho;
    }

    public Double getLongitudeLocalTrabalho() {
        return this.longitudeLocalTrabalho;
    }

    public String getCargo() {
        return this.cargo;
    }

    public Double getDistanciaBatidaMetros() {
        return this.distanciaBatidaMetros;
    }
}

