/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.PontoSituacao;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.math.BigDecimal;
import java.util.Date;

@FilterConfigType(query="SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasEmBrancoVo(t.matricula, t.contrato, t.nome, c.nome, p.data, p.entrada1, p.saida1, p.entrada2, p.saida2, p.entrada3, p.saida3, d.nome, s.nome, u.nome, l.nome, p.situacao, p.feriado, p.pontoFacultativo) FROM Ponto p JOIN p.trabalhador t LEFT JOIN t.cargoAtual c LEFT JOIN t.vinculo v LEFT JOIN t.divisao d LEFT JOIN t.subdivisao s LEFT JOIN t.unidade u LEFT JOIN t.localTrabalho l LEFT JOIN p.jornada j LEFT JOIN p.jornadaDia jd WHERE p.entidadeCodigo = :entidadeCodigo AND $P{[jornada],[j],[:jornada]} AND $P{[vinculo],[v],[:vinculo]} AND $P{[divisao],[d],[:divisao]} AND $P{[subdivisao],[s],[:subdivisao]} AND $P{[tipoPonto],[t.ponto.tipo],[:tipoPonto]} AND $P{[unidade],[u],[:unidade]} AND $P{[localTrabalho],[l],[:localTrabalho]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[horasSemanal],[t.horasSemanal],[:horasSemanal]} AND $P{[data], [p.data], [:data]} ")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Date.class, id="data", label="Data", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="Vinculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano"), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasSemanal", label="Horas Semana", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasMes", label="Horas M\u00eas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Sal\u00e1rio", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU)})
public class RelacaoBatidasEmBrancoVo {
    public static final String QUERY = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasEmBrancoVo(t.matricula, t.contrato, t.nome, c.nome, p.data, p.entrada1, p.saida1, p.entrada2, p.saida2, p.entrada3, p.saida3, d.nome, s.nome, u.nome, l.nome, p.situacao, p.feriado, p.pontoFacultativo) FROM Ponto p JOIN p.trabalhador t LEFT JOIN t.cargoAtual c LEFT JOIN t.vinculo v LEFT JOIN t.divisao d LEFT JOIN t.subdivisao s LEFT JOIN t.unidade u LEFT JOIN t.localTrabalho l LEFT JOIN p.jornada j LEFT JOIN p.jornadaDia jd WHERE p.entidadeCodigo = :entidadeCodigo AND $P{[jornada],[j],[:jornada]} AND $P{[vinculo],[v],[:vinculo]} AND $P{[divisao],[d],[:divisao]} AND $P{[subdivisao],[s],[:subdivisao]} AND $P{[tipoPonto],[t.ponto.tipo],[:tipoPonto]} AND $P{[unidade],[u],[:unidade]} AND $P{[localTrabalho],[l],[:localTrabalho]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[horasSemanal],[t.horasSemanal],[:horasSemanal]} AND $P{[data], [p.data], [:data]} ";
    private final Integer matricula;
    private final Short contrato;
    private final String nome;
    private final String cargo;
    private final Date data;
    private final String entrada1;
    private final String saida1;
    private final String entrada2;
    private final String saida2;
    private final String entrada3;
    private final String saida3;
    private final String divisao;
    private final String subdivisao;
    private final String unidade;
    private final String localTrabalho;
    private final PontoSituacao pontoSituacao;
    private final Boolean feriado;
    private final Boolean pontoFacultativo;

    public RelacaoBatidasEmBrancoVo(Integer matricula, Short contrato, String nome, String cargo, Date data, String entrada1, String saida1, String entrada2, String saida2, String entrada3, String saida3, String divisao, String subdivisao, String unidade, String localTrabalho, Short pontoSituacaoCodigo, Boolean feriado, Boolean pontoFacultativo) {
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.cargo = cargo;
        this.data = data;
        this.entrada1 = entrada1;
        this.saida1 = saida1;
        this.entrada2 = entrada2;
        this.saida2 = saida2;
        this.entrada3 = entrada3;
        this.saida3 = saida3;
        this.divisao = divisao;
        this.subdivisao = subdivisao;
        this.unidade = unidade;
        this.localTrabalho = localTrabalho;
        this.pontoSituacao = PontoSituacao.of(pontoSituacaoCodigo);
        this.feriado = feriado;
        this.pontoFacultativo = pontoFacultativo;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public String getCargo() {
        return this.cargo;
    }

    public Date getData() {
        return this.data;
    }

    public String getEntrada1() {
        return this.entrada1;
    }

    public String getSaida1() {
        return this.saida1;
    }

    public String getEntrada2() {
        return this.entrada2;
    }

    public String getSaida2() {
        return this.saida2;
    }

    public String getEntrada3() {
        return this.entrada3;
    }

    public String getSaida3() {
        return this.saida3;
    }

    public String getDivisao() {
        return this.divisao;
    }

    public String getSubdivisao() {
        return this.subdivisao;
    }

    public String getUnidade() {
        return this.unidade;
    }

    public String getLocalTrabalho() {
        return this.localTrabalho;
    }

    public PontoSituacao getPontoSituacao() {
        return this.pontoSituacao;
    }

    public Boolean getFeriado() {
        return this.feriado;
    }

    public Boolean getPontoFacultativo() {
        return this.pontoFacultativo;
    }
}

