/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.model.FilterEntity;
import br.com.fiorilli.filter.model.FilterModel;
import br.com.fiorilli.sip.persistence.vo.EntidadeMinVo;
import br.com.fiorilli.sip.persistence.vo.reports.ReportOptions;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class RelacaoBatidasEmBrancoParameters {
    private EntidadeMinVo entidade;
    private FilterEntity filterEntity;
    private ReportOptions[] groupBy;
    private ReportOptions[] newPageOn;
    private ReportOptions orderBy = ReportOptions.ALFABETICA;
    private Boolean batidaEmBrancoJustificada = false;
    private Horarios[] horarios = new Horarios[]{Horarios.E1, Horarios.S1, Horarios.E2, Horarios.S2};

    public ReportOptions[] getAllGroupBy() {
        ReportOptions[] all = new ReportOptions[]{ReportOptions.DIVISAO, ReportOptions.SUBDIVISAO, ReportOptions.UNIDADE, ReportOptions.LOCAL_TRABALHO};
        return all;
    }

    public ReportOptions[] getAllNewPageOn() {
        ReportOptions[] all = new ReportOptions[]{ReportOptions.DIVISAO, ReportOptions.SUBDIVISAO, ReportOptions.UNIDADE, ReportOptions.LOCAL_TRABALHO};
        return all;
    }

    public ReportOptions[] getAllOrderBy() {
        ReportOptions[] all = new ReportOptions[]{ReportOptions.REGISTRO, ReportOptions.MATRICULA, ReportOptions.ALFABETICA};
        return all;
    }

    public Horarios[] getAllHorarios() {
        return Horarios.values();
    }

    public String getOrderBySql() {
        StringBuilder sb = new StringBuilder("ORDER BY ");
        if (ArrayUtils.isNotEmpty((Object[])this.getGroupBy())) {
            block9: for (ReportOptions r : this.getGroupBy()) {
                switch (r) {
                    case DIVISAO: {
                        sb.append("t.divisao, ");
                        continue block9;
                    }
                    case SUBDIVISAO: {
                        sb.append("t.subdivisao, ");
                        continue block9;
                    }
                    case UNIDADE: {
                        sb.append("t.unidade, ");
                        continue block9;
                    }
                    default: {
                        sb.append("t.localTrabalho, ");
                    }
                }
            }
        }
        if (this.getOrderBy() != null) {
            switch (this.getOrderBy()) {
                case REGISTRO: {
                    sb.append("t.trabalhadorPK.registro ");
                    break;
                }
                case MATRICULA: {
                    sb.append("t.matricula ");
                    break;
                }
                default: {
                    sb.append("t.nome ");
                }
            }
        }
        return sb.toString();
    }

    public String getWhereConditionByHorario() {
        StringBuilder sb = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])this.getHorarios())) {
            if (!ArrayUtils.contains((Object[])this.getHorarios(), (Object)((Object)Horarios.SAB))) {
                sb.append(String.format("AND p.diaSemana <> '%s' ", Horarios.SAB.getAtributo()));
            }
            if (!ArrayUtils.contains((Object[])this.getHorarios(), (Object)((Object)Horarios.DOM))) {
                sb.append(String.format("AND p.diaSemana <> '%s' ", Horarios.DOM.getAtributo()));
            }
            if (!Horarios.hasOnlySabadoOrDomingo(this.getHorarios())) {
                sb.append(" AND (");
                boolean primeiraCondicao = Boolean.TRUE;
                if (Horarios.hasEntrada1(this.getHorarios())) {
                    sb.append(" (COALESCE(p.entrada1,'') = '' ");
                    if (Horarios.hasSaida1(this.getHorarios())) {
                        sb.append(" OR COALESCE(p.saida1,'') = '' ");
                    }
                    sb.append(") ");
                    primeiraCondicao = Boolean.FALSE;
                } else if (Horarios.hasSaida1(this.getHorarios())) {
                    sb.append(" (COALESCE(p.saida1,'') = '' ");
                    sb.append(") ");
                    primeiraCondicao = Boolean.FALSE;
                }
                if (Horarios.hasEntrada2(this.getHorarios())) {
                    if (!primeiraCondicao) {
                        sb.append(" OR ");
                        primeiraCondicao = Boolean.FALSE;
                    }
                    sb.append(" ( ");
                    sb.append(" (COALESCE(p.entrada2,'') = '' ");
                    if (Horarios.hasSaida2(this.getHorarios())) {
                        sb.append(" OR COALESCE(p.saida2,'') = '' ");
                    }
                    sb.append(" ) ");
                    sb.append(" AND jd.periodo2 = 'S') ");
                } else if (Horarios.hasSaida2(this.getHorarios())) {
                    if (!primeiraCondicao) {
                        sb.append(" OR ");
                        primeiraCondicao = Boolean.FALSE;
                    }
                    sb.append(" ( ");
                    sb.append(" (COALESCE(p.saida2,'') = '' ");
                    sb.append(" AND jd.periodo2 = 'S') ");
                    sb.append(") ");
                }
                if (Horarios.hasEntrada3(this.getHorarios())) {
                    if (!primeiraCondicao) {
                        sb.append(" OR ");
                        primeiraCondicao = Boolean.FALSE;
                    }
                    sb.append(" ( ");
                    sb.append(" (COALESCE(p.entrada3,'') = '' ");
                    if (Horarios.hasSaida3(this.getHorarios())) {
                        sb.append(" OR COALESCE(p.saida3,'') = '' ");
                    }
                    sb.append(" ) ");
                    sb.append(" AND jd.periodo3 = 'S') ");
                } else if (Horarios.hasSaida3(this.getHorarios())) {
                    if (!primeiraCondicao) {
                        sb.append(" OR ");
                        primeiraCondicao = Boolean.FALSE;
                    }
                    sb.append(" ( ");
                    sb.append(" (COALESCE(p.saida3,'') = '' ");
                    sb.append(" AND jd.periodo3 = 'S') ");
                    sb.append(") ");
                }
                sb.append(" ) ");
            }
            if (!this.batidaEmBrancoJustificada.booleanValue()) {
                sb.append(String.format("AND p.situacao NOT IN ('2', '3', '4', '5') ", Horarios.DOM.getAtributo()));
            }
        }
        return sb.toString();
    }

    public Map<String, Object> getReportParameters() {
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("ENTIDADE", this.getEntidade());
        if (ArrayUtils.isNotEmpty((Object[])this.getGroupBy())) {
            p.put("GROUP_BY", Arrays.asList(this.getGroupBy()));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.getNewPageOn())) {
            p.put("NEW_PAGE_ON", Arrays.asList(this.getNewPageOn()));
        }
        p.put("BATIDAS_JUSTIFICADAS", this.batidaEmBrancoJustificada);
        for (FilterModel m : this.getFilterEntity().getModels()) {
            if (!"data".equals(m.getName())) continue;
            if (m.getCondition().isIntervalo()) {
                p.put("PERIODO_FIM", m.getValue2());
            }
            if (!(m.getValue() instanceof Date)) continue;
            p.put("PERIODO_INICIO", m.getValue());
        }
        return p;
    }

    public FilterEntity getFilterEntity() {
        return this.filterEntity;
    }

    public void setFilterEntity(FilterEntity filterEntity) {
        this.filterEntity = filterEntity;
    }

    public ReportOptions[] getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(ReportOptions[] groupBy) {
        this.groupBy = groupBy;
    }

    public ReportOptions[] getNewPageOn() {
        return this.newPageOn;
    }

    public void setNewPageOn(ReportOptions[] newPageOn) {
        this.newPageOn = newPageOn;
    }

    public ReportOptions getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(ReportOptions orderBy) {
        this.orderBy = orderBy;
    }

    public Horarios[] getHorarios() {
        return this.horarios;
    }

    public void setHorarios(Horarios[] horarios) {
        this.horarios = horarios;
    }

    public EntidadeMinVo getEntidade() {
        return this.entidade;
    }

    public void setEntidade(EntidadeMinVo entidade) {
        this.entidade = entidade;
    }

    public Boolean getBatidaEmBrancoJustificada() {
        return this.batidaEmBrancoJustificada;
    }

    public void setBatidaEmBrancoJustificada(Boolean batidaEmBrancoJustificada) {
        this.batidaEmBrancoJustificada = batidaEmBrancoJustificada;
    }

    public static enum Horarios {
        E1("Entrada 1 ou", "entrada1"),
        S1("Sa\u00edda 1 ou", "saida1"),
        E2("Entrada 2 ou", "entrada2"),
        S2("Sa\u00edda 2 ou", "saida2"),
        E3("Entrada 3 ou ", "entrada3"),
        S3("Sa\u00edda 3 ", "saida3"),
        SAB("S\u00e1bado", "s\u00e1b"),
        DOM("Domingo", "dom");

        private final String descricao;
        private final String atributo;

        private Horarios(String descricao, String atributo) {
            this.descricao = descricao;
            this.atributo = atributo;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getAtributo() {
            return this.atributo;
        }

        public boolean isEntradaOrSaida() {
            return !this.equals((Object)SAB) && !this.equals((Object)DOM);
        }

        public static boolean hasEntrada1(Horarios[] horarios) {
            for (Horarios horario : horarios) {
                if (horario != E1) continue;
                return true;
            }
            return false;
        }

        public static boolean hasSaida1(Horarios[] horarios) {
            for (Horarios horario : horarios) {
                if (horario != S1) continue;
                return true;
            }
            return false;
        }

        public static boolean hasEntrada2(Horarios[] horarios) {
            for (Horarios horario : horarios) {
                if (horario != E2) continue;
                return true;
            }
            return false;
        }

        public static boolean hasSaida2(Horarios[] horarios) {
            for (Horarios horario : horarios) {
                if (horario != S2) continue;
                return true;
            }
            return false;
        }

        public static boolean hasEntrada3(Horarios[] horarios) {
            for (Horarios horario : horarios) {
                if (horario != E3) continue;
                return true;
            }
            return false;
        }

        public static boolean hasSaida3(Horarios[] horarios) {
            for (Horarios horario : horarios) {
                if (horario != S3) continue;
                return true;
            }
            return false;
        }

        public static boolean hasOnlySabadoOrDomingo(Horarios[] horarios) {
            for (Horarios horario : horarios) {
                if (horario == SAB || horario == DOM) continue;
                return false;
            }
            return true;
        }
    }
}

