/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.math.BigDecimal;
import java.util.Date;

@FilterConfigType(query="SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasDuplicadasVo(tr.matricula, tr.contrato, tr.nome, pt.data, pt.entrada1, pt.saida1, pt.entrada2, pt.saida2, pt.entrada3, pt.saida3) FROM Ponto pt LEFT JOIN pt.trabalhador tr WHERE pt.entidadeCodigo = :entidadeCodigo AND pt.referenciaCodigo = :referenciaCodigo AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[unidade],[tr.unidade],[:unidade]} AND $P{[vinculo],[tr.vinculo],[:vinculo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]} AND $P{[horasSemanal],[tr.horasSemanal],[:horasSemanal]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND ( pt.entrada1 <> '' AND pt.saida1 <> '' AND substring(pt.entrada1, 1, 2) = substring(pt.saida1, 1, 2) OR pt.entrada2 <> '' AND pt.saida2 <> '' AND substring(pt.entrada2, 1, 2) = substring(pt.saida2, 1, 2) OR pt.entrada3 <> '' AND pt.saida3 <> '' AND substring(pt.entrada3, 1, 2) = substring(pt.saida3, 1, 2) ) ORDER BY tr.matricula, pt.data")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Dt. Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasSemanal", label="Horas Semanal", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasMes", label="Horas M\u00eas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Sal\u00e1rio", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo")})
public class RelacaoBatidasDuplicadasVo {
    public static final String QUERY = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasDuplicadasVo(tr.matricula, tr.contrato, tr.nome, pt.data, pt.entrada1, pt.saida1, pt.entrada2, pt.saida2, pt.entrada3, pt.saida3) FROM Ponto pt LEFT JOIN pt.trabalhador tr WHERE pt.entidadeCodigo = :entidadeCodigo AND pt.referenciaCodigo = :referenciaCodigo AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[unidade],[tr.unidade],[:unidade]} AND $P{[vinculo],[tr.vinculo],[:vinculo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]} AND $P{[horasSemanal],[tr.horasSemanal],[:horasSemanal]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND ( pt.entrada1 <> '' AND pt.saida1 <> '' AND substring(pt.entrada1, 1, 2) = substring(pt.saida1, 1, 2) OR pt.entrada2 <> '' AND pt.saida2 <> '' AND substring(pt.entrada2, 1, 2) = substring(pt.saida2, 1, 2) OR pt.entrada3 <> '' AND pt.saida3 <> '' AND substring(pt.entrada3, 1, 2) = substring(pt.saida3, 1, 2) ) ORDER BY tr.matricula, pt.data";
    private Integer matricula;
    private Short contrato;
    private String nome;
    private Date data;
    private String entrada1;
    private String saida1;
    private String entrada2;
    private String saida2;
    private String entrada3;
    private String saida3;

    public RelacaoBatidasDuplicadasVo(Integer matricula, Short contrato, String nome, Date data, String entrada1, String saida1, String entrada2, String saida2, String entrada3, String saida3) {
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.data = data;
        this.entrada1 = entrada1;
        this.saida1 = saida1;
        this.entrada2 = entrada2;
        this.saida2 = saida2;
        this.entrada3 = entrada3;
        this.saida3 = saida3;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getEntrada1() {
        return this.entrada1;
    }

    public String getSaida1() {
        return this.saida1;
    }

    public String getEntrada2() {
        return this.entrada2;
    }

    public String getSaida2() {
        return this.saida2;
    }

    public String getEntrada3() {
        return this.entrada3;
    }

    public String getSaida3() {
        return this.saida3;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getData() {
        return this.data;
    }
}

