/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.math.BigDecimal;
import java.util.Date;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="Vinculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasSemanal", label="Horas Semanal", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=BigDecimal.class, id="horasMes", label="Horas M\u00eas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Sal\u00e1rio", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano")})
public class RelacaoBatidasAcimaEsperadoVo {
    public static final String QUERY = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBatidasAcimaEsperadoVo(tr.matricula, tr.contrato, tr.nome, pb.data, COUNT(pb.shora)) FROM PontoAfdBatidas pb LEFT JOIN pb.trabalhador tr LEFT JOIN tr.vinculo v LEFT JOIN tr.divisao d LEFT JOIN tr.subdivisao s LEFT JOIN tr.unidade u LEFT JOIN tr.localTrabalho l WHERE pb.entidadeCodigo = :entidadeCodigo AND pb.data BETWEEN :periodoInicio AND :periodoFim AND $P{[vinculo],[v],[:vinculo]} AND $P{[divisao],[d],[:divisao]} AND $P{[subdivisao],[s],[:subdivisao]} AND $P{[unidade],[u],[:unidade]} AND $P{[horasSemanal],[tr.horasSemanal],[:horasSemanal]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} AND $P{[localTrabalho],[l],[:localTrabalho]} GROUP BY tr.matricula, tr.contrato, tr.nome, pb.data HAVING COUNT(pb.shora) > :quantidadeMaxima ";
    private Integer matricula;
    private Short contrato;
    private String nome;
    private Date data;
    private Long quantidade;

    public RelacaoBatidasAcimaEsperadoVo(Integer matricula, Short contrato, String nome, Date data, Long quantidade) {
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.data = data;
        this.quantidade = quantidade;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getData() {
        return this.data;
    }

    public Long getQuantidade() {
        return this.quantidade;
    }
}

