/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Evento;
import java.util.Date;

@FilterConfigType(query="SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBancoHorasSinteticoVo(s.sipbhParametros.codigo, v.dataVigenciaInicio, v.dataVigenciaTermino, s.trabalhador.trabalhadorPK.registro, t.matricula, t.contrato, t.nome as nomeTrabalhador, t.dataAdmissao, t.tipoCargoAtual, COALESCE(c.nome, ca.nome) as nomeCargo, COALESCE(b.divisaoCodigo, t.divisaoCodigo), SUM(s.horas) as saldo, CAST(null as string) as credito, CAST(null as string) as debito) FROM BancoHoraMovimento s LEFT JOIN s.trabalhador t INNER JOIN t.cargoAtual ca LEFT JOIN s.referencia r LEFT JOIN s.bases b LEFT JOIN s.eventos e LEFT JOIN b.cargo c LEFT JOIN r.mes m LEFT JOIN s.sipbhParametros v WHERE s.sipbhParametros.entidadeCodigo = :entidadeCodigo AND s.pk.vigencia = :vigencia AND $P{[eventos], [s.eventos], [:eventos]} AND $P{[data],[s.pk.data],[:data]} AND $P{[nomeEvento], [e.nome], [:nomeEvento]} AND $P{[matricula], [t.matricula], [:matricula]} AND $P{[contrato], [t.contrato], [:contrato]} AND $P{[nomeTrabalhador], [t.nome], [:nomeTrabalhador]} AND $P{[dataAdmissao], [t.dataAdmissao], [:dataAdmissao]} AND $P{[cargoAtual], [t.cargoAtualCodigo], [:cargoAtual]} AND $P{[nomeCargo], [c.nome], [:nomeCargo]} AND $P{[divisaoCodigo], [t.divisaoCodigo], [:divisaoCodigo]} GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 ORDER BY t.nome ")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Date.class, id="data", label="Data", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO, order=1, required=true, requiredMessage="Informe o intervalo da Data."), @FilterConfigParameter(fieldClass=Evento.class, id="eventos", label="Evento", inputType=FilterInputType.AUTO_COMPLETE, condition=FilterCondition.COMECE, order=2, query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome"), @FilterConfigParameter(fieldClass=String.class, id="nomeEvento", label="Nome Evento", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=3), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=4), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=5), @FilterConfigParameter(fieldClass=String.class, id="nomeTrabalhador", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=6), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Dt. Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=String.class, id="cargoAtual", label="Cargo Atual", inputType=FilterInputType.TEXT, condition=FilterCondition.IGUAL), @FilterConfigParameter(fieldClass=String.class, id="nomeCargo", label="Cargo Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE), @FilterConfigParameter(fieldClass=String.class, id="divisaoCodigo", label="Divis\u00e3o", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=9)})
public class RelacaoBancoHorasSinteticoVo {
    public static final String SELECT = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoBancoHorasSinteticoVo(s.sipbhParametros.codigo, v.dataVigenciaInicio, v.dataVigenciaTermino, s.trabalhador.trabalhadorPK.registro, t.matricula, t.contrato, t.nome as nomeTrabalhador, t.dataAdmissao, t.tipoCargoAtual, COALESCE(c.nome, ca.nome) as nomeCargo, COALESCE(b.divisaoCodigo, t.divisaoCodigo), SUM(s.horas) as saldo, CAST(null as string) as credito, CAST(null as string) as debito) FROM BancoHoraMovimento s LEFT JOIN s.trabalhador t INNER JOIN t.cargoAtual ca LEFT JOIN s.referencia r LEFT JOIN s.bases b LEFT JOIN s.eventos e LEFT JOIN b.cargo c LEFT JOIN r.mes m LEFT JOIN s.sipbhParametros v WHERE s.sipbhParametros.entidadeCodigo = :entidadeCodigo AND s.pk.vigencia = :vigencia AND $P{[eventos], [s.eventos], [:eventos]} AND $P{[data],[s.pk.data],[:data]} AND $P{[nomeEvento], [e.nome], [:nomeEvento]} AND $P{[matricula], [t.matricula], [:matricula]} AND $P{[contrato], [t.contrato], [:contrato]} AND $P{[nomeTrabalhador], [t.nome], [:nomeTrabalhador]} AND $P{[dataAdmissao], [t.dataAdmissao], [:dataAdmissao]} AND $P{[cargoAtual], [t.cargoAtualCodigo], [:cargoAtual]} AND $P{[nomeCargo], [c.nome], [:nomeCargo]} AND $P{[divisaoCodigo], [t.divisaoCodigo], [:divisaoCodigo]} GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 ORDER BY t.nome ";
    private final Integer codigo;
    private final Date dataVigenciaInicio;
    private final Date dataVigenciaTermino;
    private final String registro;
    private final Integer matricula;
    private final Short contrato;
    private final String nomeTrabalhador;
    private final Date dataAdmissao;
    private final String tipoCargoAtual;
    private final String nomeCargo;
    private final String divisaoCodigo;
    private final Double saldo;
    private String credito;
    private String debito;

    public RelacaoBancoHorasSinteticoVo(Integer codigo, Date dataVigenciaInicio, Date dataVigenciaTermino, String registro, Integer matricula, Short contrato, String nomeTrabalhador, Date dataAdmissao, String tipoCargoAtual, String nomeCargo, String divisaoCodigo, Double saldo, String credito, String debito) {
        this.codigo = codigo;
        this.dataVigenciaInicio = dataVigenciaInicio;
        this.dataVigenciaTermino = dataVigenciaTermino;
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nomeTrabalhador = nomeTrabalhador;
        this.dataAdmissao = dataAdmissao;
        this.tipoCargoAtual = tipoCargoAtual;
        this.nomeCargo = nomeCargo;
        this.divisaoCodigo = divisaoCodigo;
        this.saldo = saldo;
        this.credito = credito;
        this.debito = debito;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public Date getDataVigenciaInicio() {
        return this.dataVigenciaInicio;
    }

    public Date getDataVigenciaTermino() {
        return this.dataVigenciaTermino;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNomeTrabalhador() {
        return this.nomeTrabalhador;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public String getTipoCargoAtual() {
        return this.tipoCargoAtual;
    }

    public String getNomeCargo() {
        return this.nomeCargo;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public Double getSaldo() {
        return this.saldo;
    }

    public String getCredito() {
        return this.credito;
    }

    public String getDebito() {
        return this.debito;
    }

    public void setCredito(String credito) {
        this.credito = credito;
    }

    public void setDebito(String debito) {
        this.debito = debito;
    }
}

