/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Evento;
import java.util.Date;

@FilterConfigType(query="select new br.com.fiorilli.sip.persistence.vo.reports.RelacaoBancoHorasAnaliticoVo(\ts.sipbhParametros.codigo as codigo, \tv.dataVigenciaInicio as dataVigenciaInicio, \tv.dataVigenciaTermino as dataVigenciaTermino, \ts.pk.data as data, \ts.pk.evento as evento, \ts.horas as horas, \ts.trabalhador.trabalhadorPK.registro as registro, \tt.matricula as matricula, \tt.contrato as contrato, \tt.nome as nome, \tt.dataAdmissao as dataAdmissao, \tt.tipoCargoAtual as tipoCargoAtual, \tCOALESCE(c.nome, ca.nome) as nomeCargo, \te.nome as nomeEvento, \tr.mesCodigo as mesCodigo, \tr.ano as ano, \tCOALESCE(b.divisaoCodigo, t.divisaoCodigo) as divisaoCodigo, \tsum(s.horas) as saldo ) from BancoHoraMovimento s left join s.trabalhador t INNER JOIN  t.cargoAtual ca left join s.bases b left join s.referencia r left join s.eventos e left join b.cargo c left join r.mes m left join m.meses ms left join s.sipbhParametros v where s.sipbhParametros.entidadeCodigo = :entidadeCodigo and s.pk.vigencia = :vigencia and $P{[data],[s.pk.data],[:data]} and $P{[eventos],[s.eventos],[:eventos]} and $P{[nomeEvento],[e.nome],[:nomeEvento]} and $P{[matricula],[t.matricula],[:matricula]} and $P{[contrato],[t.contrato],[:contrato]} and $P{[nomeTrabalhador],[t.nome],[:nomeTrabalhador]} and $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} and $P{[cargoAtual],[t.cargoAtual.nome],[:cargoAtual]} and $P{[nomeCargo],[c.nome],[:nomeCargo]} and $P{[mes],[r.mesCodigo],[:mes]} and $P{[ano],[r.ano],[:ano]} and $P{[nomeDivisao],[b.divisao.nome],[:nomeDivisao]} group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 order by t.nome, s.pk.data ")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Date.class, id="data", label="Data", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO, order=1, required=true, requiredMessage="Informe o intervalo da Data."), @FilterConfigParameter(fieldClass=Evento.class, id="eventos", label="Evento", inputType=FilterInputType.AUTO_COMPLETE, condition=FilterCondition.COMECE, order=2, query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome"), @FilterConfigParameter(fieldClass=String.class, id="nomeEvento", label="Nome Evento", inputType=FilterInputType.TEXT, condition=FilterCondition.IGUAL, order=3), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=4), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL, order=5), @FilterConfigParameter(fieldClass=String.class, id="nomeTrabalhador", label="Nome Trabalhador", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=6), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Data Admiss\u00e3o", inputType=FilterInputType.CALENDAR, condition=FilterCondition.IGUAL, order=7), @FilterConfigParameter(fieldClass=String.class, id="cargoAtual", label="Cargo Atual", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=8), @FilterConfigParameter(fieldClass=String.class, id="nomeCargo", label="Nome Cargo", inputType=FilterInputType.TEXT, condition=FilterCondition.IGUAL, order=9), @FilterConfigParameter(fieldClass=String.class, id="mes", label="M\u00eas", inputType=FilterInputType.TEXT, condition=FilterCondition.IGUAL, order=10), @FilterConfigParameter(fieldClass=String.class, id="ano", label="Ano", inputType=FilterInputType.TEXT, condition=FilterCondition.IGUAL, order=11), @FilterConfigParameter(fieldClass=String.class, id="nomeDivisao", label="Divis\u00e3o", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE)})
public class RelacaoBancoHorasAnaliticoVo {
    public static final String QUERY = "select new br.com.fiorilli.sip.persistence.vo.reports.RelacaoBancoHorasAnaliticoVo(\ts.sipbhParametros.codigo as codigo, \tv.dataVigenciaInicio as dataVigenciaInicio, \tv.dataVigenciaTermino as dataVigenciaTermino, \ts.pk.data as data, \ts.pk.evento as evento, \ts.horas as horas, \ts.trabalhador.trabalhadorPK.registro as registro, \tt.matricula as matricula, \tt.contrato as contrato, \tt.nome as nome, \tt.dataAdmissao as dataAdmissao, \tt.tipoCargoAtual as tipoCargoAtual, \tCOALESCE(c.nome, ca.nome) as nomeCargo, \te.nome as nomeEvento, \tr.mesCodigo as mesCodigo, \tr.ano as ano, \tCOALESCE(b.divisaoCodigo, t.divisaoCodigo) as divisaoCodigo, \tsum(s.horas) as saldo ) from BancoHoraMovimento s left join s.trabalhador t INNER JOIN  t.cargoAtual ca left join s.bases b left join s.referencia r left join s.eventos e left join b.cargo c left join r.mes m left join m.meses ms left join s.sipbhParametros v where s.sipbhParametros.entidadeCodigo = :entidadeCodigo and s.pk.vigencia = :vigencia and $P{[data],[s.pk.data],[:data]} and $P{[eventos],[s.eventos],[:eventos]} and $P{[nomeEvento],[e.nome],[:nomeEvento]} and $P{[matricula],[t.matricula],[:matricula]} and $P{[contrato],[t.contrato],[:contrato]} and $P{[nomeTrabalhador],[t.nome],[:nomeTrabalhador]} and $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} and $P{[cargoAtual],[t.cargoAtual.nome],[:cargoAtual]} and $P{[nomeCargo],[c.nome],[:nomeCargo]} and $P{[mes],[r.mesCodigo],[:mes]} and $P{[ano],[r.ano],[:ano]} and $P{[nomeDivisao],[b.divisao.nome],[:nomeDivisao]} group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 order by t.nome, s.pk.data ";
    public static final String QUERY_JPA = "select new br.com.fiorilli.sip.persistence.vo.reports.RelacaoBancoHorasAnaliticoVo(     s.sipbhParametros.codigo,     v.dataVigenciaInicio,     v.dataVigenciaTermino,     s.pk.data,     s.pk.evento,     s.horas,     s.trabalhador.trabalhadorPK.registro,     t.matricula,     t.contrato,     t.nome,     t.dataAdmissao,     t.tipoCargoAtual,     COALESCE(c.nome, ca.nome),     e.nome,     r.mesCodigo,     r.ano,     COALESCE(b.divisaoCodigo, t.divisaoCodigo),     sum(s.horas) ) from BancoHoraMovimento s left join s.trabalhador t inner join t.cargoAtual ca left join s.bases b left join s.referencia r left join s.eventos e left join b.cargo c left join r.mes m left join m.meses ms left join s.sipbhParametros v where s.sipbhParametros.entidadeCodigo = :entidadeCodigo   and s.pk.vigencia = :vigencia   and (:dataFim is null or s.pk.data <= :dataFim)   and (t.trabalhadorPK.registro = :registro) group by     s.sipbhParametros.codigo,     v.dataVigenciaInicio,     v.dataVigenciaTermino,     s.pk.data,     s.pk.evento,     s.horas,     s.trabalhador.trabalhadorPK.registro,     t.matricula,     t.contrato,     t.nome,     t.dataAdmissao,     t.tipoCargoAtual,     COALESCE(c.nome, ca.nome),     e.nome,     r.mesCodigo,     r.ano,     COALESCE(b.divisaoCodigo, t.divisaoCodigo) order by t.nome, s.pk.data";
    private final Integer codigo;
    private final Date dataVigenciaInicio;
    private final Date dataVigenciaTermino;
    private final Date data;
    private final String evento;
    private final Double horas;
    private final String registro;
    private final Integer matricula;
    private final Short contrato;
    private final String nome;
    private final Date dataAdmissao;
    private final String tipoCargoAtual;
    private final String nomeCargo;
    private final String nomeEvento;
    private final String mesCodigo;
    private final String ano;
    private final String divisaoCodigo;
    private String credito;
    private String debito;
    private String somaSaldo;
    private Double saldo;

    public RelacaoBancoHorasAnaliticoVo(Integer codigo, Date dataVigenciaInicio, Date dataVigenciaTermino, Date data, String evento, Double horas, String registro, Integer matricula, Short contrato, String nome, Date dataAdmissao, String tipoCargoAtual, String nomeCargo, String nomeEvento, String mesCodigo, String ano, String divisaoCodigo, Double saldo) {
        this.codigo = codigo;
        this.dataVigenciaInicio = dataVigenciaInicio;
        this.dataVigenciaTermino = dataVigenciaTermino;
        this.data = data;
        this.evento = evento;
        this.horas = horas;
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.dataAdmissao = dataAdmissao;
        this.tipoCargoAtual = tipoCargoAtual;
        this.nomeCargo = nomeCargo;
        this.nomeEvento = nomeEvento;
        this.mesCodigo = mesCodigo;
        this.ano = ano;
        this.divisaoCodigo = divisaoCodigo;
        this.saldo = saldo;
    }

    public String getCredito() {
        return this.credito;
    }

    public void setCredito(String credito) {
        this.credito = credito;
    }

    public String getDebito() {
        return this.debito;
    }

    public void setDebito(String debito) {
        this.debito = debito;
    }

    public String getSomaSaldo() {
        return this.somaSaldo;
    }

    public void setSomaSaldo(String somaSaldo) {
        this.somaSaldo = somaSaldo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public Date getDataVigenciaInicio() {
        return this.dataVigenciaInicio;
    }

    public Date getDataVigenciaTermino() {
        return this.dataVigenciaTermino;
    }

    public Date getData() {
        return this.data;
    }

    public String getEvento() {
        return this.evento;
    }

    public Double getHoras() {
        return this.horas;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public String getTipoCargoAtual() {
        return this.tipoCargoAtual;
    }

    public String getNomeCargo() {
        return this.nomeCargo;
    }

    public String getNomeEvento() {
        return this.nomeEvento;
    }

    public String getMesCodigo() {
        return this.mesCodigo;
    }

    public String getAno() {
        return this.ano;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public Double getSaldo() {
        return this.saldo;
    }

    public void setSaldo(Double saldo) {
        this.saldo = saldo;
    }
}

