/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorSituacao;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.util.Date;

@FilterConfigType(query="SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoAssinaturasVo( \nt.matricula, t.contrato, t.nome, COALESCE(b.liquido, 0.0), b.divisaoCodigo, d.nome, \nb.subdivisaoCodigo, s.nome, u.departamentoDespesa, u.nome, b.localTrabalhoCodigo, l.nome) FROM Referencia r \nLEFT JOIN r.basesList b \nLEFT JOIN b.trabalhador t \nLEFT JOIN b.unidade u \nLEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.localTrabalho l \nWHERE r.entidadeCodigo = :entidadeCodigo AND r.ano = :ano AND r.mesCodigo = :mes AND r.tipo = :tipoReferencia \n AND \n$P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[trabalhadorNome],[t],[:trabalhadorNome]} AND $P{[dataAdmissao],[t.dtAdmissao],[:dataAdmissao]} AND $P{[dataDemissao],[t.dtDemissao],[:dataDemissao]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[cargoCodigo],[t.cargoAtual.cargoPK.codigo],[:cargoCodigo]} AND $P{[cargoNome],[b.cargo],[:cargoNome]} AND $P{[divisaoCodigo],[t.divisao.divisaoPK.codigo],[:divisaoCodigo]} AND $P{[divisaoNome],[b.divisao],[:divisaoNome]} AND $P{[subdivisaoCodigo],[t.subdivisao.subdivisaoPK.codigo],[:subdivisaoCodigo]} AND $P{[subdivisaoNome],[b.subdivisao],[:subdivisaoNome]} AND $P{[unidadeCodigo],[t.unidade.codigo],[:unidadeCodigo]} AND $P{[unidadeNome],[b.unidade],[:unidadeNome]} AND $P{[localTrabalhoCodigo],[t.localTrabalho.localTrabalhoPK.codigo],[:localTrabalhoCodigo]} AND $P{[localTrabalhoNome],[b.localTrabalho],[:localTrabalhoNome]} AND $P{[vinculoCodigo],[t.vinculo.vinculoPK.codigo],[:vinculoCodigo]} AND $P{[vinculoNome],[b.vinculo],[:vinculoNome]} AND $P{[cestaBasica],[t.cestaBasica],[:cestaBasica]} AND $P{[liquido],[b.liquido],[:liquido]} ")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro"), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matricula", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.DECIMAL), @FilterConfigParameter(fieldClass=Trabalhador.class, id="trabalhadorNome", label="Nome", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Dt. Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Date.class, id="dataDemissao", label="Dt. Demiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=String.class, id="situacao", label="Situa\u00e7\u00e3o", inputType=FilterInputType.SELECT_ONE_MENU, enumClass=TrabalhadorSituacao.class, enumId="codigo", enumLabel="descricao"), @FilterConfigParameter(fieldClass=String.class, id="cargoCodigo", label="Cargo C\u00f3digo"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargoNome", label="Cargo Nome", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=String.class, id="divisaoCodigo", label="Divis\u00e3o C\u00f3digo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisaoNome", label="Divis\u00e3o Nome", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="subdivisaoCodigo", label="Subdivis\u00e3o C\u00f3digo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisaoNome", label="Subdivis\u00e3o Nome", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="unidadeCodigo", label="Unidade C\u00f3digo"), @FilterConfigParameter(fieldClass=Unidade.class, id="unidadeNome", label="Unidade Nome", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano"), @FilterConfigParameter(fieldClass=String.class, id="localTrabalhoCodigo", label="Local Trabalho C\u00f3digo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalhoNome", label="Local Trabalho Nome", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="vinculoCodigo", label="V\u00ednculo C\u00f3digo"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculoNome", label="V\u00ednculo Nome", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Boolean.class, id="cestaBasica", label="Cesta B\u00e1sica", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=Double.class, id="liquido", label="L\u00edquido", inputType=FilterInputType.NUMBER)})
public class RelacaoAssinaturasVo {
    public static final String QUERY = "SELECT NEW br.com.fiorilli.sip.persistence.vo.reports.RelacaoAssinaturasVo( \nt.matricula, t.contrato, t.nome, COALESCE(b.liquido, 0.0), b.divisaoCodigo, d.nome, \nb.subdivisaoCodigo, s.nome, u.departamentoDespesa, u.nome, b.localTrabalhoCodigo, l.nome) FROM Referencia r \nLEFT JOIN r.basesList b \nLEFT JOIN b.trabalhador t \nLEFT JOIN b.unidade u \nLEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.localTrabalho l \nWHERE r.entidadeCodigo = :entidadeCodigo AND r.ano = :ano AND r.mesCodigo = :mes AND r.tipo = :tipoReferencia \n AND \n$P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[trabalhadorNome],[t],[:trabalhadorNome]} AND $P{[dataAdmissao],[t.dtAdmissao],[:dataAdmissao]} AND $P{[dataDemissao],[t.dtDemissao],[:dataDemissao]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[cargoCodigo],[t.cargoAtual.cargoPK.codigo],[:cargoCodigo]} AND $P{[cargoNome],[b.cargo],[:cargoNome]} AND $P{[divisaoCodigo],[t.divisao.divisaoPK.codigo],[:divisaoCodigo]} AND $P{[divisaoNome],[b.divisao],[:divisaoNome]} AND $P{[subdivisaoCodigo],[t.subdivisao.subdivisaoPK.codigo],[:subdivisaoCodigo]} AND $P{[subdivisaoNome],[b.subdivisao],[:subdivisaoNome]} AND $P{[unidadeCodigo],[t.unidade.codigo],[:unidadeCodigo]} AND $P{[unidadeNome],[b.unidade],[:unidadeNome]} AND $P{[localTrabalhoCodigo],[t.localTrabalho.localTrabalhoPK.codigo],[:localTrabalhoCodigo]} AND $P{[localTrabalhoNome],[b.localTrabalho],[:localTrabalhoNome]} AND $P{[vinculoCodigo],[t.vinculo.vinculoPK.codigo],[:vinculoCodigo]} AND $P{[vinculoNome],[b.vinculo],[:vinculoNome]} AND $P{[cestaBasica],[t.cestaBasica],[:cestaBasica]} AND $P{[liquido],[b.liquido],[:liquido]} ";
    private final Integer matricula;
    private final Short contrato;
    private final String nome;
    private final Double liquido;
    private final String divisaoCodigo;
    private final String divisaoNome;
    private final String subdivisaoCodigo;
    private final String subdivisaoNome;
    private final String departamentoDespesa;
    private final String unidadeNome;
    private final String localTrabalhoCodigo;
    private final String localTrabalhoNome;

    public RelacaoAssinaturasVo(Integer matricula, Short contrato, String nome, Double liquido, String divisaoCodigo, String divisaoNome, String subdivisaoCodigo, String subdivisaoNome, String departamentoDespesa, String unidadeNome, String localTrabalhoCodigo, String localTrabalhoNome) {
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.liquido = liquido;
        this.divisaoCodigo = divisaoCodigo;
        this.divisaoNome = divisaoNome;
        this.subdivisaoCodigo = subdivisaoCodigo;
        this.subdivisaoNome = subdivisaoNome;
        this.departamentoDespesa = departamentoDespesa;
        this.unidadeNome = unidadeNome;
        this.localTrabalhoCodigo = localTrabalhoCodigo;
        this.localTrabalhoNome = localTrabalhoNome;
    }

    public Double getLiquido() {
        return this.liquido;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public String getDivisaoNome() {
        return this.divisaoNome;
    }

    public String getSubdivisaoCodigo() {
        return this.subdivisaoCodigo;
    }

    public String getSubdivisaoNome() {
        return this.subdivisaoNome;
    }

    public String getDepartamentoDespesa() {
        return this.departamentoDespesa;
    }

    public String getUnidadeNome() {
        return this.unidadeNome;
    }

    public String getLocalTrabalhoCodigo() {
        return this.localTrabalhoCodigo;
    }

    public String getLocalTrabalhoNome() {
        return this.localTrabalhoNome;
    }
}

