/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.CargoNatureza;
import java.util.Objects;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="codigo", label="C\u00f3digo", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=String.class, id="nomeCargo", label="Nome Cargo", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=2), @FilterConfigParameter(fieldClass=String.class, id="naturezaCargo", label="Natureza", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Short.class, id="vagaCargo", label="Vaga Cargo", inputType=FilterInputType.NUMBER, order=4), @FilterConfigParameter(fieldClass=Short.class, id="vagaFuncao", label="Vaga Fun\u00e7\u00e3o", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Short.class, id="vagaEmprego", label="Vaga Emprego", inputType=FilterInputType.NUMBER)})
public class QuadroPessoalVO {
    private final String codigoCargo;
    private final String nomeCargo;
    private final CargoNatureza naturezaCargo;
    private Long quantidadeTotalVagasCargoEfetivo;
    private Long quantidadeTotalVagasComissaoConfianca;
    private Long quantidadeTotalVagasEmpregoEfetivo;
    private Long quantidadeTotalVagasContratoTemporario;
    private Long quantidadeVagasProvidasCargoEfetivo;
    private Long quantidadeVagasProvidasComissaoConfianca;
    private Long quantidadeVagasProvidasEmpregoEfetivo;
    private Long quantidadeVagasProvidasContratoTemporario;
    private final String codigoArea;
    private final String nomeArea;

    public QuadroPessoalVO(String codigoCargo, String nomeCargo, CargoNatureza naturezaCargo, Long totalVagasCargo, Long totalVagasFuncao, Long totalVagasEmprego, Long totalVagasContrato, Long vagasProvidasCargo, Long vagasProvidasFuncao, Long vagasProvidasEmprego, Long vagasProvidasContrato) {
        this.codigoCargo = codigoCargo;
        this.nomeCargo = nomeCargo;
        this.naturezaCargo = naturezaCargo;
        this.quantidadeTotalVagasCargoEfetivo = totalVagasCargo == null ? 0L : totalVagasCargo;
        this.quantidadeTotalVagasComissaoConfianca = totalVagasFuncao == null ? 0L : totalVagasFuncao;
        this.quantidadeTotalVagasEmpregoEfetivo = totalVagasEmprego == null ? 0L : totalVagasEmprego;
        this.quantidadeTotalVagasContratoTemporario = totalVagasContrato == null ? 0L : totalVagasContrato;
        this.quantidadeVagasProvidasCargoEfetivo = vagasProvidasCargo == null ? 0L : vagasProvidasCargo;
        this.quantidadeVagasProvidasComissaoConfianca = vagasProvidasFuncao == null ? 0L : vagasProvidasFuncao;
        this.quantidadeVagasProvidasEmpregoEfetivo = vagasProvidasEmprego == null ? 0L : vagasProvidasEmprego;
        this.quantidadeVagasProvidasContratoTemporario = vagasProvidasContrato == null ? 0L : vagasProvidasContrato;
        this.codigoArea = null;
        this.nomeArea = null;
    }

    public QuadroPessoalVO(String codigoCargo, String nomeCargo, CargoNatureza naturezaCargo, Short totalVagasCargo, Short totalVagasFuncao, Short totalVagasEmprego, Short totalVagasContrato, Long vagasProvidasCargo, Long vagasProvidasFuncao, Long vagasProvidasEmprego, Long vagasProvidasContrato, String codigoArea, String nomeArea) {
        this.codigoCargo = codigoCargo;
        this.nomeCargo = nomeCargo;
        this.naturezaCargo = naturezaCargo;
        this.quantidadeTotalVagasCargoEfetivo = totalVagasCargo == null ? 0L : (long)totalVagasCargo.shortValue();
        this.quantidadeTotalVagasComissaoConfianca = totalVagasFuncao == null ? 0L : (long)totalVagasFuncao.shortValue();
        this.quantidadeTotalVagasEmpregoEfetivo = totalVagasEmprego == null ? 0L : (long)totalVagasEmprego.shortValue();
        this.quantidadeTotalVagasContratoTemporario = totalVagasContrato == null ? 0L : (long)totalVagasContrato.shortValue();
        this.quantidadeVagasProvidasCargoEfetivo = vagasProvidasCargo == null ? 0L : vagasProvidasCargo;
        this.quantidadeVagasProvidasComissaoConfianca = vagasProvidasFuncao == null ? 0L : vagasProvidasFuncao;
        this.quantidadeVagasProvidasEmpregoEfetivo = vagasProvidasEmprego == null ? 0L : vagasProvidasEmprego;
        this.quantidadeVagasProvidasContratoTemporario = vagasProvidasContrato == null ? 0L : vagasProvidasContrato;
        this.codigoArea = codigoArea;
        this.nomeArea = nomeArea;
    }

    public QuadroPessoalVO(String codigoCargo, String nomeCargo, CargoNatureza naturezaCargo, Long totalVagasCargo, Long totalVagasFuncao, Long totalVagasEmprego, Long totalVagasContrato, Long vagasProvidasCargo, Long vagasProvidasFuncao, Long vagasProvidasEmprego, Long vagasProvidasContrato, String codigoArea, String nomeArea) {
        this.codigoCargo = codigoCargo;
        this.nomeCargo = nomeCargo;
        this.naturezaCargo = naturezaCargo;
        this.quantidadeTotalVagasCargoEfetivo = totalVagasCargo == null ? 0L : totalVagasCargo;
        this.quantidadeTotalVagasComissaoConfianca = totalVagasFuncao == null ? 0L : totalVagasFuncao;
        this.quantidadeTotalVagasEmpregoEfetivo = totalVagasEmprego == null ? 0L : totalVagasEmprego;
        this.quantidadeTotalVagasContratoTemporario = totalVagasContrato == null ? 0L : totalVagasContrato;
        this.quantidadeVagasProvidasCargoEfetivo = vagasProvidasCargo == null ? 0L : vagasProvidasCargo;
        this.quantidadeVagasProvidasComissaoConfianca = vagasProvidasFuncao == null ? 0L : vagasProvidasFuncao;
        this.quantidadeVagasProvidasEmpregoEfetivo = vagasProvidasEmprego == null ? 0L : vagasProvidasEmprego;
        this.quantidadeVagasProvidasContratoTemporario = vagasProvidasContrato == null ? 0L : vagasProvidasContrato;
        this.codigoArea = codigoArea;
        this.nomeArea = nomeArea;
    }

    public final Integer getQuantidadeVagasNaoProvidasCargoEfetivo() {
        return this.quantidadeTotalVagasCargoEfetivo.intValue() - this.quantidadeVagasProvidasCargoEfetivo.intValue();
    }

    public final Integer getQuantidadeVagasNaoProvidasComissaoConfianca() {
        return this.quantidadeTotalVagasComissaoConfianca.intValue() - this.quantidadeVagasProvidasComissaoConfianca.intValue();
    }

    public final Integer getQuantidadeVagasNaoProvidasEmpregoEfetivo() {
        return this.quantidadeTotalVagasEmpregoEfetivo.intValue() - this.quantidadeVagasProvidasEmpregoEfetivo.intValue();
    }

    public final Integer getQuantidadeVagasNaoProvidasContratoTemporario() {
        return this.quantidadeTotalVagasContratoTemporario.intValue() - this.quantidadeVagasProvidasContratoTemporario.intValue();
    }

    public Long getQuantidadeTotalVagas() {
        return this.quantidadeTotalVagasCargoEfetivo + this.quantidadeTotalVagasComissaoConfianca + this.quantidadeTotalVagasEmpregoEfetivo;
    }

    public Integer getQuantidadeVagasProvidas() {
        return this.quantidadeVagasProvidasCargoEfetivo.intValue() + this.quantidadeVagasProvidasComissaoConfianca.intValue() + this.quantidadeVagasProvidasEmpregoEfetivo.intValue();
    }

    public Long getQuantidadeVagasNaoProvidas() {
        return this.getQuantidadeTotalVagas() - (long)this.getQuantidadeVagasProvidas().intValue();
    }

    public final String getCodigoCargo() {
        return this.codigoCargo;
    }

    public final String getNomeCargo() {
        return this.nomeCargo;
    }

    public final CargoNatureza getNaturezaCargo() {
        return this.naturezaCargo;
    }

    public final Long getQuantidadeTotalVagasCargoEfetivo() {
        return this.quantidadeTotalVagasCargoEfetivo;
    }

    public final Long getQuantidadeTotalVagasComissaoConfianca() {
        return this.quantidadeTotalVagasComissaoConfianca;
    }

    public final Long getQuantidadeTotalVagasEmpregoEfetivo() {
        return this.quantidadeTotalVagasEmpregoEfetivo;
    }

    public final Long getQuantidadeTotalVagasContratoTemporario() {
        return this.quantidadeTotalVagasContratoTemporario;
    }

    public final Long getQuantidadeVagasProvidasCargoEfetivo() {
        return this.quantidadeVagasProvidasCargoEfetivo;
    }

    public final Long getQuantidadeVagasProvidasComissaoConfianca() {
        return this.quantidadeVagasProvidasComissaoConfianca;
    }

    public final Long getQuantidadeVagasProvidasEmpregoEfetivo() {
        return this.quantidadeVagasProvidasEmpregoEfetivo;
    }

    public final Long getQuantidadeVagasProvidasContratoTemporario() {
        return this.quantidadeVagasProvidasContratoTemporario;
    }

    public void addQtdeTotalVagasCargoEfetivo(Long qtde) {
        this.quantidadeTotalVagasCargoEfetivo = this.quantidadeTotalVagasCargoEfetivo + qtde;
    }

    public void addQtdeTotalVagasComissaoConfianca(Long qtde) {
        this.quantidadeTotalVagasComissaoConfianca = this.quantidadeTotalVagasComissaoConfianca + qtde;
    }

    public void addQtdeTotalVagasEmpregoEfetivo(Long qtde) {
        this.quantidadeTotalVagasEmpregoEfetivo = this.quantidadeTotalVagasEmpregoEfetivo + qtde;
    }

    public void addQtdeTotalVagasContratoTemporario(Long qtde) {
        this.quantidadeTotalVagasContratoTemporario = this.quantidadeTotalVagasContratoTemporario + qtde;
    }

    public void addQtdeVagasProvidasCargoEfetivo(Long qtde) {
        this.quantidadeVagasProvidasCargoEfetivo = this.quantidadeVagasProvidasCargoEfetivo + qtde;
    }

    public void addQtdeVagasProvidasComissaoConfianca(Long qtde) {
        this.quantidadeVagasProvidasComissaoConfianca = this.quantidadeVagasProvidasComissaoConfianca + qtde;
    }

    public void addQtdeVagasProvidasEmpregoEfetivo(Long qtde) {
        this.quantidadeVagasProvidasEmpregoEfetivo = this.quantidadeVagasProvidasEmpregoEfetivo + qtde;
    }

    public void addQtdeVagasProvidasContratoTemporario(Long qtde) {
        this.quantidadeVagasProvidasContratoTemporario = this.quantidadeVagasProvidasContratoTemporario + qtde;
    }

    public static QuadroPessoalVO notNullObject() {
        return new QuadroPessoalVO("", "", null, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuadroPessoalVO that = (QuadroPessoalVO)o;
        return Objects.equals(this.codigoCargo, that.codigoCargo);
    }

    public int hashCode() {
        return Objects.hash(this.codigoCargo);
    }

    public String toString() {
        return "QuadroPessoalVO [codigoCargo=" + this.codigoCargo + ", nomeCargo=" + this.nomeCargo + ", naturezaCargo=" + (Object)((Object)this.naturezaCargo) + ", quantidadeTotalVagasCargo=" + this.quantidadeTotalVagasCargoEfetivo + ", quantidadeTotalVagasFuncao=" + this.quantidadeTotalVagasComissaoConfianca + ", quantidadeTotalVagasEmprego=" + this.quantidadeTotalVagasEmpregoEfetivo + ", quantidadeTotalVagasContrato=" + this.quantidadeTotalVagasContratoTemporario + ", quantidadeVagasProvidasCargo=" + this.quantidadeVagasProvidasCargoEfetivo + ", quantidadeVagasProvidasFuncao=" + this.quantidadeVagasProvidasComissaoConfianca + ", quantidadeVagasProvidasEmprego=" + this.quantidadeVagasProvidasEmpregoEfetivo + ", quantidadeVagasProvidasContrato=" + this.quantidadeVagasProvidasContratoTemporario + "]";
    }

    public String getCodigoArea() {
        return this.codigoArea;
    }

    public String getNomeArea() {
        return this.nomeArea;
    }
}

