/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.CategoriaFuncional;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Salario;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorSituacao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import br.com.fiorilli.sip.persistence.vo.reports.ComparativoMensalReciboDetalhesVO;
import java.util.Date;
import java.util.List;

@FilterConfigType(query="SELECT DISTINCT NEW br.com.fiorilli.sip.persistence.vo.reports.ComparativoMensalReciboVO( \n t.trabalhadorPK.registro, t.matricula, t.contrato, t.nome, t.dataAdmissao, b.cargoCodigo, c.nome) \nFROM Referencia r \nLEFT JOIN r.movimentoList m \nLEFT JOIN m.bases b \nLEFT JOIN b.trabalhador t \nLEFT JOIN m.evento e \nLEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.unidade u \nLEFT JOIN b.vinculo v \nLEFT JOIN b.localTrabalho l \nLEFT JOIN b.categoriaFuncional f \nLEFT JOIN b.salario rs \nLEFT JOIN b.cargo c \nWHERE r.entidadeCodigo = :entidadeCodigo AND r.ano = :ano AND r.mesCodigo = :mes \nAND r.tipo = '1' AND \n$P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nomeTrabalhador],[t],[:nomeTrabalhador]} AND $P{[salarioNome],[rs],[:salarioNome]} AND $P{[divisaoCodigo],[batu.divisao],[:divisaoCodigo]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[datadesligamento],[t.dataDemissao],[:datadesligamento]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[subdivisaoCodigo],[s],[:subdivisaoCodigo]} AND $P{[localTrabalhoCodigo],[l],[:localTrabalhoCodigo]} AND $P{[vinculoCodigo],[v],[:vinculoCodigo]} AND $P{[unidadeCodigo],[u],[:unidadeCodigo]} AND $P{[categoriaFuncionalCodigo],[f],[:categoriaFuncionalCodigo]} AND $P{[cargoCodigo],[c],[:cargoCodigo]} AND $P{[eventoCodigo],[e],[:eventoCodigo]} AND $P{[valorAtual],[m.valor],[:valorAtual]} AND $P{[valorAnterior],[m.valor],[:valorAnterior]} ")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matricula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Trabalhador.class, id="nomeTrabalhador", label="Nome", inputType=FilterInputType.AUTO_COMPLETE, order=5, query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisaoCodigo", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=TrabalhadorSituacao.class, id="situacao", label="Situa\u00e7\u00e3o", enumClass=TrabalhadorSituacao.class, enumId="codigo", enumLabel="descricao"), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Ref. Sal. Atual", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao"), @FilterConfigParameter(fieldClass=Date.class, id="datadesligamento", label="Desligamento", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisaoCodigo", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Unidade.class, id="departamentoDespesa", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculoCodigo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalhoCodigo", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=CategoriaFuncional.class, id="categoriaFuncionalCodigo", label="Categoria Funcional", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM CategoriaFuncional c where UPPER(c.nome) LIKE UPPER('%'||:param||'%') AND c.categoriaFuncionalPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Salario.class, id="salarioNome", label="Nome Ref. Salarial", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Salario s WHERE UPPER(s.nome) LIKE UPPER('%'||:param||'%') AND s.salarioPK.entidade = :entidadeCodigo ORDER BY s.nome"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargoCodigo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Evento.class, id="eventoCodigo", label="Evento", order=4, inputType=FilterInputType.AUTO_COMPLETE, query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome"), @FilterConfigParameter(fieldClass=Double.class, id="valorAtual", label="Valor Atual", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="valorAnterior", label="Valor Anterior", inputType=FilterInputType.NUMBER)})
public class ComparativoMensalReciboVO {
    public static final String FIND_TRABALHADOR = "SELECT DISTINCT NEW br.com.fiorilli.sip.persistence.vo.reports.ComparativoMensalReciboVO( \n t.trabalhadorPK.registro, t.matricula, t.contrato, t.nome, t.dataAdmissao, b.cargoCodigo, c.nome) \nFROM Referencia r \nLEFT JOIN r.movimentoList m \nLEFT JOIN m.bases b \nLEFT JOIN b.trabalhador t \nLEFT JOIN m.evento e \nLEFT JOIN b.divisao d \nLEFT JOIN b.subdivisao s \nLEFT JOIN b.unidade u \nLEFT JOIN b.vinculo v \nLEFT JOIN b.localTrabalho l \nLEFT JOIN b.categoriaFuncional f \nLEFT JOIN b.salario rs \nLEFT JOIN b.cargo c \nWHERE r.entidadeCodigo = :entidadeCodigo AND r.ano = :ano AND r.mesCodigo = :mes \nAND r.tipo = '1' AND \n$P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nomeTrabalhador],[t],[:nomeTrabalhador]} AND $P{[salarioNome],[rs],[:salarioNome]} AND $P{[divisaoCodigo],[batu.divisao],[:divisaoCodigo]} AND $P{[situacao],[t.situacao],[:situacao]} AND $P{[tipoSalario],[t.tipoSalario],[:tipoSalario]} AND $P{[datadesligamento],[t.dataDemissao],[:datadesligamento]} AND $P{[dataAdmissao],[t.dataAdmissao],[:dataAdmissao]} AND $P{[subdivisaoCodigo],[s],[:subdivisaoCodigo]} AND $P{[localTrabalhoCodigo],[l],[:localTrabalhoCodigo]} AND $P{[vinculoCodigo],[v],[:vinculoCodigo]} AND $P{[unidadeCodigo],[u],[:unidadeCodigo]} AND $P{[categoriaFuncionalCodigo],[f],[:categoriaFuncionalCodigo]} AND $P{[cargoCodigo],[c],[:cargoCodigo]} AND $P{[eventoCodigo],[e],[:eventoCodigo]} AND $P{[valorAtual],[m.valor],[:valorAtual]} AND $P{[valorAnterior],[m.valor],[:valorAnterior]} ";
    private List<ComparativoMensalReciboDetalhesVO> comparativosDetalhes;
    private final String registro;
    private final Integer matricula;
    private final Short contrato;
    private final String nomeTrabalhador;
    private final Date dataAdmissao;
    private final String cargoCodigo;
    private final String cargoNome;

    public ComparativoMensalReciboVO(String registro, Integer matricula, Short contrato, String nomeTrabalhador, Date dataAdmissao, String cargoCodigo, String cargoNome) {
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nomeTrabalhador = nomeTrabalhador;
        this.dataAdmissao = dataAdmissao;
        this.cargoCodigo = cargoCodigo;
        this.cargoNome = cargoNome;
    }

    public List<ComparativoMensalReciboDetalhesVO> getComparativosDetalhes() {
        return this.comparativosDetalhes;
    }

    public void setComparativosDetalhes(List<ComparativoMensalReciboDetalhesVO> comparativosDetalhes) {
        this.comparativosDetalhes = comparativosDetalhes;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public String getCargoNome() {
        return this.cargoNome;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNomeTrabalhador() {
        return this.nomeTrabalhador;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }
}

