/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.reports;

import br.com.fiorilli.filter.model.FilterEntity;
import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import br.com.fiorilli.sip.persistence.enums.TipoFiltroRelatorio;
import br.com.fiorilli.sip.persistence.vo.EntidadeMinVo;
import br.com.fiorilli.sip.persistence.vo.ReferenciaMinVo;
import java.util.Date;

public class CalculatorReportParameter {
    private FilterEntity filter;
    private String registro;
    private EntidadeMinVo entidade;
    private ReferenciaMinVo referencia;
    private boolean exibirApenasRegistroAtual = true;
    private boolean exibirEventos;
    private boolean exibirEventosAbaixoDoPonto;
    private boolean exibirObsAbaixoDoPonto;
    private boolean exibirMotivos = false;
    private boolean exibirLocalParaAssinatura = false;
    private boolean exibirAvisos;
    private Relatorio relatorio = Relatorio.EXTRATO;
    private boolean exibirQuartoAndQuintoPeriodos = false;
    private boolean exibirColunasLigadas = true;
    private String orderBy = "tr.matricula";
    private boolean ordenarPorLocalDeTrabalho = true;
    private Date dataInicio;
    private Date dataFim;
    private boolean exibirSomenteComBatidasOrObs = false;
    private boolean exibirSomenteComBatidas = false;
    private boolean exibirModeloSimplificado = false;
    private boolean exibirHorarioContratual = false;
    private boolean exibirTotalizadorEventos = true;
    private boolean quebrarPaginaTrabalhador = true;
    private boolean exibirObsOcorrencias = true;
    private boolean exibirSomenteComAlteracoes = false;
    private boolean exibirObsJornadaGenerica = false;
    private TipoFiltroRelatorio tipoFiltroRelatorio = TipoFiltroRelatorio.REFERENCIA;
    private Usuario usuario;

    public FilterEntity getFilter() {
        return this.filter;
    }

    public void setFilter(FilterEntity filter) {
        this.filter = filter;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public EntidadeMinVo getEntidade() {
        return this.entidade;
    }

    public void setEntidade(EntidadeMinVo entidade) {
        this.entidade = entidade;
    }

    public ReferenciaMinVo getReferencia() {
        return this.referencia;
    }

    public void setReferencia(ReferenciaMinVo referencia) {
        if (referencia != null) {
            this.dataInicio = referencia.getPrimeiroDiaFrequencia();
            this.dataFim = referencia.getUltimoDiaFrequencia();
        }
        this.referencia = referencia;
    }

    public boolean isExibirApenasRegistroAtual() {
        return this.exibirApenasRegistroAtual;
    }

    public void setExibirApenasRegistroAtual(boolean exibirApenasRegistroAtual) {
        this.exibirApenasRegistroAtual = exibirApenasRegistroAtual;
    }

    public boolean isExibirEventos() {
        return this.exibirEventos;
    }

    public void setExibirEventos(boolean exibirEventos) {
        this.exibirEventos = exibirEventos;
    }

    public boolean isExibirEventosAbaixoDoPonto() {
        return this.exibirEventosAbaixoDoPonto;
    }

    public void setExibirEventosAbaixoDoPonto(boolean exibirEventosAbaixoDoPonto) {
        this.exibirEventosAbaixoDoPonto = exibirEventosAbaixoDoPonto;
    }

    public boolean isExibirObsAbaixoDoPonto() {
        return this.exibirObsAbaixoDoPonto;
    }

    public void setExibirObsAbaixoDoPonto(boolean exibirObsAbaixoDoPonto) {
        this.exibirObsAbaixoDoPonto = exibirObsAbaixoDoPonto;
    }

    public Relatorio[] getRelatoriosDisponiveis() {
        return Relatorio.values();
    }

    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    public void setRelatorio(Relatorio relatorio) {
        this.relatorio = relatorio;
        this.exibirLocalParaAssinatura = this.relatorio.isEspelhoDetalhado();
    }

    public boolean isExibirMotivos() {
        return this.exibirMotivos;
    }

    public void setExibirMotivos(boolean exibirMotivos) {
        this.exibirMotivos = exibirMotivos;
    }

    public boolean isExibirQuartoAndQuintoPeriodos() {
        return this.exibirQuartoAndQuintoPeriodos;
    }

    public boolean isExibirColunasLigadas() {
        return this.exibirColunasLigadas;
    }

    public String getEntidadeCodigo() {
        return this.entidade.getCodigo();
    }

    public boolean isExibirObsOcorrencias() {
        return this.exibirObsOcorrencias;
    }

    public void setExibirObsOcorrencias(boolean exibirObsOcorrencias) {
        this.exibirObsOcorrencias = exibirObsOcorrencias;
    }

    public boolean isExibirSomenteComAlteracoes() {
        return this.exibirSomenteComAlteracoes;
    }

    public void setExibirSomenteComAlteracoes(boolean exibirSomenteComAlteracoes) {
        this.exibirSomenteComAlteracoes = exibirSomenteComAlteracoes;
    }

    public boolean isExibirObsJornadaGenerica() {
        return this.exibirObsJornadaGenerica;
    }

    public void setExibirObsJornadaGenerica(boolean exibirObsJornadaGenerica) {
        this.exibirObsJornadaGenerica = exibirObsJornadaGenerica;
    }

    public void setExibirQuartoAndQuintoPeriodos(boolean exibirQuartoAndQuintoPeriodos) {
        this.exibirQuartoAndQuintoPeriodos = exibirQuartoAndQuintoPeriodos;
    }

    public void setExibirColunasLigadas(boolean exibirColunasLigadas) {
        this.exibirColunasLigadas = exibirColunasLigadas;
    }

    public boolean isExibirLocalParaAssinatura() {
        return this.exibirLocalParaAssinatura;
    }

    public void setExibirLocalParaAssinatura(boolean exibirLocalDeAssinatura) {
        this.exibirLocalParaAssinatura = exibirLocalDeAssinatura;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public boolean isOrdenarPorLocalDeTrabalho() {
        return this.ordenarPorLocalDeTrabalho;
    }

    public void setOrdenarPorLocalDeTrabalho(boolean ordenarPorLocalDeTrabalho) {
        this.ordenarPorLocalDeTrabalho = ordenarPorLocalDeTrabalho;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public boolean isExibirAvisos() {
        return this.exibirAvisos;
    }

    public void setExibirAvisos(boolean exibirAvisos) {
        this.exibirAvisos = exibirAvisos;
    }

    public boolean isExibirSomenteComBatidasOrObs() {
        return this.exibirSomenteComBatidasOrObs;
    }

    public void setExibirSomenteComBatidasOrObs(boolean exibirSomenteComBatidasOrObs) {
        this.exibirSomenteComBatidasOrObs = exibirSomenteComBatidasOrObs;
    }

    public boolean isExibirSomenteComBatidas() {
        return this.exibirSomenteComBatidas;
    }

    public void setExibirSomenteComBatidas(boolean exibirSomenteComBatidas) {
        this.exibirSomenteComBatidas = exibirSomenteComBatidas;
    }

    public boolean isExibirHorarioContratual() {
        return this.exibirHorarioContratual;
    }

    public void setExibirHorarioContratual(boolean exibirHorarioContratual) {
        this.exibirHorarioContratual = exibirHorarioContratual;
    }

    public boolean isExibirTotalizadorEventos() {
        return this.exibirTotalizadorEventos;
    }

    public void setExibirTotalizadorEventos(boolean exibirTotalizadorEventos) {
        this.exibirTotalizadorEventos = exibirTotalizadorEventos;
    }

    public boolean isQuebrarPaginaTrabalhador() {
        return this.quebrarPaginaTrabalhador;
    }

    public void setQuebrarPaginaTrabalhador(boolean quebrarPaginaTrabalhador) {
        this.quebrarPaginaTrabalhador = quebrarPaginaTrabalhador;
    }

    public String getWhereConditionSomenteBatidas() {
        StringBuilder sb = new StringBuilder();
        if (this.isExibirSomenteComBatidas() || this.isExibirSomenteComBatidasOrObs()) {
            sb.append(" AND ");
            sb.append("( ");
            sb.append("(select count(p.codigo) from Ponto p where p.entidadeCodigo = pm.pontoMesPK.entidade and p.registro = pm.trabalhador.trabalhadorPK.registro and p.referenciaCodigo = re.codigo and p.horasTrabalhadas > 0) ");
            if (this.isExibirSomenteComBatidas()) {
                sb.append(") > 0 ");
            }
        }
        return sb.toString();
    }

    public String getWhereConditionSomenteBatidasOrObs() {
        StringBuilder sb = new StringBuilder();
        if (this.isExibirSomenteComBatidas() || this.isExibirSomenteComBatidasOrObs()) {
            sb.append(this.getWhereConditionSomenteBatidas());
            if (this.isExibirSomenteComBatidasOrObs()) {
                sb.append("+ ");
                sb.append("(select count(p.codigo) from Ponto p where p.entidadeCodigo = pm.pontoMesPK.entidade and p.registro = pm.trabalhador.trabalhadorPK.registro and p.referenciaCodigo = re.codigo and p.situacao in ('2','3','4','5','10','11')) ");
                sb.append("+ ");
                sb.append("(select count(p.ponto) from PontoEvento p where p.ponto.entidadeCodigo = pm.pontoMesPK.entidade and p.ponto.registro = pm.trabalhador.trabalhadorPK.registro and p.ponto.referenciaCodigo = re.codigo) ");
                sb.append("+ ");
                sb.append("(select count(p.codigo) from PontoTipoOcorrencia o join o.ponto p where p.entidadeCodigo = pm.pontoMesPK.entidade and p.registro = pm.trabalhador.trabalhadorPK.registro and p.referenciaCodigo = re.codigo) ");
                sb.append(") > 0 ");
            }
        }
        return sb.toString();
    }

    public String getWhereConditionOcorrenciasPonto() {
        StringBuilder sb = new StringBuilder();
        if (this.relatorio.isOcorrencias()) {
            sb.append(" AND (EXISTS(SELECT 'S' FROM Ponto pt INNER JOIN pt.eventos pe INNER JOIN pe.evento ev WHERE pt.entidadeCodigo = pm.pontoMesPK.entidade    AND pt.registro = pm.trabalhador.trabalhadorPK.registro    AND pt.data BETWEEN :dataInicio AND :dataFim    AND ev.classificacao = '06') OR EXISTS( SELECT 'S' FROM Ponto pt WHERE pt.entidadeCodigo = pm.pontoMesPK.entidade    AND pt.registro = pm.trabalhador.trabalhadorPK.registro    AND pt.data BETWEEN :dataInicio AND :dataFim    AND (((pt.entrada1 <> '') and (pt.entrada1 = pt.saida1))        OR ((pt.saida1 <> '') and (pt.saida1 = pt.entrada2))        OR ((pt.entrada2 <> '') and (pt.entrada2 = pt.saida2))        OR ((pt.saida2 <> '') and (pt.saida2 = pt.entrada3))        OR ((pt.entrada3 <> '') and (pt.entrada3 = pt.saida3))        OR ((pt.saida3 <> '') and (pt.saida3 = pt.entrada4))        OR ((pt.entrada4 <> '') and (pt.entrada4 = pt.saida4))        OR ((pt.saida4 <> '') and (pt.saida4 = pt.entrada5))        OR ((pt.entrada5 <> '') and (pt.entrada5 = pt.saida5)))) OR EXISTS( SELECT 'S' FROM Ponto pt WHERE pt.entidadeCodigo = pm.pontoMesPK.entidade    AND pt.registro = pm.trabalhador.trabalhadorPK.registro    AND pt.data BETWEEN :dataInicio AND :dataFim    AND (MOD((CASE WHEN pt.entrada1 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.saida1 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.entrada2 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.saida2 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.entrada3 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.saida3 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.entrada4 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.saida4 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.entrada5 <> '' THEN 1 ELSE 0 END) +        (CASE WHEN pt.saida5 <> '' THEN 1 ELSE 0 END), 2) <> 0))) ");
        }
        return sb.toString();
    }

    public String getWhereConditionSomenteComAlteracoes() {
        StringBuilder sb = new StringBuilder();
        if (this.isExibirSomenteComAlteracoes()) {
            sb.append(" AND (coalesce((");
            sb.append("SELECT count(m.id) ");
            sb.append("FROM Ponto pt ");
            sb.append("INNER JOIN pt.motivos m ");
            sb.append("WHERE pt.entidadeCodigo = pm.pontoMesPK.entidade ");
            sb.append("   AND pt.registro = pm.trabalhador.trabalhadorPK.registro ");
            sb.append("   AND pt.referenciaCodigo = re.codigo ");
            sb.append("), 0) > 0) ");
        }
        return sb.toString();
    }

    public boolean isExibirModeloSimplificado() {
        return this.exibirModeloSimplificado;
    }

    public void setExibirModeloSimplificado(boolean exibirModeloSimplificado) {
        this.exibirModeloSimplificado = exibirModeloSimplificado;
    }

    public TipoFiltroRelatorio getTipoFiltroRelatorio() {
        return this.tipoFiltroRelatorio;
    }

    public void setTipoFiltroRelatorio(TipoFiltroRelatorio tipoFiltroRelatorio) {
        this.tipoFiltroRelatorio = tipoFiltroRelatorio;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public void loadDefaultParams(Relatorio tipoRelatorio) {
        if (this.entidade != null) {
            this.exibirModeloSimplificado = this.entidade.isTupa() || this.entidade.isConsorcioSaudeTupa();
            this.exibirMotivos = this.entidade.isVotuporanga();
            this.exibirTotalizadorEventos = !this.entidade.isVotuporanga() && !this.entidade.isSMA();
            this.exibirObsJornadaGenerica = this.entidade.isConsorcioSaudeTupa();
            if (tipoRelatorio != null) {
                this.setRelatorio(tipoRelatorio);
            }
        }
    }

    public String toStringLog() {
        String options = "";
        switch (this.relatorio) {
            case EXTRATO: {
                options = " - Exibir Eventos: " + this.exibirEventos + "\r" + " - Exibir Eventos Abaixo Do Ponto: " + this.exibirEventosAbaixoDoPonto + "\r" + " - Exibir Obs Abaixo Do Ponto: " + this.exibirObsAbaixoDoPonto + "\r" + " - Exibir Avisos: " + this.exibirAvisos + "\r";
                break;
            }
            case ESPELHO: {
                options = " - Exibir Motivos das Altera\u00e7\u00f5es: " + this.exibirMotivos + "\r" + " - Exibir Somente com Batidas Preenchidas: " + this.exibirSomenteComBatidas + "\r";
                break;
            }
            case ESPELHO_DETALHADO: {
                options = " - Exibir Quarto e Quinto Per\u00edodos: " + this.exibirQuartoAndQuintoPeriodos + "\r" + " - Exibir Colunas Ligadas: " + this.exibirColunasLigadas + "\r" + " - Exibir Local Para Assinatura: " + this.exibirLocalParaAssinatura + "\r" + " - Exibir Motivos das Altera\u00e7\u00f5es: " + this.exibirMotivos + "\r" + " - Exibir Modelo Simplificado: " + this.exibirModeloSimplificado + "\r" + " - Exibir Hor\u00e1rio Contratual: " + this.exibirHorarioContratual + "\r" + " - Exibir Totalizador Eventos: " + this.exibirTotalizadorEventos + "\r" + " - Quebrar P\u00e1gina por Trabalhador: " + this.quebrarPaginaTrabalhador + "\r" + " - Exibir Obs Jornada Gen\u00e9rica: " + this.exibirObsJornadaGenerica + "\r";
                break;
            }
            case OCORENCIAS: {
                options = " - Exibir Obs Ocorr\u00eancias: " + this.exibirObsOcorrencias + "\r";
            }
        }
        if (this.relatorio.isExtrato() || this.relatorio.isEspelhoDetalhado()) {
            options = options + " - Exibir Somente com Batidas ou Obs: " + this.exibirSomenteComBatidasOrObs + "\r" + " - Exibir Somente Com Altera\u00e7\u00f5es nas Batidas: " + this.exibirSomenteComAlteracoes + "\r";
        }
        String filters = this.filter != null ? this.filter.getModelsToLog() : null;
        return "[Visualiza\u00e7\u00e3o " + this.relatorio.getDescricao() + " do Ponto]" + "\r" + "\r" + "[Filtro]" + "\r" + (filters != null && !filters.isEmpty() ? " - " + filters + "\r" : "") + "\r" + "[Par\u00e2metros]" + "\r" + " - Entidade: " + (this.entidade != null ? this.entidade.getCodigo() : "") + "\r" + (this.registro != null ? " - Registro: " + this.registro + "\r" : "") + " - Tipo Filtro Relat\u00f3rio: " + this.tipoFiltroRelatorio.getDescricao() + "\r" + " - M\u00eas: " + (this.referencia != null ? this.referencia.getMesCodigo() : "") + "\r" + " - Ano: " + (this.referencia != null ? this.referencia.getAno() : "") + "\r" + " - Data In\u00edcio: " + SIPDateUtil.toString((Date)this.dataInicio) + "\r" + " - Data Fim: " + SIPDateUtil.toString((Date)this.dataFim) + "\r" + " - Exibir Apenas Registro Atual: " + this.exibirApenasRegistroAtual + "\r" + options + "\r";
    }

    public static enum Relatorio {
        EXTRATO("Extrato", "reports/cartao-ponto-extrato.jrxml", "extrato.jrxml"),
        ESPELHO("Espelho", "reports/cartao-ponto-espelho.jrxml", "espelho.jrxml"),
        ESPELHO_DETALHADO("Espelho Detalhado", "reports/cartao-ponto-espelho-detalhado.jrxml", "espelho-detalhado.jrxml"),
        LISTAGEM("Listagem", "reports/cartao-ponto-listagem.jrxml", "listagem.jrxml"),
        OCORENCIAS("Ocorr\u00eancias", "reports/cartao-ponto-ocorrencias.jrxml", "ocorrencias.jrxml");

        private final String descricao;
        private final String jrxml;
        private final String jrxmlPersonalizado;

        private Relatorio(String descricao, String jrxml, String jrxmlPersonalizado) {
            this.descricao = descricao;
            this.jrxml = jrxml;
            this.jrxmlPersonalizado = jrxmlPersonalizado;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getJrxml() {
            return this.jrxml;
        }

        public boolean isExtrato() {
            return this == EXTRATO;
        }

        public boolean isEspelho() {
            return this == ESPELHO;
        }

        public boolean isEspelhoDetalhado() {
            return this == ESPELHO_DETALHADO;
        }

        public boolean isListagem() {
            return this == LISTAGEM;
        }

        public boolean isOcorrencias() {
            return this == OCORENCIAS;
        }

        public String getJrxmlPersonalizado() {
            return this.jrxmlPersonalizado;
        }
    }
}

