/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.pr.tce;

import br.com.fiorilli.sip.persistence.vo.ma.tce.Cpf;
import br.com.fiorilli.sip.persistence.vo.ma.tce.Pis;
import br.com.fiorilli.sip.persistence.vo.pr.tce.TcePrVOUtil;
import br.com.fiorilli.sip.persistence.vo.pr.tce.TipoSituacaoServidor;
import java.util.Date;
import javax.validation.constraints.NotNull;

public class ServidorVO {
    @NotNull(message="C\u00f3digo da entidade de origem inv\u00e1lido.")
    private final String idEntidadeOrigem;
    @Cpf
    private final String nrCpf;
    @NotNull(message="Matricula do servidor/pensionista inv\u00e1lido.")
    private final String nrMatricula;
    @NotNull(message="Identifica\u00e7\u00e3o do tipo de situa\u00e7\u00e3o do servidor inv\u00e1lido.")
    private final String idTipoSituacaoServidor;
    private final String idBanco;
    private final String dsAgencia;
    private final String dsConta;
    @NotNull(message="Recebimento em conta inv\u00e1lido.")
    private final String flRecebimentoConta;
    @NotNull(message="Recebimento em esp\u00e9cie inv\u00e1lido.")
    private final String flRecebimentoEspecie;
    @NotNull(message="Recebimento em cheque/ordem de pagamento inv\u00e1lido.")
    private final String flRecebimentoCheque;
    private final Date dtAdmissao;
    private final String nrProcessoAdmissao;
    private final String idTipoIngresso;
    private final String idEntidadeOrigemInativo;
    private final String cdControleFuncao;
    private final String nmFuncao;
    @Pis
    private final String nrPISPASEP;
    @NotNull(message="Tipo de v\u00ednculo previdenci\u00e1rio inv\u00e1lido.")
    private final String idTipoVinculo;
    private final String flComplementar;
    @Cpf(nullable=true, message="O CPF do servidor de origem da pens\u00e3o \u00e9 inv\u00e1lido.")
    private final String nrCpfServidorOrgiemPensao;
    private final String nrMatriculaServidorOrigemPensao;
    public static final String FIND_SERVIDOR_ATIVOS = "SELECT DISTINCT new " + ServidorVO.class.getName() + "        (etc.pessoaId, t.documentosPessoais.cpf, t.trabalhadorPK.registro, c.bancoCodigo, c.agenciaCodigo, c.contaCodigo, " + "        CASE WHEN c.registro IS NOT NULL THEN 'S' ELSE 'N' END, 'N', " + "        CASE WHEN c.registro IS NOT NULL THEN 'N' ELSE 'S' END, t.dataAdmissao, " + "        CASE t.tipoCargoInicial WHEN '1' THEN '1' WHEN '3' THEN '2' WHEN '2' THEN '3' WHEN '4' THEN '4' ELSE CAST(NULL AS string) END, t.cargoAtualCodigo, ca.nome, t.documentosPessoais.pis, " + "        CASE v.tabelaPrevidenciaria WHEN 1 THEN '7' WHEN 2 THEN '2' ELSE CAST(NULL AS string) END, 'N') " + "FROM " + "        Trabalhador t " + "LEFT JOIN " + "        t.contaList c WITH c.padrao = true " + "LEFT JOIN " + "        t.vinculo v " + "LEFT JOIN " + "        t.cargoAtual ca " + "LEFT JOIN " + "        t.entidade e " + "LEFT JOIN " + "        e.tcePr etc " + "WHERE " + "        etc.pessoaId = :codigoTcePr " + "AND     ( " + "                t.situacao     = :situacaoAtiva " + "        OR      t.dataDemissao > :dataAte) " + "AND     v.vinculoRais      <> :jovemAprendiz " + "AND     ca.cbo             <> :conselheiroTutelar " + "AND     ca.natureza        <> :estagiario " + "AND     t.pensionista       = false " + "OR      t.pensionista IS NULL " + "AND     t.aposentado        = false " + "OR      t.aposentado  IS NULL";
    public static final String FIND_SERVIDORES_INATIVOS = "SELECT DISTINCT new " + ServidorVO.class.getName() + "        (etc.pessoaId, t.documentosPessoais.cpf, t.trabalhadorPK.registro, c.bancoCodigo, c.agenciaCodigo, c.contaCodigo, " + "        CASE WHEN c.registro IS NOT NULL THEN 'S' ELSE 'N' END, 'N', " + "        CASE WHEN c.registro IS NOT NULL THEN 'N' ELSE 'S' END, etc.pessoaId, t.cargoAtualCodigo, ca.nome, " + "        CASE v.tabelaPrevidenciaria WHEN 1 THEN '7' WHEN 2 THEN '2' ELSE CAST(NULL AS string) END, 'N') " + "FROM " + "        Trabalhador t " + "LEFT JOIN " + "        t.contaList c WITH c.padrao = true " + "LEFT JOIN " + "        t.vinculo v " + "LEFT JOIN " + "        t.cargoAtual ca " + "LEFT JOIN " + "        t.entidade e " + "LEFT JOIN " + "        e.tcePr etc " + "WHERE " + "        etc.pessoaId = :codigoTcePr " + "AND     ( " + "                t.situacao     = :situacaoAtiva " + "        OR      t.dataDemissao > :dataAte) " + "AND     v.vinculoRais <> :jovemAprendiz " + "AND     ca.cbo        <> :conselheiroTutelar " + "AND     ca.natureza   <> :estagiario " + "AND     t.aposentado   = true ";
    public static final String FIND_SERVIDORES_PENSIONISTAS = "SELECT DISTINCT new " + ServidorVO.class.getName() + "        (etc.pessoaId, t.documentosPessoais.cpf, t.trabalhadorPK.registro, c.bancoCodigo, c.agenciaCodigo, c.contaCodigo, " + "        CASE WHEN c.registro IS NOT NULL THEN 'S' ELSE 'N' END, 'N', " + "        CASE WHEN c.registro IS NOT NULL THEN 'N' ELSE 'S' END, " + "        CASE v.tabelaPrevidenciaria WHEN 1 THEN '7' WHEN 2 THEN '2' ELSE CAST(NULL AS string) END, 'N', tm.documentosPessoais.cpf, tm.trabalhadorPK.registro) " + "FROM " + "        Trabalhador t " + "LEFT JOIN " + "        t.contaList c WITH c.padrao = true " + "LEFT JOIN " + "        t.vinculo v " + "LEFT JOIN " + "        t.cargoInicial ca " + "LEFT JOIN " + "        t.entidade e " + "LEFT JOIN " + "        e.tcePr etc " + "LEFT JOIN " + "        t.pensao.trabalhadorRegistroMorto tm " + "WHERE " + "        etc.pessoaId = :codigoTcePr " + "AND     ( " + "                t.situacao     = :situacaoAtiva " + "        OR      t.dataDemissao > :dataAte) " + "AND     v.vinculoRais <> :jovemAprendiz " + "AND     ca.cbo        <> :conselheiroTutelar " + "AND     ca.natureza   <> :estagiario " + "AND     t.pensionista  = true ";

    public ServidorVO(String idEntidadeOrigem, String nrCpf, String nrMatricula, String idBanco, String dsAgencia, String dsConta, String flRecebimentoConta, String flRecebimentoEspecie, String flRecebimentoCheque, Date dtAdmissao, String idTipoIngresso, String cdControleFuncao, String nmFuncao, String nrPISPASEP, String idTipoVinculo, String flComplementar) {
        this.idEntidadeOrigem = idEntidadeOrigem;
        this.nrCpf = nrCpf;
        this.nrMatricula = nrMatricula;
        this.idTipoSituacaoServidor = TipoSituacaoServidor.ATIVO.getCodigo();
        this.idBanco = idBanco;
        this.dsAgencia = dsAgencia;
        this.dsConta = dsConta;
        this.flRecebimentoConta = flRecebimentoConta;
        this.flRecebimentoEspecie = flRecebimentoEspecie;
        this.flRecebimentoCheque = flRecebimentoCheque;
        this.dtAdmissao = dtAdmissao;
        this.idTipoIngresso = idTipoIngresso;
        this.cdControleFuncao = cdControleFuncao;
        this.nmFuncao = nmFuncao;
        this.nrPISPASEP = nrPISPASEP;
        this.idTipoVinculo = idTipoVinculo;
        this.flComplementar = flComplementar;
        this.nrMatriculaServidorOrigemPensao = null;
        this.nrCpfServidorOrgiemPensao = "";
        this.idEntidadeOrigemInativo = "";
        this.nrProcessoAdmissao = "";
    }

    public ServidorVO(String idEntidadeOrigem, String nrCpf, String nrMatricula, String idBanco, String dsAgencia, String dsConta, String flRecebimentoConta, String flRecebimentoEspecie, String flRecebimentoCheque, String idEntidadeOrigemInativo, String cdControleFuncao, String nmFuncao, String idTipoVinculo, String flComplementar) {
        this.idEntidadeOrigem = idEntidadeOrigem;
        this.nrCpf = nrCpf;
        this.nrMatricula = nrMatricula;
        this.idEntidadeOrigemInativo = idEntidadeOrigemInativo.toString();
        this.idTipoSituacaoServidor = TipoSituacaoServidor.INATIVO.getCodigo();
        this.idBanco = idBanco;
        this.dsAgencia = dsAgencia;
        this.dsConta = dsConta;
        this.flRecebimentoConta = flRecebimentoConta;
        this.flRecebimentoEspecie = flRecebimentoEspecie;
        this.flRecebimentoCheque = flRecebimentoCheque;
        this.cdControleFuncao = cdControleFuncao;
        this.nmFuncao = nmFuncao;
        this.idTipoVinculo = idTipoVinculo;
        this.flComplementar = flComplementar;
        this.dtAdmissao = null;
        this.nrMatriculaServidorOrigemPensao = null;
        this.nrCpfServidorOrgiemPensao = "";
        this.nrPISPASEP = "";
        this.idTipoIngresso = "";
        this.nrProcessoAdmissao = "";
    }

    public ServidorVO(String idEntidadeOrigem, String nrCpf, String nrMatricula, String idBanco, String dsAgencia, String dsConta, String flRecebimentoConta, String flRecebimentoEspecie, String flRecebimentoCheque, String idTipoVinculo, String flComplementar, String nrCpfServidorOrgiemPensao, String nrMatriculaServidorOrigemPensao) {
        this.idEntidadeOrigem = idEntidadeOrigem;
        this.nrCpf = nrCpf;
        this.nrMatricula = nrMatricula;
        this.idTipoSituacaoServidor = TipoSituacaoServidor.PENSIONISTA.getCodigo();
        this.idBanco = idBanco;
        this.dsAgencia = dsAgencia;
        this.dsConta = dsConta;
        this.flRecebimentoConta = flRecebimentoConta;
        this.flRecebimentoEspecie = flRecebimentoEspecie;
        this.flRecebimentoCheque = flRecebimentoCheque;
        this.idTipoVinculo = idTipoVinculo;
        this.flComplementar = flComplementar;
        this.nrCpfServidorOrgiemPensao = nrCpfServidorOrgiemPensao;
        this.nrMatriculaServidorOrigemPensao = nrMatriculaServidorOrigemPensao;
        this.dtAdmissao = null;
        this.nrPISPASEP = "";
        this.nmFuncao = "";
        this.cdControleFuncao = "";
        this.idEntidadeOrigemInativo = "";
        this.idTipoIngresso = "";
        this.nrProcessoAdmissao = "";
    }

    public String getNrMatricula() {
        return this.nrMatricula;
    }

    public String toString() {
        return TcePrVOUtil.buildCsvLine(this.idEntidadeOrigem, this.nrCpf, TcePrVOUtil.stripStartZeros(this.nrMatricula), this.idTipoSituacaoServidor, this.idBanco, this.dsAgencia, this.dsConta, this.flRecebimentoConta, this.flRecebimentoEspecie, this.flRecebimentoCheque, TcePrVOUtil.getDateFormatted(this.dtAdmissao), this.nrProcessoAdmissao, this.idTipoIngresso, this.idEntidadeOrigemInativo, TcePrVOUtil.stripStartZeros(this.cdControleFuncao), this.nmFuncao, this.nrPISPASEP, this.idTipoVinculo, this.flComplementar, this.nrCpfServidorOrgiemPensao, TcePrVOUtil.stripStartZeros(this.nrMatriculaServidorOrigemPensao));
    }
}

