/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.pr.tce;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.vo.ma.tce.Cpf;
import javax.validation.constraints.NotNull;

public class FolhaVerbaVO {
    @NotNull(message="Obrigat\u00f3rio informar o codigo da entidade de origem")
    private final String idEntidadeOrigem;
    @Cpf
    private final String nrCpf;
    private final String nrMatricula;
    @NotNull(message="Obrigat\u00f3rio informar o tipo da situa\u00e7\u00e3o do servidor")
    private final String idTipoSituacaoServidor;
    @NotNull(message="Obrigat\u00f3rio informar o codigo do controle da verba")
    private final Integer cdControleVerba;
    @NotNull(message="Obrigat\u00f3rio informar o nome da verba do servidor")
    private final String nmVerba;
    @NotNull(message="Obrigat\u00f3rio informar o valor da verba")
    private final Double vlVerba;
    @NotNull(message="Obrigat\u00f3rio informar o operador da verba")
    private final String flOperadorVerba;
    private final String nrEmpenho;
    private final String nrAnoEmpenho;
    private final String idEntidadeOrigemEmpenho;

    public FolhaVerbaVO(String idEntidadeOrigem, String nrCpf, String nrMatricula, String idTipoSituacaoServidor, Integer cdControleVerba, String nmVerba, Double vlVerba, String flOperadorVerba) {
        this.idEntidadeOrigem = idEntidadeOrigem;
        this.nrCpf = nrCpf;
        this.nrMatricula = SIPUtil.removeZeroEsquerda((String)nrMatricula);
        this.idTipoSituacaoServidor = idTipoSituacaoServidor;
        this.cdControleVerba = cdControleVerba;
        this.nmVerba = nmVerba;
        this.vlVerba = vlVerba;
        this.flOperadorVerba = flOperadorVerba;
        this.idEntidadeOrigemEmpenho = "";
        this.nrAnoEmpenho = "";
        this.nrEmpenho = "";
    }

    public String getNrMatricula() {
        return this.nrMatricula;
    }

    public String getNmVerba() {
        return this.nmVerba;
    }

    public String toString() {
        int delimiter = 124;
        return this.idEntidadeOrigem + '|' + this.nrCpf + '|' + this.nrMatricula + '|' + this.idTipoSituacaoServidor + '|' + this.cdControleVerba + '|' + this.nmVerba + '|' + SIPUtil.getBigDecimal((Double)this.vlVerba) + '|' + this.flOperadorVerba + '|' + this.nrEmpenho + '|' + this.nrAnoEmpenho + '|' + this.idEntidadeOrigemEmpenho + '|';
    }

    public static class FolhaVerbaVOSql {
        public static final String FIND_BY_PARAMETROS = " SELECT DISTINCT new " + FolhaVerbaVO.class.getName() + " (etc.pessoaId, t.documentosPessoais.cpf, t.trabalhadorPK.registro, " + " CASE " + "\tWHEN t.aposentado = true THEN '3' " + "\tWHEN t.pensionista = true THEN '2' " + "\tELSE '1' end, " + " evtc.simap, ev.nome, m.valor, " + " CASE WHEN m.natureza = 'D' THEN 'N' ELSE 'P' END) " + " FROM Referencia r " + " LEFT JOIN r.movimentoList m " + " LEFT JOIN m.entidade e " + " LEFT JOIN e.tcePr etc " + " LEFT JOIN m.trabalhador t " + " LEFT JOIN t.aposentadoInativo a " + " LEFT JOIN m.evento ev " + " LEFT JOIN ev.tcePr evtc " + " WHERE etc.pessoaId = :codigoTcePr " + " AND r.ano = :ano " + " AND r.mesCodigo = :mes " + " AND r.codigo = :referencia " + " AND r.situacao = :normal " + " AND m.classificacao not in (:classificacoes) " + " AND m.natureza <> 'V' ";
    }
}

